/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.misc;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.ConfigurationPrinter;
import org.apache.felix.webconsole.internal.BaseWebConsolePlugin;
import org.apache.felix.webconsole.internal.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;

public class ConfigurationRender
extends BaseWebConsolePlugin {
    public static final String LABEL = "config";
    public static final String TITLE = "Configuration Status";
    private static final String[] CSS_REFS = new String[]{"res/ui/configurationrender.css"};
    private static final SimpleDateFormat FILE_NAME_FORMAT = new SimpleDateFormat("'config/configuration-status-'yyyyMMdd'-'HHmmZ");
    private static final DateFormat DISPLAY_DATE_FORMAT = SimpleDateFormat.getDateTimeInstance(1, 1, Locale.US);
    private ServiceTracker cfgPrinterTracker;
    private int cfgPrinterTrackerCount;
    private SortedMap configurationPrinters = new TreeMap();

    public String getTitle() {
        return TITLE;
    }

    public String getLabel() {
        return LABEL;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        if (request.getPathInfo().endsWith(".txt")) {
            response.setContentType("text/plain; charset=utf-8");
            PlainTextConfigurationWriter pw = new PlainTextConfigurationWriter(response.getWriter());
            this.printConfigurationStatus(pw);
            pw.flush();
        } else if (request.getPathInfo().endsWith(".zip")) {
            String type = this.getServletContext().getMimeType(request.getPathInfo());
            if (type == null) {
                type = "application/x-zip";
            }
            response.setContentType(type);
            ZipOutputStream zip = new ZipOutputStream((OutputStream)response.getOutputStream());
            zip.setLevel(9);
            zip.setMethod(8);
            ZipConfigurationWriter pw = new ZipConfigurationWriter(zip);
            this.printConfigurationStatus(pw);
            pw.flush();
            zip.finish();
        } else {
            super.doGet(request, response);
        }
    }

    protected String[] getCssReferences() {
        return CSS_REFS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HtmlConfigurationWriter pw = new HtmlConfigurationWriter(response.getWriter());
        String appRoot = (String)request.getAttribute("felix.webconsole.appRoot");
        Util.script(pw, appRoot, "tw-1.1.js");
        Util.startScript(pw);
        pw.println("    $(document).ready(function(){");
        pw.println("        $('#cfgprttabs').tabworld({speed:0});");
        pw.println("        $('#divcfgprttabs').removeClass('divcfgprttabshidden');");
        pw.println("        $('#divcfgprttabswait').addClass('divcfgprttabshidden');");
        pw.println("    });");
        Util.endScript(pw);
        Date currentTime = new Date();
        DateFormat dateFormat = DISPLAY_DATE_FORMAT;
        synchronized (dateFormat) {
            pw.println("<p>Date: " + DISPLAY_DATE_FORMAT.format(currentTime) + "</p>");
        }
        dateFormat = FILE_NAME_FORMAT;
        synchronized (dateFormat) {
            String fileName = FILE_NAME_FORMAT.format(currentTime);
            pw.println("<p>Download as <a href='" + fileName + ".txt'>[Single File]</a> or as <a href='" + fileName + ".zip'>[ZIP]</a></p>");
        }
        pw.println("<div id='divcfgprttabswait'>Loading status information. Please wait....</div>");
        pw.println("<div id='divcfgprttabs' class='divcfgprttabshidden'>");
        pw.println("<ul id='cfgprttabs'>");
        this.printConfigurationStatus(pw);
        pw.println("</ul>");
        pw.println("</div>");
        pw.flush();
    }

    private void printConfigurationStatus(ConfigurationWriter pw) {
        this.printSystemProperties(pw);
        this.printServices(pw);
        this.printThreads(pw);
        Iterator cpi = this.getConfigurationPrinters().iterator();
        while (cpi.hasNext()) {
            this.printConfigurationPrinter(pw, (ConfigurationPrinter)cpi.next());
        }
    }

    private Collection getConfigurationPrinters() {
        if (this.cfgPrinterTracker == null) {
            this.cfgPrinterTracker = new ServiceTracker(this.getBundleContext(), ConfigurationPrinter.SERVICE, null);
            this.cfgPrinterTracker.open();
            this.cfgPrinterTrackerCount = -1;
        }
        if (this.cfgPrinterTrackerCount != this.cfgPrinterTracker.getTrackingCount()) {
            TreeMap<String, ConfigurationPrinter> cp = new TreeMap<String, ConfigurationPrinter>();
            Object[] services = this.cfgPrinterTracker.getServices();
            if (services != null) {
                for (int i = 0; i < services.length; ++i) {
                    Object srv = services[i];
                    ConfigurationPrinter cfgPrinter = (ConfigurationPrinter)srv;
                    cp.put(cfgPrinter.getTitle(), cfgPrinter);
                }
            }
            this.configurationPrinters = cp;
            this.cfgPrinterTrackerCount = this.cfgPrinterTracker.getTrackingCount();
        }
        return this.configurationPrinters.values();
    }

    private void printSystemProperties(ConfigurationWriter pw) {
        pw.title("System properties");
        Properties props = System.getProperties();
        TreeSet<Object> keys = new TreeSet<Object>(props.keySet());
        Iterator ki = keys.iterator();
        while (ki.hasNext()) {
            Object key = ki.next();
            ConfigurationRender.infoLine(pw, null, (String)key, props.get(key));
        }
        pw.end();
    }

    private void printServices(ConfigurationWriter pw) {
        pw.title("Services");
        TreeMap<Object, ServiceReference> srMap = new TreeMap<Object, ServiceReference>();
        try {
            ServiceReference[] srs = this.getBundleContext().getAllServiceReferences(null, null);
            for (int i = 0; i < srs.length; ++i) {
                srMap.put(srs[i].getProperty("service.id"), srs[i]);
            }
        }
        catch (InvalidSyntaxException ise) {
            // empty catch block
        }
        Iterator si = srMap.values().iterator();
        while (si.hasNext()) {
            ServiceReference sr = (ServiceReference)si.next();
            ConfigurationRender.infoLine(pw, null, String.valueOf(sr.getProperty("service.id")), sr.getProperty("objectClass"));
            ConfigurationRender.infoLine(pw, "  ", "Bundle", this.getBundleString(sr.getBundle()));
            Bundle[] users = sr.getUsingBundles();
            if (users != null && users.length > 0) {
                for (int i = 0; i < users.length; ++i) {
                    ConfigurationRender.infoLine(pw, "  ", "Using Bundle", this.getBundleString(users[i]));
                }
            }
            Object[] keys = sr.getPropertyKeys();
            Arrays.sort(keys);
            for (int i = 0; i < keys.length; ++i) {
                if ("service.id".equals(keys[i]) || "objectClass".equals(keys[i])) continue;
                ConfigurationRender.infoLine(pw, "  ", (String)keys[i], sr.getProperty((String)keys[i]));
            }
            pw.println();
        }
        pw.end();
    }

    private void printConfigurationPrinter(ConfigurationWriter pw, ConfigurationPrinter cp) {
        pw.title(cp.getTitle());
        cp.printConfiguration(pw);
        pw.end();
    }

    public static void infoLine(PrintWriter pw, String indent, String label, Object value) {
        if (indent != null) {
            pw.print(indent);
        }
        if (label != null) {
            pw.print(label);
            pw.print('=');
        }
        ConfigurationRender.printObject(pw, value);
        pw.println();
    }

    private static void printObject(PrintWriter pw, Object value) {
        if (value == null) {
            pw.print("null");
        } else if (value.getClass().isArray()) {
            ConfigurationRender.printArray(pw, (Object[])value);
        } else {
            pw.print(value);
        }
    }

    private static void printArray(PrintWriter pw, Object[] values) {
        pw.print('[');
        if (values != null && values.length > 0) {
            for (int i = 0; i < values.length; ++i) {
                if (i > 0) {
                    pw.print(", ");
                }
                ConfigurationRender.printObject(pw, values[i]);
            }
        }
        pw.print(']');
    }

    private String getBundleString(Bundle bundle) {
        StringBuffer buf = new StringBuffer();
        if (bundle.getSymbolicName() != null) {
            buf.append(bundle.getSymbolicName());
        } else if (bundle.getLocation() != null) {
            buf.append(bundle.getLocation());
        } else {
            buf.append(bundle.getBundleId());
        }
        Dictionary headers = bundle.getHeaders();
        if (headers.get("Bundle-Version") != null) {
            buf.append(" (").append(headers.get("Bundle-Version")).append(')');
        }
        if (headers.get("Bundle-Name") != null) {
            buf.append(" \"").append(headers.get("Bundle-Name")).append('\"');
        }
        return buf.toString();
    }

    private void printThreads(ConfigurationWriter pw) {
        ThreadGroup rootGroup = Thread.currentThread().getThreadGroup();
        while (rootGroup.getParent() != null) {
            rootGroup = rootGroup.getParent();
        }
        pw.title("Threads");
        this.printThreadGroup(pw, rootGroup);
        int numGroups = rootGroup.activeGroupCount();
        ThreadGroup[] groups = new ThreadGroup[2 * numGroups];
        rootGroup.enumerate(groups);
        for (int i = 0; i < groups.length; ++i) {
            this.printThreadGroup(pw, groups[i]);
        }
        pw.end();
    }

    private void printThreadGroup(PrintWriter pw, ThreadGroup group) {
        if (group != null) {
            StringBuffer info = new StringBuffer();
            info.append("ThreadGroup ").append(group.getName());
            info.append(" [");
            info.append("maxprio=").append(group.getMaxPriority());
            info.append(", parent=");
            if (group.getParent() != null) {
                info.append(group.getParent().getName());
            } else {
                info.append('-');
            }
            info.append(", isDaemon=").append(group.isDaemon());
            info.append(", isDestroyed=").append(group.isDestroyed());
            info.append(']');
            ConfigurationRender.infoLine(pw, null, null, info.toString());
            int numThreads = group.activeCount();
            Thread[] threads = new Thread[numThreads * 2];
            group.enumerate(threads, false);
            for (int i = 0; i < threads.length; ++i) {
                this.printThread(pw, threads[i]);
            }
            pw.println();
        }
    }

    private void printThread(PrintWriter pw, Thread thread) {
        if (thread != null) {
            StringBuffer info = new StringBuffer();
            info.append("Thread ").append(thread.getName());
            info.append(" [");
            info.append("priority=").append(thread.getPriority());
            info.append(", alive=").append(thread.isAlive());
            info.append(", daemon=").append(thread.isDaemon());
            info.append(", interrupted=").append(thread.isInterrupted());
            info.append(", loader=").append(thread.getContextClassLoader());
            info.append(']');
            ConfigurationRender.infoLine(pw, "  ", null, info.toString());
        }
    }

    private static class ZipConfigurationWriter
    extends ConfigurationWriter {
        private final ZipOutputStream zip;
        private int counter;

        ZipConfigurationWriter(ZipOutputStream zip) {
            super(new OutputStreamWriter(zip));
            this.zip = zip;
        }

        public void title(String title) {
            String name = MessageFormat.format("{0,number,000}-{1}.txt", new Integer(this.counter), title);
            ++this.counter;
            ZipEntry entry = new ZipEntry(name);
            try {
                this.zip.putNextEntry(entry);
            }
            catch (IOException ioe) {
                // empty catch block
            }
        }

        public void end() {
            this.flush();
            try {
                this.zip.closeEntry();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static class PlainTextConfigurationWriter
    extends ConfigurationWriter {
        PlainTextConfigurationWriter(Writer delegatee) {
            super(delegatee);
        }

        public void title(String title) {
            this.print("*** ");
            this.print(title);
            this.println(":");
        }

        public void end() {
            this.println();
        }
    }

    private static class HtmlConfigurationWriter
    extends ConfigurationWriter {
        private boolean doFilter;

        HtmlConfigurationWriter(Writer delegatee) {
            super(delegatee);
        }

        public void title(String title) {
            this.println("<li>");
            this.println(title);
            this.println("<q>");
            this.doFilter = true;
        }

        public void end() {
            this.doFilter = false;
            this.println("</q>");
            this.println("</li>");
        }

        public void println() {
            if (this.doFilter) {
                super.write("<br/>", 0, 5);
            } else {
                super.println();
            }
        }

        public void write(int character) {
            if (this.doFilter && character == 60) {
                super.write("&lt;");
            } else {
                super.write(character);
            }
        }

        public void write(char[] chars, int off, int len) {
            if (this.doFilter) {
                this.writeFiltered(new String(chars, off, len));
            } else {
                super.write(chars, off, len);
            }
        }

        public void write(String string, int off, int len) {
            if (this.doFilter) {
                this.writeFiltered(string.substring(off, len));
            } else {
                super.write(string, off, len);
            }
        }

        private void writeFiltered(String string) {
            if (string.indexOf(60) >= 0) {
                super.write(string.replaceAll("<", "&lt;"));
            } else {
                super.write(string, 0, string.length());
            }
        }
    }

    private static abstract class ConfigurationWriter
    extends PrintWriter {
        ConfigurationWriter(Writer delegatee) {
            super(delegatee);
        }

        abstract void title(String var1);

        abstract void end();
    }
}

