/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.misc;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.internal.BaseWebConsolePlugin;
import org.apache.felix.webconsole.internal.Util;
import org.apache.felix.webconsole.internal.servlet.OsgiManager;
import org.json.JSONException;
import org.json.JSONWriter;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleEvent;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceRegistration;
import org.osgi.service.event.Event;
import org.osgi.service.event.EventAdmin;
import org.osgi.service.event.EventHandler;

public class EventAdminServlet
extends BaseWebConsolePlugin
implements EventHandler {
    public static final String LABEL = "events";
    public static final String TITLE = "Event Admin";
    private int maxSize = 50;
    private final List events = new ArrayList();
    private final Map eventRenderers = new HashMap();
    private ServiceRegistration eventReceiver;
    static /* synthetic */ Class class$org$osgi$framework$ServiceEvent;
    static /* synthetic */ Class class$org$osgi$framework$BundleEvent;
    static /* synthetic */ Class class$org$osgi$service$event$EventHandler;
    static /* synthetic */ Class class$org$osgi$service$event$EventAdmin;

    public EventAdminServlet() {
        this.eventRenderers.put((class$org$osgi$framework$ServiceEvent == null ? (class$org$osgi$framework$ServiceEvent = EventAdminServlet.class$("org.osgi.framework.ServiceEvent")) : class$org$osgi$framework$ServiceEvent).getName().replace('.', '/') + "/", new ServiceEventInfoProvider());
        this.eventRenderers.put((class$org$osgi$framework$BundleEvent == null ? (class$org$osgi$framework$BundleEvent = EventAdminServlet.class$("org.osgi.framework.BundleEvent")) : class$org$osgi$framework$BundleEvent).getName().replace('.', '/') + "/", new BundleEventInfoProvider());
    }

    public String getLabel() {
        return LABEL;
    }

    public String getTitle() {
        return TITLE;
    }

    public void activate(BundleContext context) {
        super.activate(context);
        this.events.clear();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("service.description", "EventAdmin plugin for the Felix Web Console");
        ((Dictionary)props).put("service.vendor", "The Apache Software Foundation");
        ((Dictionary)props).put("event.topics", "*");
        this.eventReceiver = context.registerService((class$org$osgi$service$event$EventHandler == null ? (class$org$osgi$service$event$EventHandler = EventAdminServlet.class$("org.osgi.service.event.EventHandler")) : class$org$osgi$service$event$EventHandler).getName(), (Object)this, props);
    }

    public void deactivate() {
        if (this.eventReceiver != null) {
            this.eventReceiver.unregister();
            this.eventReceiver = null;
        }
        this.events.clear();
        super.deactivate();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleEvent(Event event) {
        if (!event.getTopic().startsWith("org/osgi/service/log")) {
            List list = this.events;
            synchronized (list) {
                this.events.add(new EventInfo(event));
                if (this.events.size() > this.maxSize) {
                    this.events.remove(0);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String action = EventAdminServlet.getParameter(req, "action");
        if ("clear".equals(action)) {
            List list = this.events;
            synchronized (list) {
                this.events.clear();
            }
        }
        resp.setContentType("application/json");
        resp.setCharacterEncoding("utf-8");
        this.renderJSON(resp.getWriter());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void renderJSON(PrintWriter pw) throws IOException {
        ArrayList copiedEvents;
        List list = this.events;
        synchronized (list) {
            copiedEvents = new ArrayList(this.events);
        }
        EventAdmin admin = (EventAdmin)this.getService((class$org$osgi$service$event$EventAdmin == null ? (class$org$osgi$service$event$EventAdmin = EventAdminServlet.class$("org.osgi.service.event.EventAdmin")) : class$org$osgi$service$event$EventAdmin).getName());
        StringBuffer statusLine = new StringBuffer();
        if (admin == null) {
            statusLine.append("Event Admin is not installed/running.");
        } else {
            statusLine.append("Event Admin is running.");
        }
        statusLine.append(" ");
        statusLine.append(copiedEvents.size());
        statusLine.append(" Events received");
        if (!copiedEvents.isEmpty()) {
            statusLine.append(" since ");
            Date d = new Date();
            d.setTime(((EventInfo)copiedEvents.get((int)0)).received);
            statusLine.append(d);
        }
        statusLine.append(".");
        JSONWriter jw = new JSONWriter((Writer)pw);
        try {
            jw.object();
            jw.key("status");
            jw.value((Object)statusLine);
            jw.key("data");
            jw.array();
            for (int index = copiedEvents.size() - 1; index >= 0; --index) {
                this.eventJson(jw, (EventInfo)copiedEvents.get(index), index);
            }
            jw.endArray();
            jw.endObject();
        }
        catch (JSONException je) {
            throw new IOException(je.toString());
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        String info = request.getPathInfo();
        if (info.endsWith(".json")) {
            response.setContentType("text/javascript");
            response.setCharacterEncoding("UTF-8");
            PrintWriter pw = response.getWriter();
            this.renderJSON(pw);
            return;
        }
        super.doGet(request, response);
    }

    protected void renderContent(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        PrintWriter pw = response.getWriter();
        String appRoot = (String)request.getAttribute(OsgiManager.ATTR_APP_ROOT);
        pw.println("<script src='" + appRoot + "/res/ui/jquery-1.2.6.min.js' language='JavaScript'></script>");
        pw.println("<script src='" + appRoot + "/res/ui/jquery.tablesorter-2.0.3.min.js' language='JavaScript'></script>");
        pw.println("<script src='" + appRoot + "/res/ui/events.js' language='JavaScript'></script>");
        Util.startScript(pw);
        pw.println("renderEvents( );");
        Util.endScript(pw);
    }

    private void eventJson(JSONWriter jw, EventInfo info, int index) throws JSONException {
        Event e = info.event;
        Iterator iter = this.eventRenderers.entrySet().iterator();
        String infoText = null;
        while (infoText == null && iter.hasNext()) {
            Map.Entry entry = iter.next();
            if (!e.getTopic().startsWith(entry.getKey().toString())) continue;
            infoText = ((EventInfoProvider)entry.getValue()).getInfo(e);
        }
        jw.object();
        jw.key("id");
        jw.value((Object)String.valueOf(index));
        jw.key("received");
        jw.value(info.received);
        jw.key("topic");
        jw.value((Object)e.getTopic());
        if (infoText != null) {
            jw.key("info");
            jw.value((Object)infoText);
        }
        jw.key("properties");
        jw.object();
        String[] names = e.getPropertyNames();
        if (names != null && names.length > 0) {
            for (int i = 0; i < names.length; ++i) {
                jw.key(names[i]);
                jw.value((Object)e.getProperty(names[i]).toString());
            }
        }
        jw.endObject();
        jw.endObject();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static final class BundleEventInfoProvider
    implements EventInfoProvider {
        private BundleEventInfoProvider() {
        }

        public String getInfo(Event event) {
            BundleEvent bundleEvent = (BundleEvent)event.getProperty("event");
            if (bundleEvent == null) {
                return null;
            }
            StringBuffer buffer = new StringBuffer("Bundle ");
            buffer.append(bundleEvent.getBundle().getSymbolicName());
            buffer.append(' ');
            switch (bundleEvent.getType()) {
                case 1: {
                    buffer.append("installed");
                    break;
                }
                case 32: {
                    buffer.append("resolved");
                    break;
                }
                case 2: {
                    buffer.append("started");
                    break;
                }
                case 128: {
                    buffer.append("starting");
                    break;
                }
                case 4: {
                    buffer.append("stopped");
                    break;
                }
                case 256: {
                    buffer.append("stopping");
                    break;
                }
                case 16: {
                    buffer.append("uninstalled");
                    break;
                }
                case 64: {
                    buffer.append("unresolved");
                    break;
                }
                case 8: {
                    buffer.append("updated");
                    break;
                }
                default: {
                    return null;
                }
            }
            return buffer.toString();
        }
    }

    private static final class ServiceEventInfoProvider
    implements EventInfoProvider {
        private ServiceEventInfoProvider() {
        }

        public String getInfo(Event event) {
            ServiceEvent serviceEvent = (ServiceEvent)event.getProperty("event");
            if (serviceEvent == null) {
                return null;
            }
            StringBuffer buffer = new StringBuffer("Service ");
            buffer.append(serviceEvent.getServiceReference().getProperty("service.id"));
            buffer.append(' ');
            switch (serviceEvent.getType()) {
                case 1: {
                    buffer.append("registered");
                    break;
                }
                case 2: {
                    buffer.append("modified");
                    break;
                }
                case 4: {
                    buffer.append("unregistering");
                    break;
                }
                default: {
                    return null;
                }
            }
            return buffer.toString();
        }
    }

    private static interface EventInfoProvider {
        public String getInfo(Event var1);
    }

    private static final class EventInfo {
        public final Event event;
        public final long received;

        public EventInfo(Event e) {
            this.event = e;
            this.received = System.currentTimeMillis();
        }
    }
}

