/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.core;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.Render;
import org.apache.felix.webconsole.internal.BaseManagementPlugin;
import org.apache.felix.webconsole.internal.Util;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.util.tracker.ServiceTracker;

public class BundleListRender
extends BaseManagementPlugin
implements Render {
    public static final String NAME = "list";
    public static final String LABEL = "Bundles";
    public static final String BUNDLE_ID = "bundleId";
    private static final String INSTALLER_SERVICE_NAME = "org.apache.sling.osgi.assembly.installer.InstallerService";
    private ServiceTracker installerService;
    private static final Comparator BUNDLE_NAME_COMPARATOR = new Comparator(){

        public int compare(Object o1, Object o2) {
            return this.compare((Bundle)o1, (Bundle)o2);
        }

        public int compare(Bundle b1, Bundle b2) {
            Version v2;
            if (b1 == b2 || b1.getBundleId() == b2.getBundleId()) {
                return 0;
            }
            if (b1.getBundleId() == 0L) {
                return -1;
            }
            if (b2.getBundleId() == 0L) {
                return 1;
            }
            int snComp = BundleListRender.getName(b1).compareToIgnoreCase(BundleListRender.getName(b2));
            if (snComp != 0) {
                return snComp;
            }
            Version v1 = Version.parseVersion((String)((String)b1.getHeaders().get("Bundle-Version")));
            int vComp = v1.compareTo((Object)(v2 = Version.parseVersion((String)((String)b2.getHeaders().get("Bundle-Version")))));
            if (vComp != 0) {
                return vComp;
            }
            if (b1.getBundleId() < b2.getBundleId()) {
                return -1;
            }
            return 1;
        }
    };

    public void setBundleContext(BundleContext bundleContext) {
        super.setBundleContext(bundleContext);
        this.installerService = new ServiceTracker(bundleContext, INSTALLER_SERVICE_NAME, null);
        this.installerService.open();
    }

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return LABEL;
    }

    public void render(HttpServletRequest request, HttpServletResponse response) throws IOException {
        PrintWriter pw = response.getWriter();
        this.header(pw);
        this.installForm(pw);
        pw.println("<tr class='content'>");
        pw.println("<td colspan='7' class='content'>&nbsp;</th>");
        pw.println("</tr>");
        this.tableHeader(pw);
        Bundle[] bundles = this.getBundles();
        if (bundles == null || bundles.length == 0) {
            pw.println("<tr class='content'>");
            pw.println("<td class='content' colspan='6'>No " + this.getLabel() + " installed currently</td>");
            pw.println("</tr>");
        } else {
            this.sort(bundles);
            long previousBundle = -1L;
            for (int i = 0; i < bundles.length; ++i) {
                if (previousBundle >= 0L) {
                    pw.println("<tr id='bundle" + previousBundle + "'></tr>");
                }
                this.bundle(pw, bundles[i]);
                previousBundle = bundles[i].getBundleId();
            }
            if (previousBundle >= 0L) {
                pw.println("<tr id='bundle" + previousBundle + "'></tr>");
            }
        }
        pw.println("<tr class='content'>");
        pw.println("<td colspan='7' class='content'>&nbsp;</th>");
        pw.println("</tr>");
        this.installForm(pw);
        this.footer(pw);
    }

    protected Bundle[] getBundles() {
        return this.getBundleContext().getBundles();
    }

    private void header(PrintWriter pw) {
        Util.startScript(pw);
        pw.println("function showDetails(bundleId) {");
        pw.println("    var span = document.getElementById('bundle' + bundleId);");
        pw.println("    if (!span) {");
        pw.println("        return;");
        pw.println("    }");
        pw.println("    if (span.innerHTML) {");
        pw.println("        span.innerHTML = '';");
        pw.println("        return;");
        pw.println("    }");
        pw.println("    var parm = '?action=ajaxBundleDetails&bundleId=' + bundleId;");
        pw.println("    sendRequest('GET', parm, displayBundleDetails);");
        pw.println("}");
        pw.println("function displayBundleDetails(obj) {");
        pw.println("    var span = document.getElementById('bundle' + obj.bundleId);");
        pw.println("    if (!span) {");
        pw.println("        return;");
        pw.println("    }");
        pw.println("    var innerHtml = '<td class=\"content\">&nbsp;</td><td class=\"content\" colspan=\"6\"><table broder=\"0\">';");
        pw.println("    var props = obj.props;");
        pw.println("    for (var i=0; i < props.length; i++) {");
        pw.println("        innerHtml += '<tr><td valign=\"top\" noWrap>' + props[i].key + '</td><td valign=\"top\">' + props[i].value + '</td></tr>';");
        pw.println("    }");
        pw.println("    innerHtml += '</table></td>';");
        pw.println("    span.innerHTML = innerHtml;");
        pw.println("}");
        Util.endScript(pw);
        pw.println("<table class='content' cellpadding='0' cellspacing='0' width='100%'>");
    }

    private void tableHeader(PrintWriter pw) {
        pw.println("<tr class='content'>");
        pw.println("<th class='content'>ID</th>");
        pw.println("<th class='content' width='100%'>Name</th>");
        pw.println("<th class='content'>Status</th>");
        pw.println("<th class='content' colspan='4'>Actions</th>");
        pw.println("</tr>");
    }

    private void footer(PrintWriter pw) {
        pw.println("</table>");
    }

    private void bundle(PrintWriter pw, Bundle bundle) {
        String name = BundleListRender.getName(bundle);
        pw.println("<tr>");
        pw.println("<td class='content right'>" + bundle.getBundleId() + "</td>");
        pw.println("<td class='content'><a href='javascript:showDetails(" + bundle.getBundleId() + ")'>" + name + "</a></td>");
        pw.println("<td class='content center'>" + this.toStateString(bundle.getState()) + "</td>");
        if (bundle.getBundleId() == 0L) {
            pw.println("<td class='content' colspan='4'>&nbsp;</td>");
        } else {
            boolean enabled = bundle.getState() == 2 || bundle.getState() == 4;
            this.actionForm(pw, enabled, bundle.getBundleId(), "start", "Start");
            enabled = bundle.getState() == 32;
            this.actionForm(pw, enabled, bundle.getBundleId(), "stop", "Stop");
            enabled = bundle.getState() != 1 && this.hasUpdates(bundle);
            this.actionForm(pw, enabled, bundle.getBundleId(), "update", "Update");
            enabled = bundle.getState() == 2 || bundle.getState() == 4 || bundle.getState() == 32;
            this.actionForm(pw, enabled, bundle.getBundleId(), "uninstall", "Uninstall");
        }
        pw.println("</tr>");
    }

    private void actionForm(PrintWriter pw, boolean enabled, long bundleId, String action, String actionLabel) {
        pw.println("<form name='form" + bundleId + "' method='post'>");
        pw.println("<td class='content' align='right'>");
        pw.println("<input type='hidden' name='action' value='" + action + "' />");
        pw.println("<input type='hidden' name='bundleId' value='" + bundleId + "' />");
        pw.println("<input class='submit' type='submit' value='" + actionLabel + "'" + (enabled ? "" : "disabled") + " />");
        pw.println("</td>");
        pw.println("</form>");
    }

    private void installForm(PrintWriter pw) {
        int startLevel = this.getStartLevel().getInitialBundleStartLevel();
        pw.println("<form method='post' enctype='multipart/form-data'>");
        pw.println("<tr class='content'>");
        pw.println("<td class='content'>&nbsp;</td>");
        pw.println("<td class='content'>");
        pw.println("<input type='hidden' name='action' value='install' />");
        pw.println("<input class='input' type='file' name='bundlefile'>");
        pw.println(" - Start <input class='checkradio' type='checkbox' name='bundlestart' value='start'>");
        pw.println(" - Start Level <input class='input' type='input' name='bundlestartlevel' value='" + startLevel + "' width='4'>");
        pw.println("</td>");
        pw.println("<td class='content' align='right' colspan='5' noWrap>");
        pw.println("<input class='submit' style='width:auto' type='submit' value='Install or Update'>");
        pw.println("&nbsp;");
        pw.println("<input class='submit' style='width:auto' type='submit' value='Refresh Packages' onClick='this.form[\"action\"].value=\"refreshPackages\"; return true;'>");
        pw.println("</td>");
        pw.println("</tr>");
        pw.println("</form>");
    }

    private String toStateString(int bundleState) {
        switch (bundleState) {
            case 2: {
                return "Installed";
            }
            case 4: {
                return "Resolved";
            }
            case 8: {
                return "Starting";
            }
            case 32: {
                return "Active";
            }
            case 16: {
                return "Stopping";
            }
            case 1: {
                return "Uninstalled";
            }
        }
        return "Unknown: " + bundleState;
    }

    private boolean hasUpdates(Bundle bundle) {
        Object isObject = this.installerService.getService();
        if (isObject == null) {
            return false;
        }
        if (bundle.getSymbolicName() == null) {
            return false;
        }
        return false;
    }

    private void sort(Bundle[] bundles) {
        Arrays.sort(bundles, BUNDLE_NAME_COMPARATOR);
    }

    private static String getName(Bundle bundle) {
        String name = (String)bundle.getHeaders().get("Bundle-Name");
        if ((name == null || name.length() == 0) && (name = bundle.getSymbolicName()) == null && (name = bundle.getLocation()) == null) {
            name = String.valueOf(bundle.getBundleId());
        }
        return name;
    }
}

