/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.webconsole.internal.compendium;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.felix.webconsole.Action;
import org.apache.felix.webconsole.internal.compendium.ConfigManagerBase;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.Version;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.service.metatype.AttributeDefinition;
import org.osgi.service.metatype.ObjectClassDefinition;

public class AjaxConfigManagerAction
extends ConfigManagerBase
implements Action {
    public static final String NAME = "ajaxConfigManager";

    public String getName() {
        return NAME;
    }

    public String getLabel() {
        return NAME;
    }

    public boolean performAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean isFactory;
        if (request.getParameter("apply") != null) {
            return this.applyConfiguration(request);
        }
        JSONObject result = new JSONObject();
        String pid = request.getParameter("pid");
        boolean bl = isFactory = pid == null;
        if (isFactory) {
            pid = request.getParameter("factoryPid");
        }
        if (pid != null) {
            try {
                this.configForm(result, pid, isFactory, this.getLocale(request));
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        response.setContentType("text/javascript");
        response.getWriter().print(result.toString());
        return false;
    }

    private void configForm(JSONObject json, String pid, boolean isFactory, Locale loc) throws IOException, JSONException {
        ObjectClassDefinition ocd;
        String locale = loc == null ? null : loc.toString();
        ConfigurationAdmin ca = this.getConfigurationAdmin();
        if (ca == null) {
            return;
        }
        Configuration config = null;
        try {
            Configuration[] configs = ca.listConfigurations("(service.pid=" + pid + ")");
            if (configs != null && configs.length > 0) {
                config = configs[0];
            }
        }
        catch (InvalidSyntaxException ise) {
            return;
        }
        json.put("pid", pid);
        json.put("isFactory", isFactory);
        Dictionary props = null;
        if (config != null) {
            props = config.getProperties();
            ocd = this.getObjectClassDefinition(config, locale);
        } else {
            ocd = this.getObjectClassDefinition(pid, locale);
        }
        props = this.mergeWithMetaType(props, ocd, json);
        if (props != null) {
            JSONObject properties = new JSONObject();
            Enumeration pe = props.keys();
            while (pe.hasMoreElements()) {
                Object key = pe.nextElement();
                if (key.equals("service.pid") || key.equals("service.description") || key.equals("service.id") || key.equals("service.ranking") || key.equals("service.vendor") || key.equals("service.bundleLocation") || key.equals("service.factoryPid")) continue;
                properties.put(String.valueOf(key), props.get(key));
            }
            json.put("title", pid);
            json.put("description", "Please enter configuration properties for this configuration in the field below. This configuration has no associated description");
            json.put("propertylist", "properties");
            json.put("properties", properties);
        }
        if (config != null) {
            this.addConfigurationInfo(config, json, locale);
        }
    }

    private Dictionary mergeWithMetaType(Dictionary props, ObjectClassDefinition ocd, JSONObject json) throws JSONException {
        if (props == null) {
            props = new Hashtable();
        }
        if (ocd != null) {
            AttributeDefinition[] ad;
            json.put("title", ocd.getName());
            if (ocd.getDescription() != null) {
                json.put("description", ocd.getDescription());
            }
            if ((ad = ocd.getAttributeDefinitions(-1)) != null) {
                JSONArray propertyList = new JSONArray();
                for (int i = 0; i < ad.length; ++i) {
                    JSONObject entry = new JSONObject();
                    Object value = ((Dictionary)props).get(ad[i].getID());
                    if (value == null && (value = ad[i].getDefaultValue()) == null) {
                        value = ad[i].getCardinality() == 0 ? "" : new String[]{};
                    }
                    entry.put("name", ad[i].getName());
                    if (ad[i].getOptionLabels() != null && ad[i].getOptionLabels().length > 0) {
                        JSONObject type = new JSONObject();
                        type.put("labels", Arrays.asList(ad[i].getOptionLabels()));
                        type.put("values", Arrays.asList(ad[i].getOptionValues()));
                        entry.put("type", type);
                    } else {
                        entry.put("type", ad[i].getType());
                    }
                    if (ad[i].getCardinality() == 0) {
                        if (value instanceof Vector) {
                            value = ((Vector)value).get(0);
                        } else if (value.getClass().isArray()) {
                            value = Array.get(value, 0);
                        }
                        entry.put("value", value);
                    } else {
                        if (value instanceof Vector) {
                            value = new JSONArray((Vector)value);
                        } else if (value.getClass().isArray()) {
                            value = new JSONArray(Arrays.asList((Object[])value));
                        } else {
                            JSONArray tmp = new JSONArray();
                            tmp.put(value);
                            value = tmp;
                        }
                        entry.put("values", value);
                    }
                    if (ad[i].getDescription() != null) {
                        entry.put("description", ad[i].getDescription());
                    }
                    json.put(ad[i].getID(), entry);
                    propertyList.put(ad[i].getID());
                }
                json.put("propertylist", propertyList);
            }
            props = null;
        }
        return props;
    }

    private void addConfigurationInfo(Configuration config, JSONObject json, String locale) throws JSONException {
        String location;
        if (config.getFactoryPid() != null) {
            json.put("factoryPID", config.getFactoryPid());
        }
        if (config.getBundleLocation() == null) {
            location = "None";
        } else {
            Bundle bundle = this.getBundle(config.getBundleLocation());
            Dictionary headers = bundle.getHeaders(locale);
            String name = (String)headers.get("Bundle-Name");
            location = name == null ? bundle.getSymbolicName() : name + " (" + bundle.getSymbolicName() + ")";
            Version v = Version.parseVersion((String)((String)headers.get("Bundle-Version")));
            location = location + ", Version " + v.toString();
        }
        json.put("bundleLocation", location);
    }

    private boolean applyConfiguration(HttpServletRequest request) throws IOException {
        ConfigurationAdmin ca = this.getConfigurationAdmin();
        if (ca == null) {
            return false;
        }
        String pid = request.getParameter("pid");
        if (request.getParameter("delete") != null) {
            Configuration config = ca.getConfiguration(pid, null);
            config.delete();
            return true;
        }
        if (request.getParameter("create") != null) {
            Configuration config = ca.createFactoryConfiguration(pid, null);
            return true;
        }
        String propertyList = request.getParameter("propertylist");
        if (propertyList == null) {
            String propertiesString = request.getParameter("properties");
            if (propertiesString != null) {
                byte[] propBytes = propertiesString.getBytes("ISO-8859-1");
                ByteArrayInputStream bin = new ByteArrayInputStream(propBytes);
                Properties props = new Properties();
                props.load(bin);
                Configuration config = ca.getConfiguration(pid, null);
                config.update((Dictionary)props);
            }
        } else {
            Map adMap;
            Configuration config = ca.getConfiguration(pid, null);
            Hashtable<String, Object> props = config.getProperties();
            if (props == null) {
                props = new Hashtable<String, Object>();
            }
            if ((adMap = this.getAttributeDefinitionMap(config, null)) != null) {
                StringTokenizer propTokens = new StringTokenizer(propertyList, ",");
                while (propTokens.hasMoreTokens()) {
                    String prop;
                    String propName = propTokens.nextToken();
                    AttributeDefinition ad = (AttributeDefinition)adMap.get(propName);
                    if (ad == null || ad.getCardinality() == 0 && ad.getType() == 1) {
                        prop = request.getParameter(propName);
                        if (prop == null) continue;
                        ((Dictionary)props).put(propName, prop);
                        continue;
                    }
                    if (ad.getCardinality() == 0) {
                        prop = request.getParameter(propName);
                        ((Dictionary)props).put(propName, this.toType(ad.getType(), prop));
                        continue;
                    }
                    Vector<Object> vec = new Vector<Object>();
                    String[] properties = request.getParameterValues(propName);
                    if (properties != null) {
                        for (int i = 0; i < properties.length; ++i) {
                            vec.add(this.toType(ad.getType(), properties[i]));
                        }
                    }
                    int maxSize = Math.abs(ad.getCardinality());
                    if (vec.size() > maxSize) {
                        vec.setSize(maxSize);
                    }
                    if (ad.getCardinality() < 0) {
                        ((Dictionary)props).put(propName, vec);
                        continue;
                    }
                    ((Dictionary)props).put(propName, this.toArray(ad.getType(), vec));
                }
            }
            config.update(props);
        }
        return true;
    }

    private Object toType(int type, String value) {
        switch (type) {
            case 11: {
                return Boolean.valueOf(value);
            }
            case 6: {
                return Byte.valueOf(value);
            }
            case 5: {
                char c = value.length() > 0 ? value.charAt(0) : (char)'\u0000';
                return new Character(c);
            }
            case 7: {
                return Double.valueOf(value);
            }
            case 8: {
                return Float.valueOf(value);
            }
            case 2: {
                return Long.valueOf(value);
            }
            case 3: {
                return Integer.valueOf(value);
            }
            case 4: {
                return Short.valueOf(value);
            }
        }
        return value;
    }

    private Object toArray(int type, Vector values) {
        Object[] array;
        int size = values.size();
        if (type == 1) {
            return values.toArray(new String[size]);
        }
        switch (type) {
            case 11: {
                array = new boolean[size];
            }
            case 6: {
                array = new byte[size];
            }
            case 5: {
                array = new char[size];
            }
            case 7: {
                array = new double[size];
            }
            case 8: {
                array = new float[size];
            }
            case 2: {
                array = new long[size];
            }
            case 3: {
                array = new int[size];
            }
            case 4: {
                array = new short[size];
            }
        }
        array = new String[size];
        for (int i = 0; i < size; ++i) {
            Array.set(array, i, values.get(i));
        }
        return array;
    }
}

