/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.bind;

import org.apache.felix.ipojo.manipulator.metadata.annotation.ComponentWorkbench;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.RequiresVisitor;
import org.apache.felix.ipojo.manipulator.metadata.annotation.visitor.bind.Action;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.EmptyVisitor;

public abstract class AbstractBindVisitor
extends EmptyVisitor
implements AnnotationVisitor {
    protected ComponentWorkbench workbench;
    protected Action action;
    protected String m_filter;
    protected String m_optional;
    protected String m_aggregate;
    protected String m_specification;
    protected String m_id;
    protected String m_policy;
    protected String m_comparator;
    protected String m_from;
    protected String m_proxy;

    public AbstractBindVisitor(ComponentWorkbench workbench, Action action) {
        this.workbench = workbench;
        this.action = action;
    }

    public void visit(String name, Object value) {
        if (name.equals("filter")) {
            this.m_filter = value.toString();
            return;
        }
        if (name.equals("optional")) {
            this.m_optional = value.toString();
            return;
        }
        if (name.equals("aggregate")) {
            this.m_aggregate = value.toString();
            return;
        }
        if (name.equals("specification")) {
            if (value.toString().startsWith("L") && value.toString().endsWith(";")) {
                Type type = Type.getType(value.toString());
                this.m_specification = type.getClassName();
            } else {
                this.m_specification = value.toString();
            }
            return;
        }
        if (name.equals("policy")) {
            this.m_policy = RequiresVisitor.getPolicy(value.toString());
            return;
        }
        if (name.equals("id")) {
            this.m_id = value.toString();
            return;
        }
        if (name.equals("comparator")) {
            Type type = Type.getType(value.toString());
            this.m_comparator = type.getClassName();
            return;
        }
        if (name.equals("from")) {
            this.m_from = value.toString();
        }
        if (name.equals("proxy")) {
            this.m_proxy = value.toString();
        }
    }

    public void visitEnum(String name, String desc, String value) {
        if (name.equals("policy")) {
            this.m_policy = RequiresVisitor.getPolicy(value.toString());
        }
    }

    public void visitEnd() {
    }

    protected Element getRequiresElement() {
        Element requires = this.workbench.getIds().get(this.m_id);
        if (requires == null) {
            requires = this.createRequiresElement();
        } else if (!this.completeExistingRequires(requires)) {
            return null;
        }
        return requires;
    }

    protected boolean completeExistingRequires(Element requires) {
        if (!this.completeAttribute(requires, "specification", this.m_specification)) {
            return false;
        }
        if (!this.completeAttribute(requires, "optional", this.m_optional)) {
            return false;
        }
        if (!this.completeAttribute(requires, "aggregate", this.m_aggregate)) {
            return false;
        }
        if (!this.completeAttribute(requires, "filter", this.m_filter)) {
            return false;
        }
        if (!this.completeAttribute(requires, "policy", this.m_policy)) {
            return false;
        }
        if (!this.completeAttribute(requires, "comparator", this.m_comparator)) {
            return false;
        }
        if (!this.completeAttribute(requires, "from", this.m_from)) {
            return false;
        }
        return this.completeAttribute(requires, "proxy", this.m_proxy);
    }

    private boolean completeAttribute(Element requires, String name, String value) {
        if (value != null) {
            String old = requires.getAttribute(name);
            if (old == null) {
                requires.addAttribute(new Attribute(name, value));
            } else if (!value.equals(old)) {
                System.err.println("The '" + name + "' attribute has changed: " + old + " -> " + value);
                return false;
            }
        }
        return true;
    }

    protected Element createRequiresElement() {
        Element requires = new Element("requires", "");
        if (this.m_specification != null) {
            requires.addAttribute(new Attribute("specification", this.m_specification));
        }
        if (this.m_aggregate != null) {
            requires.addAttribute(new Attribute("aggregate", this.m_aggregate));
        }
        if (this.m_filter != null) {
            requires.addAttribute(new Attribute("filter", this.m_filter));
        }
        if (this.m_optional != null) {
            requires.addAttribute(new Attribute("optional", this.m_optional));
        }
        if (this.m_policy != null) {
            requires.addAttribute(new Attribute("policy", this.m_policy));
        }
        if (this.m_id != null) {
            requires.addAttribute(new Attribute("id", this.m_id));
        }
        if (this.m_comparator != null) {
            requires.addAttribute(new Attribute("comparator", this.m_comparator));
        }
        if (this.m_from != null) {
            requires.addAttribute(new Attribute("from", this.m_from));
        }
        if (this.m_proxy != null) {
            requires.addAttribute(new Attribute("proxy", this.m_proxy));
        }
        return requires;
    }
}

