/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulator.metadata;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.manipulator.MetadataProvider;
import org.apache.felix.ipojo.manipulator.Reporter;
import org.apache.felix.ipojo.manipulator.metadata.StreamMetadataProvider;
import org.apache.felix.ipojo.metadata.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileMetadataProvider
implements MetadataProvider {
    private File m_source;
    private Reporter m_reporter;
    private boolean m_validateUsingLocalSchemas = false;

    public FileMetadataProvider(File source, Reporter reporter) {
        this.m_source = source;
        this.m_reporter = reporter;
    }

    public void setValidateUsingLocalSchemas(boolean validateUsingLocalSchemas) {
        this.m_validateUsingLocalSchemas = validateUsingLocalSchemas;
    }

    @Override
    public List<Element> getMetadatas() throws IOException {
        ArrayList<Element> metadata = new ArrayList<Element>();
        this.traverse(this.m_source, metadata);
        return metadata;
    }

    private void traverse(File file, List<Element> metadata) {
        if (file.isDirectory()) {
            File[] files;
            for (File child : files = file.listFiles()) {
                this.traverse(child, metadata);
            }
        } else if (file.getName().endsWith(".xml")) {
            this.loadFileMetadata(file, metadata);
        }
    }

    private void loadFileMetadata(File file, List<Element> metadata) {
        try {
            InputStream stream = null;
            URL url = file.toURI().toURL();
            if (url == null) {
                this.m_reporter.warn("Cannot find the metadata file : " + this.m_source.getAbsolutePath(), new Object[0]);
            } else {
                stream = url.openStream();
                StreamMetadataProvider provider = new StreamMetadataProvider(stream, this.m_reporter);
                provider.setValidateUsingLocalSchemas(this.m_validateUsingLocalSchemas);
                metadata.addAll(provider.getMetadatas());
            }
        }
        catch (MalformedURLException e) {
            this.m_reporter.error("Cannot open the metadata input stream from " + this.m_source.getAbsolutePath() + ": " + e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            this.m_reporter.error("Cannot open the metadata input stream: " + this.m_source.getAbsolutePath() + ": " + e.getMessage(), new Object[0]);
        }
    }
}

