/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.felix.ipojo.manipulation.ClassChecker;
import org.apache.felix.ipojo.manipulation.Manipulator;
import org.apache.felix.ipojo.manipulation.MethodCodeAdapter;
import org.apache.felix.ipojo.manipulation.MethodDescriptor;
import org.objectweb.asm.ClassAdapter;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.LocalVariableNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InnerClassAdapter
extends ClassAdapter
implements Opcodes {
    private final Manipulator m_manipulator;
    private final String m_name;
    private final String m_simpleName;
    private String m_outer;
    private Set<String> m_fields;

    public InnerClassAdapter(String name, ClassVisitor arg0, String outerClassName, Manipulator manipulator) {
        super(arg0);
        this.m_name = name;
        this.m_simpleName = this.m_name.substring(this.m_name.indexOf("$") + 1);
        this.m_outer = outerClassName;
        this.m_manipulator = manipulator;
        this.m_fields = manipulator.getFields().keySet();
    }

    @Override
    public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        int theVersion = version;
        String downgrade = System.getProperty("ipojo.downgrade.classes");
        if ((downgrade == null || "true".equals(downgrade)) && version == 51) {
            theVersion = 50;
        }
        super.visit(theVersion, access, name, signature, superName, interfaces);
    }

    @Override
    public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
        if ((access & 8) == 8) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if ((access & 0x100) == 256) {
            return super.visitMethod(access, name, desc, signature, exceptions);
        }
        if (!this.m_manipulator.isAlreadyManipulated()) {
            if (name.equals("<init>")) {
                MethodVisitor mv = super.visitMethod(access, name, desc, signature, exceptions);
                return new MethodCodeAdapter(mv, this.m_outer, access, name, desc, this.m_fields);
            }
            MethodDescriptor md = this.getMethodDescriptor(name, desc);
            if (md == null) {
                this.generateMethodWrapper(access, name, desc, signature, exceptions, null, null, null);
            } else {
                this.generateMethodWrapper(access, name, desc, signature, exceptions, md.getArgumentLocalVariables(), md.getAnnotations(), md.getParameterAnnotations());
            }
            MethodVisitor mv = super.visitMethod(access, "__M_" + name, desc, signature, exceptions);
            return new MethodCodeAdapter(mv, this.m_outer, access, "__M_" + name, desc, this.m_fields);
        }
        return super.visitMethod(access, name, desc, signature, exceptions);
    }

    private String getMethodFlagName(String name, String desc) {
        return "__M" + this.getMethodId(name, desc);
    }

    private String getMethodId(String name, String desc) {
        Type[] args;
        StringBuilder id = new StringBuilder(this.m_simpleName);
        id.append("___");
        id.append(name);
        for (Type type : args = Type.getArgumentTypes(desc)) {
            String arg = type.getClassName();
            if (arg.endsWith("[]")) {
                String acc = "";
                while (arg.endsWith("[]")) {
                    arg = arg.substring(0, arg.length() - 2);
                    acc = acc + "__";
                }
                id.append("$").append(arg.replace('.', '_')).append(acc);
                continue;
            }
            id.append("$").append(arg.replace('.', '_'));
        }
        return id.toString();
    }

    private void generateMethodWrapper(int access, String name, String desc, String signature, String[] exceptions, List<LocalVariableNode> localVariables, List<ClassChecker.AnnotationDescriptor> annotations, Map<Integer, List<ClassChecker.AnnotationDescriptor>> paramAnnotations) {
        GeneratorAdapter mv = new GeneratorAdapter(this.cv.visitMethod(access, name, desc, signature, exceptions), access, name, desc);
        boolean hasArgumentLabels = localVariables != null && !localVariables.isEmpty();
        Label start = null;
        if (hasArgumentLabels) {
            start = new Label();
            mv.visitLabel(start);
        }
        mv.visitCode();
        Type returnType = Type.getReturnType(desc);
        int result = -1;
        int exception = -1;
        if (returnType.getSort() != 0) {
            result = mv.newLocal(returnType);
            exception = mv.newLocal(Type.getType(Throwable.class));
        } else {
            exception = mv.newLocal(Type.getType(Throwable.class));
        }
        Label l0 = new Label();
        Label l1 = new Label();
        Label l2 = new Label();
        mv.visitTryCatchBlock(l0, l1, l2, "java/lang/Throwable");
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_name, "this$0", "L" + this.m_outer + ";");
        mv.visitFieldInsn(180, this.m_outer, this.getMethodFlagName(name, desc), "Z");
        mv.visitJumpInsn(154, l0);
        mv.visitVarInsn(25, 0);
        mv.loadArgs();
        mv.visitMethodInsn(183, this.m_name, "__M_" + name, desc);
        mv.visitInsn(returnType.getOpcode(172));
        mv.visitLabel(l0);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_name, "this$0", "L" + this.m_outer + ";");
        mv.visitFieldInsn(180, this.m_outer, "__IM", "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(this.getMethodId(name, desc));
        mv.loadArgArray();
        mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", "onEntry", "(Ljava/lang/Object;Ljava/lang/String;[Ljava/lang/Object;)V");
        mv.visitVarInsn(25, 0);
        mv.loadArgs();
        mv.visitMethodInsn(183, this.m_name, "__M_" + name, desc);
        if (returnType.getSort() != 0) {
            mv.visitVarInsn(returnType.getOpcode(54), result);
        }
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_name, "this$0", "L" + this.m_outer + ";");
        mv.visitFieldInsn(180, this.m_outer, "__IM", "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(this.getMethodId(name, desc));
        if (returnType.getSort() != 0) {
            mv.visitVarInsn(returnType.getOpcode(21), result);
            mv.box(returnType);
        } else {
            mv.visitInsn(1);
        }
        mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", "onExit", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Object;)V");
        mv.visitLabel(l1);
        Label l7 = new Label();
        mv.visitJumpInsn(167, l7);
        mv.visitLabel(l2);
        mv.visitVarInsn(58, exception);
        mv.visitVarInsn(25, 0);
        mv.visitFieldInsn(180, this.m_name, "this$0", "L" + this.m_outer + ";");
        mv.visitFieldInsn(180, this.m_outer, "__IM", "Lorg/apache/felix/ipojo/InstanceManager;");
        mv.visitVarInsn(25, 0);
        mv.visitLdcInsn(this.getMethodId(name, desc));
        mv.visitVarInsn(25, exception);
        mv.visitMethodInsn(182, "org/apache/felix/ipojo/InstanceManager", "onError", "(Ljava/lang/Object;Ljava/lang/String;Ljava/lang/Throwable;)V");
        mv.visitVarInsn(25, exception);
        mv.visitInsn(191);
        mv.visitLabel(l7);
        if (returnType.getSort() != 0) {
            mv.visitVarInsn(returnType.getOpcode(21), result);
        }
        mv.visitInsn(returnType.getOpcode(172));
        Label end = null;
        if (hasArgumentLabels) {
            end = new Label();
            mv.visitLabel(end);
        }
        if (annotations != null) {
            for (int i = 0; i < annotations.size(); ++i) {
                ClassChecker.AnnotationDescriptor ad = annotations.get(i);
                ad.visitAnnotation(mv);
            }
        }
        if (paramAnnotations != null && !paramAnnotations.isEmpty()) {
            for (Integer id : paramAnnotations.keySet()) {
                List<ClassChecker.AnnotationDescriptor> ads = paramAnnotations.get(id);
                for (int i = 0; i < ads.size(); ++i) {
                    ClassChecker.AnnotationDescriptor ad = ads.get(i);
                    ad.visitParameterAnnotation(id, mv);
                }
            }
        }
        if (hasArgumentLabels) {
            for (LocalVariableNode var : localVariables) {
                mv.visitLocalVariable(var.name, var.desc, var.signature, start, end, var.index);
            }
        }
        mv.visitMaxs(0, 0);
        mv.visitEnd();
    }

    private MethodDescriptor getMethodDescriptor(String name, String desc) {
        for (MethodDescriptor md : this.m_manipulator.getMethodsFromInnerClass(this.m_name)) {
            if (!md.getName().equals(name) || !md.getDescriptor().equals(desc)) continue;
            return md;
        }
        return null;
    }
}

