/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.util;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.List;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.ContextListener;
import org.apache.felix.ipojo.ContextSource;
import org.apache.felix.ipojo.composite.CompositeManager;
import org.apache.felix.ipojo.parser.ParseUtils;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.Tracker;
import org.apache.felix.ipojo.util.TrackerCustomizer;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;

public class SourceManager
implements ContextListener {
    public static final String SOURCE_NAME = "source.name";
    private DependencyModel m_dependency;
    private List m_sources = new ArrayList(1);
    private String[] m_properties;
    private String m_filter;
    private BundleContext m_context;
    private List m_trackers = new ArrayList(1);

    public SourceManager(String sources, String depfilter, DependencyModel dependency, CompositeManager manager) throws ConfigurationException {
        this.m_filter = depfilter;
        this.m_properties = SourceManager.getProperties(depfilter);
        this.m_dependency = dependency;
        this.m_context = manager.getGlobalContext();
        if (manager.getParentServiceContext() == null) {
            this.parseSources(sources, manager.getGlobalContext(), manager.getGlobalContext(), (BundleContext)manager.getServiceContext());
        } else {
            this.parseSources(sources, manager.getGlobalContext(), (BundleContext)manager.getParentServiceContext(), (BundleContext)manager.getServiceContext());
        }
    }

    public void start() {
        for (int i = 0; i < this.m_trackers.size(); ++i) {
            ((SourceTracker)this.m_trackers.get(i)).open();
        }
        this.computeFilter();
    }

    public void stop() {
        for (int i = 0; i < this.m_trackers.size(); ++i) {
            ((SourceTracker)this.m_trackers.get(i)).close();
        }
        this.setFilter(this.m_filter);
        this.m_sources.clear();
    }

    public int getState() {
        if (this.m_sources.isEmpty()) {
            return 0;
        }
        return 1;
    }

    private void setFilter(String filter) {
        if (!filter.equals(this.m_dependency.getFilter())) {
            try {
                this.m_dependency.setFilter(this.m_context.createFilter(filter));
            }
            catch (InvalidSyntaxException e) {
                throw new IllegalStateException("A context filter is invalid : " + filter, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void computeFilter() {
        String fil = this.m_filter;
        SourceManager sourceManager = this;
        synchronized (sourceManager) {
            for (int i = 0; i < this.m_sources.size(); ++i) {
                Dictionary props = ((ContextSource)this.m_sources.get(i)).getContext();
                fil = SourceManager.substitute(fil, props);
            }
        }
        if (!fil.equals(this.m_dependency.getFilter())) {
            this.setFilter(fil);
        }
    }

    public static String substitute(String str, Dictionary values) {
        int len = str.length();
        StringBuffer buffer = new StringBuffer(len);
        int prev = 0;
        int start = str.indexOf("${");
        int end = str.indexOf(125, start);
        while (start != -1 && end != -1) {
            String key = str.substring(start + 2, end);
            Object value = values.get(key);
            if (value == null) {
                buffer.append(str.substring(prev, end + 1));
            } else {
                buffer.append(str.substring(prev, start));
                buffer.append(value);
            }
            prev = end + 1;
            if (prev >= str.length()) break;
            start = str.indexOf("${", prev);
            if (start == -1) continue;
            end = str.indexOf(125, start);
        }
        buffer.append(str.substring(prev));
        return buffer.toString();
    }

    public static String[] getProperties(String str) {
        ArrayList<String> list = new ArrayList<String>();
        int prev = 0;
        int start = str.indexOf("${");
        int end = str.indexOf(125, start);
        while (start != -1 && end != -1) {
            String key = str.substring(start + 2, end);
            list.add(key);
            prev = end + 1;
            if (prev >= str.length()) break;
            start = str.indexOf("${", prev);
            if (start == -1) continue;
            end = str.indexOf(125, start);
        }
        return list.toArray(new String[list.size()]);
    }

    public synchronized void update(ContextSource source, String property, Object value) {
        this.computeFilter();
    }

    private void parseSources(String sourceAtt, BundleContext global, BundleContext parent, BundleContext local) throws ConfigurationException {
        String[] sources = ParseUtils.split((String)sourceAtt, (String)",");
        for (int i = 0; i < sources.length; ++i) {
            SourceTracker tracker;
            String[] srcs = ParseUtils.split((String)sources[i], (String)":");
            if (srcs.length == 1) {
                tracker = new SourceTracker(srcs[0], local);
                this.m_trackers.add(tracker);
                continue;
            }
            if (srcs.length == 2) {
                if (srcs[0].equalsIgnoreCase("parent")) {
                    tracker = new SourceTracker(srcs[1], parent);
                    this.m_trackers.add(tracker);
                    continue;
                }
                if (srcs[0].equalsIgnoreCase("local")) {
                    tracker = new SourceTracker(srcs[1], local);
                    this.m_trackers.add(tracker);
                    continue;
                }
                if (srcs[0].equalsIgnoreCase("global")) {
                    tracker = new SourceTracker(srcs[1], global);
                    this.m_trackers.add(tracker);
                    continue;
                }
                throw new ConfigurationException("Unknowns context scope : " + srcs[0]);
            }
            throw new ConfigurationException("Malformed context source : " + sources[i]);
        }
    }

    private void addContextSource(ContextSource source) {
        this.m_sources.add(source);
        this.computeFilter();
        source.registerContextListener((ContextListener)this, this.m_properties);
    }

    private void removeContextSource(ContextSource source) {
        this.m_sources.remove(source);
        this.computeFilter();
    }

    private class SourceTracker
    implements TrackerCustomizer {
        private Tracker m_tracker;

        public SourceTracker(String name, BundleContext countext) throws ConfigurationException {
            String fil = "(&(objectClass=" + ContextSource.class.getName() + ")(" + SourceManager.SOURCE_NAME + "=" + name + "))";
            try {
                Filter filter = countext.createFilter(fil);
                this.m_tracker = new Tracker(countext, filter, (TrackerCustomizer)this);
            }
            catch (InvalidSyntaxException e) {
                throw new ConfigurationException("A Context source filter is invalid " + fil, (Throwable)e);
            }
        }

        public void open() {
            this.m_tracker.open();
        }

        public void close() {
            this.m_tracker.close();
        }

        public void addedService(ServiceReference reference) {
            SourceManager.this.addContextSource((ContextSource)this.m_tracker.getService(reference));
        }

        public boolean addingService(ServiceReference reference) {
            return true;
        }

        public void modifiedService(ServiceReference reference, Object service) {
        }

        public void removedService(ServiceReference reference, Object service) {
            SourceManager.this.removeContextSource((ContextSource)service);
        }
    }
}

