/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.manipulation;

import java.util.ArrayList;
import java.util.List;
import org.apache.felix.ipojo.manipulation.ClassChecker;
import org.apache.felix.ipojo.metadata.Attribute;
import org.apache.felix.ipojo.metadata.Element;
import org.objectweb.asm.Type;

public class MethodDescriptor {
    private String m_name;
    private String m_returnType;
    private String[] m_arguments;
    private String m_desc;
    private List m_annotations;

    public MethodDescriptor(String name, String desc) {
        this.m_name = name;
        this.m_desc = desc;
        Type ret = Type.getReturnType(desc);
        Type[] args = Type.getArgumentTypes(desc);
        this.m_returnType = this.getType(ret);
        this.m_arguments = new String[args.length];
        for (int i = 0; i < args.length; ++i) {
            this.m_arguments[i] = this.getType(args[i]);
        }
    }

    public void addAnnotation(ClassChecker.AnnotationDescriptor ann) {
        if (this.m_annotations == null) {
            this.m_annotations = new ArrayList();
        }
        this.m_annotations.add(ann);
    }

    public List getAnnotations() {
        return this.m_annotations;
    }

    public String getDescriptor() {
        return this.m_desc;
    }

    public Element getElement() {
        Element method = new Element("method", "");
        method.addAttribute(new Attribute("name", this.m_name));
        if (!this.m_returnType.equals("void")) {
            method.addAttribute(new Attribute("return", this.m_returnType));
        }
        if (this.m_arguments.length > 0) {
            String args = "{";
            args = args + this.m_arguments[0];
            for (int i = 1; i < this.m_arguments.length; ++i) {
                args = args + "," + this.m_arguments[i];
            }
            args = args + "}";
            method.addAttribute(new Attribute("arguments", args));
        }
        return method;
    }

    private String getType(Type type) {
        switch (type.getSort()) {
            case 9: {
                Type elemType = type.getElementType();
                return this.getType(elemType) + "[]";
            }
            case 1: {
                return "boolean";
            }
            case 3: {
                return "byte";
            }
            case 2: {
                return "char";
            }
            case 8: {
                return "double";
            }
            case 6: {
                return "float";
            }
            case 5: {
                return "int";
            }
            case 7: {
                return "long";
            }
            case 10: {
                return type.getClassName();
            }
            case 4: {
                return "short";
            }
            case 0: {
                return "void";
            }
        }
        return "unknown";
    }

    public String getName() {
        return this.m_name;
    }
}

