/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.ipojo.composite.service.instantiator;

import java.util.Comparator;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.felix.ipojo.ComponentInstance;
import org.apache.felix.ipojo.ConfigurationException;
import org.apache.felix.ipojo.Factory;
import org.apache.felix.ipojo.MissingHandlerException;
import org.apache.felix.ipojo.UnacceptableConfiguration;
import org.apache.felix.ipojo.architecture.ComponentTypeDescription;
import org.apache.felix.ipojo.architecture.PropertyDescription;
import org.apache.felix.ipojo.composite.service.instantiator.ServiceDependencyHandler;
import org.apache.felix.ipojo.util.DependencyModel;
import org.apache.felix.ipojo.util.DependencyStateListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.ServiceReference;

public class SvcInstance
extends DependencyModel {
    private Dictionary m_configuration;
    private ServiceDependencyHandler m_handler;
    private Map m_factories = new HashMap();
    private String m_specification;
    private boolean m_isFrozen;
    static /* synthetic */ Class class$org$apache$felix$ipojo$Factory;

    public SvcInstance(ServiceDependencyHandler handler, String spec, Dictionary conf, boolean isAgg, boolean isOpt, Filter filt, Comparator cmp, int policy) throws ConfigurationException {
        super(class$org$apache$felix$ipojo$Factory == null ? (class$org$apache$felix$ipojo$Factory = SvcInstance.class$("org.apache.felix.ipojo.Factory")) : class$org$apache$felix$ipojo$Factory, isAgg, isOpt, filt, cmp, policy, null, (DependencyStateListener)handler);
        this.m_specification = spec;
        this.m_handler = handler;
        this.setBundleContext((BundleContext)this.m_handler.getCompositeManager().getServiceContext());
        this.m_configuration = conf;
    }

    public void stop() {
        super.stop();
        Set keys = this.m_factories.keySet();
        Iterator iterator = keys.iterator();
        while (iterator.hasNext()) {
            ServiceReference ref = (ServiceReference)iterator.next();
            Object object = this.m_factories.get(ref);
            if (object == null) continue;
            ((ComponentInstance)object).dispose();
        }
        this.m_factories.clear();
    }

    public boolean isFrozen() {
        return this.m_isFrozen;
    }

    public void freeze() {
        this.m_isFrozen = true;
    }

    private ComponentInstance createInstance(Factory factory) throws UnacceptableConfiguration, MissingHandlerException, ConfigurationException {
        Properties props = new Properties();
        Enumeration keys = this.m_configuration.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            props.put(key, this.m_configuration.get(key));
        }
        ComponentInstance instance = null;
        instance = factory.createComponentInstance((Dictionary)props);
        return instance;
    }

    public boolean match(ServiceReference fact) {
        ComponentTypeDescription desc = (ComponentTypeDescription)fact.getProperty("component.description");
        if (desc == null) {
            return false;
        }
        String[] provides = desc.getprovidedServiceSpecification();
        for (int i = 0; provides != null && i < provides.length; ++i) {
            if (!provides[i].equals(this.m_specification)) continue;
            PropertyDescription[] props = desc.getProperties();
            Properties conf = new Properties();
            Enumeration keys = this.m_configuration.keys();
            while (keys.hasMoreElements()) {
                String key = (String)keys.nextElement();
                if (!this.containsProperty(key, props)) {
                    return false;
                }
                conf.put(key, this.m_configuration.get(key));
            }
            Factory factory = (Factory)this.getService(fact);
            return factory.isAcceptable((Dictionary)conf);
        }
        return false;
    }

    private boolean containsProperty(String name, PropertyDescription[] props) {
        for (int i = 0; props != null && i < props.length; ++i) {
            if (!props[i].getName().equalsIgnoreCase(name)) continue;
            return true;
        }
        return name.equalsIgnoreCase("name");
    }

    public String getServiceSpecification() {
        return this.m_specification;
    }

    protected Map getMatchingFactories() {
        return this.m_factories;
    }

    public void onDependencyReconfiguration(ServiceReference[] departs, ServiceReference[] arrivals) {
        int i;
        for (i = 0; departs != null && i < departs.length; ++i) {
            this.onServiceDeparture(departs[i]);
        }
        for (i = 0; arrivals != null && i < arrivals.length; ++i) {
            this.onServiceArrival(arrivals[i]);
        }
    }

    public void onServiceArrival(ServiceReference ref) {
        try {
            Factory fact = (Factory)this.getService(ref);
            ComponentInstance instance = this.createInstance(fact);
            this.m_factories.put(ref, instance);
        }
        catch (UnacceptableConfiguration e) {
            this.m_handler.error("A matching factory refuse the actual configuration : " + e.getMessage());
            this.m_handler.getCompositeManager().stop();
        }
        catch (MissingHandlerException e) {
            this.m_handler.error("A matching factory is no more valid : " + e.getMessage());
            this.m_handler.getCompositeManager().stop();
        }
        catch (ConfigurationException e) {
            this.m_handler.error("A matching configuration is refuse by the instance : " + e.getMessage());
            this.m_handler.getCompositeManager().stop();
        }
    }

    public void onServiceDeparture(ServiceReference ref) {
        Object instance = this.m_factories.remove(ref);
        if (instance != null) {
            ((ComponentInstance)instance).dispose();
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

