/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.http.whiteboard.internal.manager;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.Servlet;
import org.apache.felix.http.api.ExtHttpService;
import org.apache.felix.http.base.internal.logger.SystemLogger;
import org.apache.felix.http.whiteboard.internal.manager.AbstractMapping;
import org.apache.felix.http.whiteboard.internal.manager.FilterMapping;
import org.apache.felix.http.whiteboard.internal.manager.HttpContextManager;
import org.apache.felix.http.whiteboard.internal.manager.ServletMapping;
import org.osgi.framework.Bundle;
import org.osgi.framework.ServiceReference;
import org.osgi.service.http.HttpContext;
import org.osgi.service.http.HttpService;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ExtenderManager {
    private HttpService httpService;
    private final HashMap<ServiceReference, AbstractMapping> mapping = new HashMap();
    private final HttpContextManager contextManager = new HttpContextManager();

    static boolean isEmpty(String value) {
        return value == null || value.length() == 0;
    }

    private String getStringProperty(ServiceReference ref, String key) {
        Object value = ref.getProperty(key);
        return value instanceof String ? (String)value : null;
    }

    private boolean getBooleanProperty(ServiceReference ref, String key) {
        Object value = ref.getProperty(key);
        if (value instanceof String) {
            return Boolean.valueOf((String)value);
        }
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    private int getIntProperty(ServiceReference ref, String key, int defValue) {
        Object value = ref.getProperty(key);
        if (value == null) {
            return defValue;
        }
        try {
            return Integer.parseInt(value.toString());
        }
        catch (Exception e) {
            return defValue;
        }
    }

    private void addInitParams(ServiceReference ref, AbstractMapping mapping) {
        for (String key : ref.getPropertyKeys()) {
            if (!key.startsWith("init.")) continue;
            String paramKey = key.substring("init.".length());
            String paramValue = this.getStringProperty(ref, key);
            if (paramValue == null) continue;
            mapping.getInitParams().put(paramKey, paramValue);
        }
    }

    public void add(HttpContext service, ServiceReference ref) {
        String contextId = this.getStringProperty(ref, "contextId");
        if (!ExtenderManager.isEmpty(contextId)) {
            boolean shared = this.getBooleanProperty(ref, "context.shared");
            Bundle bundle = shared ? null : ref.getBundle();
            Collection<AbstractMapping> mappings = this.contextManager.addHttpContext(bundle, contextId, service);
            for (AbstractMapping mapping : mappings) {
                this.registerMapping(mapping);
            }
        } else {
            SystemLogger.debug("Ignoring HttpContext Service " + ref + ", " + "contextId" + " is missing or empty");
        }
    }

    public void remove(HttpContext service) {
        Collection<AbstractMapping> mappings = this.contextManager.removeHttpContext(service);
        if (mappings != null) {
            for (AbstractMapping mapping : mappings) {
                this.unregisterMapping(mapping);
            }
        }
    }

    private void getHttpContext(AbstractMapping mapping, ServiceReference ref) {
        Bundle bundle = ref.getBundle();
        String contextId = this.getStringProperty(ref, "contextId");
        this.contextManager.getHttpContext(bundle, contextId, mapping);
    }

    private void ungetHttpContext(AbstractMapping mapping, ServiceReference ref) {
        Bundle bundle = ref.getBundle();
        String contextId = this.getStringProperty(ref, "contextId");
        this.contextManager.ungetHttpContext(bundle, contextId, mapping);
    }

    public void add(Filter service, ServiceReference ref) {
        int ranking = this.getIntProperty(ref, "service.ranking", 0);
        String pattern = this.getStringProperty(ref, "pattern");
        if (ExtenderManager.isEmpty(pattern)) {
            SystemLogger.debug("Ignoring Filter Service " + ref + ", " + "pattern" + " is missing or empty");
            return;
        }
        FilterMapping mapping = new FilterMapping(ref.getBundle(), service, pattern, ranking);
        this.getHttpContext(mapping, ref);
        this.addInitParams(ref, mapping);
        this.addMapping(ref, mapping);
    }

    public void add(Servlet service, ServiceReference ref) {
        String alias = this.getStringProperty(ref, "alias");
        if (ExtenderManager.isEmpty(alias)) {
            SystemLogger.debug("Ignoring Servlet Service " + ref + ", " + "alias" + " is missing or empty");
            return;
        }
        ServletMapping mapping = new ServletMapping(ref.getBundle(), service, alias);
        this.getHttpContext(mapping, ref);
        this.addInitParams(ref, mapping);
        this.addMapping(ref, mapping);
    }

    public void remove(ServiceReference ref) {
        this.removeMapping(ref);
    }

    public synchronized void setHttpService(HttpService service) {
        this.httpService = service;
        if (this.httpService instanceof ExtHttpService) {
            SystemLogger.info("Detected extended HttpService. Filters enabled.");
        } else {
            SystemLogger.info("Detected standard HttpService. Filters disabled.");
        }
        this.registerAll();
    }

    public synchronized void unsetHttpService() {
        this.unregisterAll();
        this.httpService = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void unregisterAll() {
        HttpService service;
        AbstractMapping[] mappings = null;
        ExtenderManager extenderManager = this;
        synchronized (extenderManager) {
            service = this.httpService;
            if (service != null) {
                Collection<AbstractMapping> values = this.mapping.values();
                mappings = values.toArray(new AbstractMapping[values.size()]);
            }
        }
        if (mappings != null) {
            for (AbstractMapping mapping : mappings) {
                mapping.unregister(service);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void registerAll() {
        HttpService service;
        AbstractMapping[] mappings = null;
        ExtenderManager extenderManager = this;
        synchronized (extenderManager) {
            service = this.httpService;
            if (service != null) {
                Collection<AbstractMapping> values = this.mapping.values();
                mappings = values.toArray(new AbstractMapping[values.size()]);
            }
        }
        if (mappings != null) {
            for (AbstractMapping mapping : mappings) {
                mapping.register(service);
            }
        }
    }

    private synchronized void addMapping(ServiceReference ref, AbstractMapping mapping) {
        this.mapping.put(ref, mapping);
        this.registerMapping(mapping);
    }

    private synchronized void removeMapping(ServiceReference ref) {
        AbstractMapping mapping = this.mapping.remove(ref);
        if (mapping != null) {
            this.ungetHttpContext(mapping, ref);
            this.unregisterMapping(mapping);
        }
    }

    private void registerMapping(AbstractMapping mapping) {
        HttpService httpService = this.httpService;
        if (httpService != null) {
            mapping.register(httpService);
        }
    }

    private void unregisterMapping(AbstractMapping mapping) {
        HttpService httpService = this.httpService;
        if (httpService != null) {
            mapping.unregister(httpService);
        }
    }

    Map<String, HttpContextManager.HttpContextHolder> getHttpContexts() {
        return this.contextManager.getHttpContexts();
    }

    Map<String, Set<AbstractMapping>> getOrphanMappings() {
        return this.contextManager.getOrphanMappings();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Map<Object, AbstractMapping> getMappings() {
        ExtenderManager extenderManager = this;
        synchronized (extenderManager) {
            return new HashMap<ServiceReference, AbstractMapping>(this.mapping);
        }
    }
}

