/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.gogo.runtime;

import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.felix.service.command.CommandSession;
import org.apache.felix.service.command.Parameter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Reflective {
    public static final Object NO_MATCH = new Object();
    public static final String MAIN = "_main";
    public static final Set<String> KEYWORDS = new HashSet<String>(Arrays.asList("abstract", "continue", "for", "new", "switch", "assert", "default", "goto", "package", "synchronized", "boolean", "do", "if", "private", "this", "break", "double", "implements", "protected", "throw", "byte", "else", "import", "public", "throws", "case", "enum", "instanceof", "return", "transient", "catch", "extends", "int", "short", "try", "char", "final", "interface", "static", "void", "class", "finally", "long", "strictfp", "volatile", "const", "float", "native", "super", "while"));

    /*
     * WARNING - void declaration
     */
    public static Object method(CommandSession session, Object target, String name, List<Object> args) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException, Exception {
        void var14_20;
        Method[] methods = target.getClass().getMethods();
        name = name.toLowerCase();
        String get = "get" + name;
        String is = "is" + name;
        String set = "set" + name;
        if (KEYWORDS.contains(name)) {
            name = "_" + name;
        }
        if (target instanceof Class) {
            Method[] staticMethods;
            for (Method m : staticMethods = ((Class)target).getMethods()) {
                String mname = m.getName().toLowerCase();
                if (!mname.equals(name) && !mname.equals(get) && !mname.equals(set) && !mname.equals(is) && !mname.equals(MAIN)) continue;
                methods = staticMethods;
                break;
            }
        }
        Method bestMethod = null;
        Object[] bestArgs = null;
        int match = -1;
        ArrayList<Class<?>[]> possibleTypes = new ArrayList<Class<?>[]>();
        Method[] arr$ = methods;
        int len$ = arr$.length;
        boolean bl = false;
        while (var14_20 < len$) {
            Method m = arr$[var14_20];
            String mname = m.getName().toLowerCase();
            if (mname.equals(name) || mname.equals(get) || mname.equals(set) || mname.equals(is) || mname.equals(MAIN)) {
                Object[] parms;
                int local;
                Class<?>[] types = m.getParameterTypes();
                ArrayList<Object> xargs = new ArrayList<Object>(args);
                if (mname.equals(MAIN)) {
                    xargs.add(0, name);
                }
                if (types.length > 0 && types[0].isInterface() && types[0].isAssignableFrom(session.getClass())) {
                    xargs.add(0, session);
                }
                if ((local = Reflective.coerce(session, target, m, types, parms = new Object[types.length], xargs)) >= xargs.size() && local >= types.length) {
                    boolean exact;
                    boolean bl2 = exact = local == xargs.size() && local == types.length;
                    if (exact || local > match) {
                        bestMethod = m;
                        bestArgs = parms;
                        match = local;
                    }
                    if (exact) {
                        break;
                    }
                } else {
                    possibleTypes.add(types);
                }
            }
            ++var14_20;
        }
        if (bestMethod != null) {
            bestMethod.setAccessible(true);
            try {
                return bestMethod.invoke(target, bestArgs);
            }
            catch (InvocationTargetException e) {
                Throwable cause = e.getCause();
                if (cause instanceof Exception) {
                    throw (Exception)cause;
                }
                throw e;
            }
        }
        ArrayList<String> list = new ArrayList<String>();
        for (Class[] classArray : possibleTypes) {
            StringBuilder buf = new StringBuilder();
            buf.append('(');
            for (Class type : classArray) {
                if (buf.length() > 1) {
                    buf.append(", ");
                }
                buf.append(type.getSimpleName());
            }
            buf.append(')');
            list.add(buf.toString());
        }
        StringBuilder params = new StringBuilder();
        for (Object arg : args) {
            if (params.length() > 1) {
                params.append(", ");
            }
            params.append(arg.getClass().getSimpleName());
        }
        throw new IllegalArgumentException(String.format("Cannot coerce %s(%s) to any of %s", name, params, list));
    }

    private static int coerce(CommandSession session, Object target, Method m, Class<?>[] types, Object[] out, List<Object> in) throws Exception {
        int i;
        Annotation[][] pas = m.getParameterAnnotations();
        int start = 0;
        for (int argIndex = 0; argIndex < pas.length; ++argIndex) {
            Annotation[] as = pas[argIndex];
            for (int a = 0; a < as.length; ++a) {
                if (!(as[a] instanceof Parameter)) continue;
                Parameter o = (Parameter)as[a];
                out[argIndex] = Reflective.coerce(session, target, types[argIndex], o.absentValue());
                start = argIndex + 1;
            }
        }
        in = new ArrayList<Object>(in);
        Iterator<Object> itArgs = in.iterator();
        while (itArgs.hasNext()) {
            Object item = itArgs.next();
            if (!(item instanceof String) || !((String)item).startsWith("-")) continue;
            for (int argIndex = 0; argIndex < pas.length; ++argIndex) {
                Annotation[] as = pas[argIndex];
                block6: for (int a = 0; a < as.length; ++a) {
                    if (!(as[a] instanceof Parameter)) continue;
                    Parameter param = (Parameter)as[a];
                    for (String name : param.names()) {
                        if (!name.equals(item)) continue;
                        if (param.presentValue() == null) {
                            itArgs.remove();
                            assert (itArgs.hasNext());
                            Object value = itArgs.next();
                            itArgs.remove();
                            out[argIndex] = Reflective.coerce(session, target, types[argIndex], value);
                            continue block6;
                        }
                        if (param.presentValue() == null) continue block6;
                        itArgs.remove();
                        out[argIndex] = Reflective.coerce(session, target, types[argIndex], param.presentValue());
                        continue block6;
                    }
                }
            }
        }
        for (i = start; i < out.length; ++i) {
            out[i] = null;
            try {
                if (in.size() == 0) {
                    out[i] = NO_MATCH;
                } else {
                    out[i] = Reflective.coerce(session, target, types[i], in.get(0));
                    if (out[i] != NO_MATCH) {
                        in.remove(0);
                    }
                }
                if (out[i] != NO_MATCH) continue;
                if (types[i].isArray() && i == types.length - 1) {
                    Class<?> component = types[i].getComponentType();
                    Object components = Array.newInstance(component, in.size());
                    int n = i;
                    while (in.size() > 0) {
                        Object t = Reflective.coerce(session, target, component, in.remove(0));
                        if (t == NO_MATCH) {
                            return -1;
                        }
                        Array.set(components, i - n, t);
                        ++i;
                    }
                    out[n] = components;
                    if (in.size() == 0) {
                        ++i;
                    }
                    return i;
                }
                return -1;
            }
            catch (Exception e) {
                System.err.println("Reflective:" + e);
                e.printStackTrace();
                return -1;
            }
        }
        return i;
    }

    private static Object coerce(CommandSession session, Object target, Class<?> type, Object arg) throws Exception {
        if (arg == null) {
            return null;
        }
        if (type.isAssignableFrom(arg.getClass())) {
            return arg;
        }
        Object converted = session.convert(type, arg);
        if (converted != null) {
            return converted;
        }
        String string = arg.toString();
        if (type.isAssignableFrom(String.class)) {
            return string;
        }
        if (type.isArray()) {
            return NO_MATCH;
        }
        if (!type.isPrimitive()) {
            try {
                return type.getConstructor(String.class).newInstance(string);
            }
            catch (Exception e) {
                return NO_MATCH;
            }
        }
        try {
            if (type == Boolean.TYPE) {
                return new Boolean(string);
            }
            if (type == Byte.TYPE) {
                return new Byte(string);
            }
            if (type == Character.TYPE) {
                if (string.length() == 1) {
                    return Character.valueOf(string.charAt(0));
                }
            } else {
                if (type == Short.TYPE) {
                    return new Short(string);
                }
                if (type == Integer.TYPE) {
                    return new Integer(string);
                }
                if (type == Float.TYPE) {
                    return new Float(string);
                }
                if (type == Double.TYPE) {
                    return new Double(string);
                }
                if (type == Long.TYPE) {
                    return new Long(string);
                }
            }
        }
        catch (NumberFormatException e) {
            // empty catch block
        }
        return NO_MATCH;
    }
}

