/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.eventadmin.impl.tasks;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.felix.eventadmin.impl.dispatch.ThreadPool;
import org.apache.felix.eventadmin.impl.tasks.DeliverTask;
import org.apache.felix.eventadmin.impl.tasks.HandlerTask;

public class AsyncDeliverTasks
implements DeliverTask {
    private final ThreadPool m_pool;
    private final DeliverTask m_deliver_task;
    private final Map m_running_threads = new HashMap();

    public AsyncDeliverTasks(ThreadPool pool, DeliverTask deliverTask) {
        this.m_pool = pool;
        this.m_deliver_task = deliverTask;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(HandlerTask[] tasks) {
        Thread currentThread = Thread.currentThread();
        TaskExecuter executer = null;
        Map map = this.m_running_threads;
        synchronized (map) {
            TaskExecuter runningExecutor = (TaskExecuter)this.m_running_threads.get(currentThread);
            if (runningExecutor != null) {
                runningExecutor.add(tasks);
            } else {
                executer = new TaskExecuter(tasks, currentThread);
                this.m_running_threads.put(currentThread, executer);
            }
        }
        if (executer != null) {
            this.m_pool.executeTask(executer);
        }
    }

    private final class TaskExecuter
    implements Runnable {
        private final List m_tasks = new LinkedList();
        private final Object m_key;

        public TaskExecuter(HandlerTask[] tasks, Object key) {
            this.m_key = key;
            this.m_tasks.add(tasks);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean running;
            do {
                HandlerTask[] tasks = null;
                Object object = this.m_tasks;
                synchronized (object) {
                    tasks = (HandlerTask[])this.m_tasks.remove(0);
                }
                AsyncDeliverTasks.this.m_deliver_task.execute(tasks);
                object = AsyncDeliverTasks.this.m_running_threads;
                synchronized (object) {
                    boolean bl = running = this.m_tasks.size() > 0;
                    if (!running) {
                        AsyncDeliverTasks.this.m_running_threads.remove(this.m_key);
                    }
                }
            } while (running);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void add(HandlerTask[] tasks) {
            List list = this.m_tasks;
            synchronized (list) {
                this.m_tasks.add(tasks);
            }
        }
    }
}

