/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl.index;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.felix.dm.ServiceUtil;
import org.osgi.framework.ServiceReference;

public abstract class AbstractFactoryFilterIndex {
    protected final Map m_sidToServiceReferencesMap = new HashMap();
    protected final Map m_listenerToFilterMap = new HashMap();

    public void addedService(ServiceReference reference, Object service) {
        this.add(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.modify(reference);
    }

    public void removedService(ServiceReference reference, Object service) {
        this.remove(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(ServiceReference reference) {
        Long sid = ServiceUtil.getServiceIdObject(reference);
        Map map = this.m_sidToServiceReferencesMap;
        synchronized (map) {
            TreeSet<ServiceReference> list = (TreeSet<ServiceReference>)this.m_sidToServiceReferencesMap.get(sid);
            if (list == null) {
                list = new TreeSet<ServiceReference>();
                this.m_sidToServiceReferencesMap.put(sid, list);
            }
            list.add(reference);
        }
    }

    public void modify(ServiceReference reference) {
        this.remove(reference);
        this.add(reference);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void remove(ServiceReference reference) {
        Long sid = ServiceUtil.getServiceIdObject(reference);
        Map map = this.m_sidToServiceReferencesMap;
        synchronized (map) {
            Set list = (Set)this.m_sidToServiceReferencesMap.get(sid);
            if (list != null) {
                list.remove(reference);
            }
        }
    }

    protected boolean referenceMatchesObjectClass(ServiceReference ref, String objectClass) {
        boolean matches = false;
        Object value = ref.getProperty("objectClass");
        matches = Arrays.asList((String[])value).contains(objectClass);
        return matches;
    }

    protected static class FilterData {
        public long serviceId;
        public String objectClass;
        public int ranking;

        protected FilterData() {
        }

        public String toString() {
            return "FilterData [serviceId=" + this.serviceId + "]";
        }
    }
}

