/*
 * Decompiled with CFR 0.152.
 */
package org.apache.felix.dm.impl;

import java.util.ArrayList;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.felix.dm.Component;
import org.apache.felix.dm.ComponentStateListener;
import org.apache.felix.dm.Dependency;
import org.apache.felix.dm.DependencyManager;
import org.apache.felix.dm.ServiceDependency;
import org.apache.felix.dm.impl.AbstractDecorator;
import org.apache.felix.dm.impl.FilterService;
import org.osgi.framework.ServiceReference;

public class AspectServiceImpl
extends FilterService {
    public AspectServiceImpl(DependencyManager dm, Class aspectInterface, String aspectFilter, int ranking, String autoConfig, String add, String change, String remove, String swap) {
        super(dm.createComponent());
        this.m_component.setImplementation(new AspectImpl(aspectInterface, aspectFilter, ranking, autoConfig, add, change, remove, swap)).add(dm.createServiceDependency().setService(aspectInterface, this.createDependencyFilterForAspect(aspectFilter)).setAutoConfig(false).setCallbacks("added", "removed")).setCallbacks("init", null, "stop", null);
    }

    private String createDependencyFilterForAspect(String filter) {
        if (filter == null || filter.length() == 0) {
            return "(!(org.apache.felix.dependencymanager.aspect=*))";
        }
        return "(&(!(org.apache.felix.dependencymanager.aspect=*))" + filter + ")";
    }

    class AspectImpl
    extends AbstractDecorator {
        private final Class m_aspectInterface;
        private final String m_aspectFilter;
        private final int m_ranking;
        private final String m_autoConfig;
        private final String m_add;
        private final String m_change;
        private final String m_remove;
        private final String m_swap;

        public AspectImpl(Class aspectInterface, String aspectFilter, int ranking, String autoConfig, String add, String change, String remove, String swap) {
            this.m_aspectInterface = aspectInterface;
            this.m_aspectFilter = aspectFilter;
            this.m_ranking = ranking;
            this.m_autoConfig = autoConfig;
            this.m_add = add;
            this.m_change = change;
            this.m_remove = remove;
            this.m_swap = swap;
        }

        public Component createService(Object[] params) {
            int i;
            List dependencies = AspectServiceImpl.this.m_component.getDependencies();
            dependencies.remove(0);
            Properties serviceProperties = this.getServiceProperties(params);
            String[] serviceInterfaces = this.getServiceInterfaces();
            ServiceReference ref = (ServiceReference)params[0];
            ServiceDependency dependency = this.m_manager.createServiceDependency().setService(this.m_aspectInterface, this.createAspectFilter(ref)).setRequired(true);
            if (this.m_autoConfig != null) {
                dependency.setAutoConfig(this.m_autoConfig);
            }
            if (this.m_add != null || this.m_change != null || this.m_remove != null || this.m_swap != null) {
                dependency.setCallbacks(this.m_add, this.m_change, this.m_remove, this.m_swap);
            }
            Component service = this.m_manager.createComponent().setInterface(serviceInterfaces, (Dictionary)serviceProperties).setImplementation(AspectServiceImpl.this.m_serviceImpl).setFactory(AspectServiceImpl.this.m_factory, AspectServiceImpl.this.m_factoryCreateMethod).setComposition(AspectServiceImpl.this.m_compositionInstance, AspectServiceImpl.this.m_compositionMethod).setCallbacks(AspectServiceImpl.this.m_callbackObject, AspectServiceImpl.this.m_init, AspectServiceImpl.this.m_start, AspectServiceImpl.this.m_stop, AspectServiceImpl.this.m_destroy).add(dependency);
            this.configureAutoConfigState(service, AspectServiceImpl.this.m_component);
            for (i = 0; i < dependencies.size(); ++i) {
                service.add(((Dependency)dependencies.get(i)).createCopy());
            }
            for (i = 0; i < AspectServiceImpl.this.m_stateListeners.size(); ++i) {
                service.addStateListener((ComponentStateListener)AspectServiceImpl.this.m_stateListeners.get(i));
            }
            return service;
        }

        private Properties getServiceProperties(Object[] params) {
            String key;
            ServiceReference ref = (ServiceReference)params[0];
            Properties props = new Properties();
            String[] keys = ref.getPropertyKeys();
            for (int i = 0; i < keys.length; ++i) {
                key = keys[i];
                if (key.equals("service.id") || key.equals("service.ranking") || key.equals("org.apache.felix.dependencymanager.aspect") || key.equals("objectClass")) continue;
                props.put(key, ref.getProperty(key));
            }
            if (AspectServiceImpl.this.m_serviceProperties != null) {
                Enumeration e = AspectServiceImpl.this.m_serviceProperties.keys();
                while (e.hasMoreElements()) {
                    key = e.nextElement();
                    props.put(key, AspectServiceImpl.this.m_serviceProperties.get(key));
                }
            }
            props.put("org.apache.felix.dependencymanager.aspect", ref.getProperty("service.id"));
            props.put("service.ranking", (Object)this.m_ranking);
            return props;
        }

        private String[] getServiceInterfaces() {
            ArrayList<String> serviceNames = new ArrayList<String>();
            serviceNames.add(this.m_aspectInterface.getName());
            if (AspectServiceImpl.this.m_serviceInterfaces != null) {
                for (int i = 0; i < AspectServiceImpl.this.m_serviceInterfaces.length; ++i) {
                    if (AspectServiceImpl.this.m_serviceInterfaces[i].equals(this.m_aspectInterface.getName())) continue;
                    serviceNames.add(AspectServiceImpl.this.m_serviceInterfaces[i]);
                }
            }
            return serviceNames.toArray(new String[serviceNames.size()]);
        }

        private String createAspectFilter(ServiceReference ref) {
            Long sid = (Long)ref.getProperty("service.id");
            return "(&(|(!(service.ranking=*))(service.ranking<=" + (this.m_ranking - 1) + "))(|(" + "service.id" + "=" + sid + ")(" + "org.apache.felix.dependencymanager.aspect" + "=" + sid + ")))";
        }
    }
}

