/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol;

import java.io.IOException;
import java.util.Collection;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.dubbo.common.BaseServiceMetadata;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.utils.ConcurrentHashMapUtils;
import org.apache.dubbo.common.utils.ConcurrentHashSet;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.transport.CodecSupport;
import org.apache.dubbo.remoting.utils.UrlUtils;

public class PermittedSerializationKeeper {
    private final ConcurrentMap<String, Set<Byte>> serviceToSerializationId = new ConcurrentHashMap<String, Set<Byte>>();
    private final Set<Byte> globalPermittedSerializationIds = new ConcurrentHashSet();

    public void registerService(URL url) {
        Set set = (Set)ConcurrentHashMapUtils.computeIfAbsent(this.serviceToSerializationId, (Object)PermittedSerializationKeeper.keyWithoutGroup(url.getServiceKey()), k -> new ConcurrentHashSet());
        Collection serializations = UrlUtils.allSerializations((URL)url);
        for (String serialization : serializations) {
            Byte id = CodecSupport.getIDByName((String)serialization);
            if (id == null) continue;
            set.add(id);
            this.globalPermittedSerializationIds.add(id);
        }
    }

    public boolean checkSerializationPermitted(String serviceKeyWithoutGroup, Byte id) throws IOException {
        Set set = (Set)this.serviceToSerializationId.get(serviceKeyWithoutGroup);
        if (set == null) {
            throw new IOException("Service " + serviceKeyWithoutGroup + " not found, invocation rejected.");
        }
        return set.contains(id);
    }

    private static String keyWithoutGroup(String serviceKey) {
        String interfaceName = BaseServiceMetadata.interfaceFromServiceKey((String)serviceKey);
        String version = BaseServiceMetadata.versionFromServiceKey((String)serviceKey);
        if (StringUtils.isEmpty((String)version)) {
            return interfaceName;
        }
        return interfaceName + ":" + version;
    }
}

