/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.model;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.dubbo.common.utils.Assert;
import org.apache.dubbo.rpc.model.ConsumerMethodModel;

public class ConsumerModel {
    private final Object proxyObject;
    private final String serviceName;
    private final Class<?> serviceInterfaceClass;
    private final Map<Method, ConsumerMethodModel> methodModels = new IdentityHashMap<Method, ConsumerMethodModel>();

    public ConsumerModel(String serviceName, Class<?> serviceInterfaceClass, Object proxyObject, Method[] methods, Map<String, Object> attributes) {
        Assert.notEmptyString((String)serviceName, (String)"Service name can't be null or blank");
        Assert.notNull(serviceInterfaceClass, (String)"Service interface class can't null");
        Assert.notNull((Object)proxyObject, (String)"Proxy object can't be null");
        Assert.notNull((Object)methods, (String)"Methods can't be null");
        this.serviceName = serviceName;
        this.serviceInterfaceClass = serviceInterfaceClass;
        this.proxyObject = proxyObject;
        for (Method method : methods) {
            this.methodModels.put(method, new ConsumerMethodModel(method, attributes));
        }
    }

    public Object getProxyObject() {
        return this.proxyObject;
    }

    public ConsumerMethodModel getMethodModel(Method method) {
        return this.methodModels.get(method);
    }

    public ConsumerMethodModel getMethodModel(String method) {
        Optional<Map.Entry> consumerMethodModelEntry = this.methodModels.entrySet().stream().filter(entry -> ((Method)entry.getKey()).getName().equals(method)).findFirst();
        return consumerMethodModelEntry.map(Map.Entry::getValue).orElse(null);
    }

    public List<ConsumerMethodModel> getAllMethods() {
        return new ArrayList<ConsumerMethodModel>(this.methodModels.values());
    }

    public Class<?> getServiceInterfaceClass() {
        return this.serviceInterfaceClass;
    }

    public String getServiceName() {
        return this.serviceName;
    }
}

