/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.swagger;

import com.github.therapi.runtimejavadoc.ClassJavadoc;
import com.github.therapi.runtimejavadoc.Comment;
import com.github.therapi.runtimejavadoc.CommentFormatter;
import com.github.therapi.runtimejavadoc.FieldJavadoc;
import com.github.therapi.runtimejavadoc.MethodJavadoc;
import com.github.therapi.runtimejavadoc.ParamJavadoc;
import com.github.therapi.runtimejavadoc.RuntimeJavadoc;
import com.github.therapi.runtimejavadoc.internal.MethodSignature;
import com.github.therapi.runtimejavadoc.internal.RuntimeJavadocHelper;
import java.lang.ref.WeakReference;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.common.utils.LRUCache;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPIDefinitionResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPISchemaResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Info;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.OpenAPI;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Operation;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Parameter;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.PathItem;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Schema;

@Activate(order=-10000, onClass={"com.github.therapi.runtimejavadoc.RuntimeJavadoc"})
public class JavadocOpenAPIDefinitionResolver
implements OpenAPIDefinitionResolver,
OpenAPISchemaResolver {
    private final LRUCache<Class<?>, WeakReference<ClassJavadocWrapper>> cache = new LRUCache(128);
    private final CommentFormatter formatter = new CommentFormatter();

    @Override
    public OpenAPI resolve(OpenAPI openAPI, ServiceMeta serviceMeta, OpenAPIDefinitionResolver.OpenAPIChain chain) {
        if ((openAPI = chain.resolve(openAPI, serviceMeta)) == null) {
            return null;
        }
        Info info = openAPI.getInfo();
        if (info == null) {
            info = new Info();
            openAPI.setInfo(info);
        }
        if (info.getSummary() != null || info.getDescription() != null) {
            return openAPI;
        }
        ClassJavadoc javadoc = this.getClassJavadoc(serviceMeta.getType()).javadoc;
        if (javadoc.isEmpty()) {
            return openAPI;
        }
        this.populateComment(javadoc.getComment(), info::setSummary, info::setDescription);
        return openAPI;
    }

    @Override
    public Collection<HttpMethods> resolve(PathItem pathItem, MethodMeta methodMeta, OpenAPIDefinitionResolver.OperationContext context) {
        return null;
    }

    @Override
    public Operation resolve(Operation operation, MethodMeta methodMeta, OpenAPIDefinitionResolver.OperationContext ctx, OpenAPIDefinitionResolver.OperationChain chain) {
        List<Parameter> parameters;
        MethodJavadoc methodJavadoc;
        if ((operation = chain.resolve(operation, methodMeta, ctx)) == null) {
            return null;
        }
        Method method = methodMeta.getMethod();
        ClassJavadocWrapper javadoc = this.getClassJavadoc(method.getDeclaringClass());
        if (javadoc.isEmpty()) {
            return operation;
        }
        if (operation.getSummary() == null && operation.getDescription() == null && (methodJavadoc = javadoc.getMethod(method)) != null) {
            this.populateComment(methodJavadoc.getComment(), operation::setSummary, operation::setDescription);
        }
        if ((parameters = operation.getParameters()) != null) {
            for (Parameter parameter : parameters) {
                ParameterMeta meta;
                if (parameter.getDescription() != null || !((meta = parameter.getMeta()) instanceof MethodParameterMeta)) continue;
                this.populateComment(javadoc.getParameter(method, parameter.getName()), null, parameter::setDescription);
            }
        }
        return operation;
    }

    @Override
    public Schema resolve(ParameterMeta parameter, OpenAPISchemaResolver.SchemaContext context, OpenAPISchemaResolver.SchemaChain chain) {
        Comment comment;
        Schema schema;
        block7: {
            block8: {
                block6: {
                    schema = chain.resolve(parameter, context);
                    if (schema == null) {
                        return null;
                    }
                    if (schema.getTitle() != null || schema.getDescription() != null) {
                        return schema;
                    }
                    comment = null;
                    if (!(parameter instanceof MethodParameterMeta)) break block6;
                    MethodParameterMeta meta = (MethodParameterMeta)parameter;
                    Method method = meta.getMethod();
                    comment = this.getClassJavadoc(method.getDeclaringClass()).getParameter(method, parameter.getName());
                    break block7;
                }
                if (!(parameter instanceof MethodMeta.ReturnParameterMeta)) break block8;
                MethodMeta.ReturnParameterMeta meta = (MethodMeta.ReturnParameterMeta)parameter;
                Method method = meta.getMethod();
                MethodJavadoc methodJavadoc = this.getClassJavadoc(method.getDeclaringClass()).getMethod(method);
                if (methodJavadoc == null) break block7;
                comment = methodJavadoc.getReturns();
                break block7;
            }
            for (AnnotatedElement element : parameter.getAnnotatedElements()) {
                Method method;
                MethodJavadoc methodJavadoc;
                ClassJavadocWrapper javadoc;
                if (element instanceof Class) {
                    comment = this.getClassJavadoc((Class)element).getClassComment();
                    continue;
                }
                if (element instanceof Field) {
                    Field field = (Field)element;
                    javadoc = this.getClassJavadoc(field.getDeclaringClass());
                    FieldJavadoc fieldJavadoc = javadoc.getField(field);
                    if (fieldJavadoc != null) {
                        comment = fieldJavadoc.getComment();
                        break;
                    }
                    ParamJavadoc paramJavadoc = javadoc.getRecordComponent(field.getName());
                    if (paramJavadoc == null) continue;
                    comment = paramJavadoc.getComment();
                    break;
                }
                if (!(element instanceof Method) || (methodJavadoc = (javadoc = this.getClassJavadoc((method = (Method)element).getDeclaringClass())).getMethod(method)) == null) continue;
                comment = methodJavadoc.getReturns();
                break;
            }
        }
        this.populateComment(comment, schema::setTitle, schema::setDescription);
        return schema;
    }

    private ClassJavadocWrapper getClassJavadoc(Class<?> clazz) {
        ClassJavadocWrapper javadoc;
        WeakReference ref = (WeakReference)this.cache.get(clazz);
        ClassJavadocWrapper classJavadocWrapper = javadoc = ref == null ? null : (ClassJavadocWrapper)ref.get();
        if (javadoc == null) {
            javadoc = new ClassJavadocWrapper(RuntimeJavadoc.getJavadoc(clazz));
            this.cache.put(clazz, new WeakReference<ClassJavadocWrapper>(javadoc));
        }
        return javadoc;
    }

    private void populateComment(Comment comment, Consumer<String> sConsumer, Consumer<String> dConsumer) {
        if (comment == null) {
            return;
        }
        String description = this.formatter.format(comment);
        if (sConsumer == null) {
            dConsumer.accept(description);
            return;
        }
        String summary = JavadocOpenAPIDefinitionResolver.getFirstSentence(description);
        sConsumer.accept(summary);
        if (description.equals(summary)) {
            return;
        }
        dConsumer.accept(description);
    }

    private static String getFirstSentence(String text) {
        if (StringUtils.isEmpty((String)text)) {
            return text;
        }
        int pOpenIndex = text.indexOf("<p>");
        int pCloseIndex = text.indexOf("</p>");
        int dotIndex = text.indexOf(".");
        if (pOpenIndex != -1) {
            if (pOpenIndex == 0 && pCloseIndex != -1) {
                if (dotIndex != -1) {
                    return text.substring(3, Math.min(pCloseIndex, dotIndex));
                }
                return text.substring(3, pCloseIndex);
            }
            if (dotIndex != -1) {
                return text.substring(0, Math.min(pOpenIndex, dotIndex));
            }
            return text.substring(0, pOpenIndex);
        }
        if (dotIndex != -1 && text.length() != dotIndex + 1 && Character.isWhitespace(text.charAt(dotIndex + 1))) {
            return text.substring(0, dotIndex + 1);
        }
        return text;
    }

    private static final class ClassJavadocWrapper {
        private static final Map<Field, Field> MAPPING = new LinkedHashMap<Field, Field>();
        private static Field PARAMS;
        public final ClassJavadoc javadoc;
        public Map<String, FieldJavadoc> fields;
        public Map<MethodSignature, MethodJavadoc> methods;
        public Map<String, ParamJavadoc> recordComponents;

        public ClassJavadocWrapper(ClassJavadoc javadoc) {
            this.javadoc = javadoc;
            try {
                for (Map.Entry<Field, Field> entry : MAPPING.entrySet()) {
                    entry.getValue().set(this, entry.getKey().get(javadoc));
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }

        public boolean isEmpty() {
            return this.javadoc.isEmpty();
        }

        public Comment getClassComment() {
            return this.javadoc.getComment();
        }

        public FieldJavadoc getField(Field field) {
            if (this.fields == null) {
                return null;
            }
            FieldJavadoc fieldJavadoc = this.fields.get(field.getName());
            return fieldJavadoc == null || fieldJavadoc.isEmpty() ? null : fieldJavadoc;
        }

        public MethodJavadoc getMethod(Method method) {
            if (this.methods == null) {
                return null;
            }
            MethodJavadoc methodJavadoc = this.methods.get(MethodSignature.from((Executable)method));
            if (methodJavadoc != null && !methodJavadoc.isEmpty()) {
                return methodJavadoc;
            }
            Method bridgeMethod = RuntimeJavadocHelper.findBridgeMethod((Method)method);
            if (bridgeMethod != null && bridgeMethod != method && (methodJavadoc = this.methods.get(MethodSignature.from((Executable)bridgeMethod))) != null && !methodJavadoc.isEmpty()) {
                return methodJavadoc;
            }
            return null;
        }

        public Comment getParameter(Method method, String name) {
            if (this.methods == null) {
                return null;
            }
            MethodJavadoc methodJavadoc = this.methods.get(MethodSignature.from((Executable)method));
            if (methodJavadoc == null || PARAMS == null) {
                return null;
            }
            try {
                Map params = (Map)PARAMS.get(methodJavadoc);
                ParamJavadoc paramJavadoc = (ParamJavadoc)params.get(name);
                if (paramJavadoc != null) {
                    return paramJavadoc.getComment();
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
            return null;
        }

        public ParamJavadoc getRecordComponent(String name) {
            return this.recordComponents == null ? null : this.recordComponents.get(name);
        }

        static {
            try {
                Field[] fields = ClassJavadoc.class.getDeclaredFields();
                Field[] wFields = ClassJavadocWrapper.class.getFields();
                block2: for (Field field : fields) {
                    field.setAccessible(true);
                    for (Field wField : wFields) {
                        if (!wField.getName().equals(field.getName())) continue;
                        MAPPING.put(field, wField);
                        continue block2;
                    }
                }
                PARAMS = MethodJavadoc.class.getDeclaredField("params");
                PARAMS.setAccessible(true);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

