/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.support.basic;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Map;
import org.apache.dubbo.common.extension.Activate;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationEnum;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.AnnotationMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.BeanMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ParameterMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.ServiceMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Helper;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPIDefinitionResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPISchemaPredicate;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.OpenAPISchemaResolver;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.ExternalDocs;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Info;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.OpenAPI;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Operation;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.PathItem;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Schema;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Tag;
import org.apache.dubbo.rpc.protocol.tri.rest.support.basic.Annotations;

@Activate(order=100)
public final class BasicOpenAPIDefinitionResolver
implements OpenAPIDefinitionResolver,
OpenAPISchemaResolver,
OpenAPISchemaPredicate {
    private static final String HIDDEN = "hidden";

    @Override
    public OpenAPI resolve(OpenAPI openAPI, ServiceMeta serviceMeta, OpenAPIDefinitionResolver.OpenAPIChain chain) {
        String version;
        String description;
        String title;
        AnnotationMeta annoMeta = serviceMeta.findAnnotation((AnnotationEnum)Annotations.OpenAPI);
        if (annoMeta == null) {
            return chain.resolve(openAPI, serviceMeta);
        }
        if (annoMeta.getBoolean(HIDDEN)) {
            return null;
        }
        Info info = openAPI.getInfo();
        if (info == null) {
            info = new Info();
            openAPI.setInfo(info);
        }
        Map<String, String> tags = Helper.toProperties(annoMeta.getStringArray("tags"));
        for (Map.Entry<String, String> entry : tags.entrySet()) {
            openAPI.addTag(new Tag().setName(entry.getKey()).setDescription(entry.getValue()));
        }
        String group = Helper.trim(annoMeta.getString("group"));
        if (group != null) {
            openAPI.setGroup(group);
        }
        if ((title = Helper.trim(annoMeta.getString("infoTitle"))) != null) {
            info.setTitle(title);
        }
        if ((description = Helper.trim(annoMeta.getString("infoDescription"))) != null) {
            info.setDescription(description);
        }
        if ((version = Helper.trim(annoMeta.getString("infoVersion"))) != null) {
            info.setVersion(version);
        }
        String docDescription = Helper.trim(annoMeta.getString("docDescription"));
        String docUrl = Helper.trim(annoMeta.getString("docUrl"));
        if (docDescription != null || docUrl != null) {
            openAPI.setExternalDocs(new ExternalDocs().setDescription(docDescription).setUrl(docUrl));
        }
        openAPI.setPriority((Integer)annoMeta.getNumber("order"));
        openAPI.setExtensions(Helper.toProperties(annoMeta.getStringArray("extensions")));
        return chain.resolve(openAPI, serviceMeta);
    }

    @Override
    public Collection<HttpMethods> resolve(PathItem pathItem, MethodMeta methodMeta, OpenAPIDefinitionResolver.OperationContext context) {
        AnnotationMeta annoMeta = methodMeta.findAnnotation((AnnotationEnum)Annotations.Operation);
        if (annoMeta == null) {
            return null;
        }
        String method = Helper.trim(annoMeta.getString("method"));
        if (method == null) {
            return null;
        }
        return Collections.singletonList(HttpMethods.of((String)method.toUpperCase()));
    }

    @Override
    public Operation resolve(Operation operation, MethodMeta methodMeta, OpenAPIDefinitionResolver.OperationContext ctx, OpenAPIDefinitionResolver.OperationChain chain) {
        String summary;
        AnnotationMeta annoMeta = methodMeta.findAnnotation((AnnotationEnum)Annotations.Operation);
        if (annoMeta == null) {
            return chain.resolve(operation, methodMeta, ctx);
        }
        if (annoMeta.getBoolean(HIDDEN)) {
            return null;
        }
        String[] tags = Helper.trim(annoMeta.getStringArray("tags"));
        if (tags != null) {
            operation.setTags(new LinkedHashSet<String>(Arrays.asList(tags)));
        }
        if ((summary = Helper.trim(annoMeta.getValue())) == null) {
            summary = Helper.trim(annoMeta.getString("summary"));
        }
        operation.setGroup(Helper.trim(annoMeta.getString("group"))).setVersion(Helper.trim(annoMeta.getString("version"))).setOperationId(Helper.trim(annoMeta.getString("id"))).setSummary(summary).setDescription(Helper.trim(annoMeta.getString("description"))).setDeprecated(annoMeta.getBoolean("deprecated")).setExtensions(Helper.toProperties(annoMeta.getStringArray("extensions")));
        return chain.resolve(operation, methodMeta, ctx);
    }

    @Override
    public Schema resolve(ParameterMeta parameter, OpenAPISchemaResolver.SchemaContext context, OpenAPISchemaResolver.SchemaChain chain) {
        AnnotationMeta annoMeta = parameter.getAnnotation((AnnotationEnum)Annotations.Schema);
        if (annoMeta == null) {
            return chain.resolve(parameter, context);
        }
        if (annoMeta.getBoolean(HIDDEN)) {
            return null;
        }
        Class impl = annoMeta.getClass("implementation");
        Schema schema = impl == Void.class ? chain.resolve(parameter, context) : context.resolve(impl);
        Helper.setValue(annoMeta, "group", schema::setGroup);
        Helper.setValue(annoMeta, "version", schema::setVersion);
        Helper.setValue(annoMeta, "type", v -> schema.setType(Schema.Type.valueOf(v)));
        Helper.setValue(annoMeta, "format", schema::setFormat);
        Helper.setValue(annoMeta, "name", schema::setName);
        String title = Helper.trim(annoMeta.getValue());
        schema.setTitle(title == null ? Helper.trim(annoMeta.getString("title")) : title);
        Helper.setValue(annoMeta, "description", schema::setDescription);
        Helper.setValue(annoMeta, "defaultValue", schema::setDefaultValue);
        Helper.setValue(annoMeta, "max", v -> schema.setMaxLength(Integer.parseInt(v)));
        Helper.setValue(annoMeta, "min", v -> schema.setMinLength(Integer.parseInt(v)));
        Helper.setValue(annoMeta, "pattern", schema::setPattern);
        Helper.setValue(annoMeta, "example", schema::setExample);
        String[] enumItems = Helper.trim(annoMeta.getStringArray("enumeration"));
        if (enumItems != null) {
            schema.setEnumeration(Arrays.asList(enumItems));
        }
        Helper.setBoolValue(annoMeta, "required", schema::setRequired);
        Helper.setBoolValue(annoMeta, "readOnly", schema::setReadOnly);
        Helper.setBoolValue(annoMeta, "writeOnly", schema::setWriteOnly);
        Helper.setBoolValue(annoMeta, "nullable", schema::setNullable);
        Helper.setBoolValue(annoMeta, "deprecated", schema::setDeprecated);
        schema.setExtensions(Helper.toProperties(annoMeta.getStringArray("extensions")));
        return chain.resolve(parameter, context);
    }

    @Override
    public Boolean acceptProperty(BeanMeta bean, BeanMeta.PropertyMeta property) {
        AnnotationMeta annoMeta = property.getAnnotation((AnnotationEnum)Annotations.Schema);
        return annoMeta == null ? null : Boolean.valueOf(annoMeta.getBoolean(HIDDEN));
    }
}

