/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Example;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.MediaType;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Schema;

public final class Header
extends Node<Header> {
    private String description;
    private Boolean required;
    private Boolean deprecated;
    private Boolean allowEmptyValue;
    private final Style style = Style.SIMPLE;
    private Boolean explode;
    private Schema schema;
    private Object example;
    private Map<String, Example> examples;
    private Map<String, MediaType> contents;

    public String getDescription() {
        return this.description;
    }

    public Header setDescription(String description) {
        this.description = description;
        return this;
    }

    public Boolean getRequired() {
        return this.required;
    }

    public Header setRequired(Boolean required) {
        this.required = required;
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public Header setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public Boolean getAllowEmptyValue() {
        return this.allowEmptyValue;
    }

    public Header setAllowEmptyValue(Boolean allowEmptyValue) {
        this.allowEmptyValue = allowEmptyValue;
        return this;
    }

    public Style getStyle() {
        return this.style;
    }

    public Boolean getExplode() {
        return this.explode;
    }

    public Header setExplode(Boolean explode) {
        this.explode = explode;
        return this;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public Header setSchema(Schema schema) {
        this.schema = schema;
        return this;
    }

    public Object getExample() {
        return this.example;
    }

    public Header setExample(Object example) {
        this.example = example;
        return this;
    }

    public Map<String, Example> getExamples() {
        return this.examples;
    }

    public Header setExamples(Map<String, Example> examples) {
        this.examples = examples;
        return this;
    }

    public Header addExample(String name, Example example) {
        if (this.examples == null) {
            this.examples = new LinkedHashMap<String, Example>();
        }
        this.examples.put(name, example);
        return this;
    }

    public Header removeExample(String name) {
        if (this.examples != null) {
            this.examples.remove(name);
        }
        return this;
    }

    public Map<String, MediaType> getContents() {
        return this.contents;
    }

    public MediaType getContent(String name) {
        return this.contents == null ? null : this.contents.get(name);
    }

    public Header setContents(Map<String, MediaType> contents) {
        this.contents = contents;
        return this;
    }

    public Header addContent(String name, MediaType content) {
        if (this.contents == null) {
            this.contents = new LinkedHashMap<String, MediaType>();
        }
        this.contents.put(name, content);
        return this;
    }

    public Header removeContent(String name) {
        if (this.contents != null) {
            this.contents.remove(name);
        }
        return this;
    }

    @Override
    public Header clone() {
        Header clone = (Header)super.clone();
        clone.schema = Header.clone(this.schema);
        clone.examples = Header.clone(this.examples);
        clone.contents = Header.clone(this.contents);
        return clone;
    }

    @Override
    public Map<String, Object> writeTo(Map<String, Object> node, Context context) {
        Header.write(node, "description", this.description);
        Header.write(node, "required", this.required);
        Header.write(node, "deprecated", this.deprecated);
        Header.write(node, "allowEmptyValue", this.allowEmptyValue);
        Header.write(node, "style", (Object)this.style);
        Header.write(node, "explode", this.explode);
        Header.write(node, "schema", this.schema, context);
        Header.write(node, "example", this.example);
        Header.write(node, "examples", this.examples, context);
        Header.write(node, "content", this.contents, context);
        this.writeExtensions(node);
        return node;
    }

    public static enum Style {
        SIMPLE("simple");

        private final String value;

        private Style(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

