/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi.model;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.MediaType;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;

public final class RequestBody
extends Node<RequestBody> {
    private String description;
    private Map<String, MediaType> contents;
    private boolean required;

    public String getDescription() {
        return this.description;
    }

    public RequestBody setDescription(String description) {
        this.description = description;
        return this;
    }

    public Map<String, MediaType> getContents() {
        return this.contents;
    }

    public MediaType getContent(String content) {
        return this.contents == null ? null : this.contents.get(content);
    }

    public MediaType getOrAddContent(String content) {
        if (this.contents == null) {
            this.contents = new LinkedHashMap<String, MediaType>();
        }
        return this.contents.computeIfAbsent(content, k -> new MediaType());
    }

    public RequestBody setContents(Map<String, MediaType> contents) {
        this.contents = contents;
        return this;
    }

    public RequestBody addContent(String name, MediaType content) {
        if (this.contents == null) {
            this.contents = new LinkedHashMap<String, MediaType>();
        }
        this.contents.put(name, content);
        return this;
    }

    public RequestBody removeContent(String name) {
        if (this.contents != null) {
            this.contents.remove(name);
        }
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public RequestBody setRequired(boolean required) {
        this.required = required;
        return this;
    }

    @Override
    public RequestBody clone() {
        RequestBody clone = (RequestBody)super.clone();
        clone.contents = RequestBody.clone(this.contents);
        return clone;
    }

    @Override
    public Map<String, Object> writeTo(Map<String, Object> node, Context context) {
        RequestBody.write(node, "description", this.description);
        RequestBody.write(node, "required", this.required);
        RequestBody.write(node, "content", this.contents, context);
        return node;
    }
}

