/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.rpc.protocol.tri.rest.openapi.model;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.dubbo.remoting.http12.HttpMethods;
import org.apache.dubbo.rpc.protocol.tri.rest.mapping.meta.MethodMeta;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.Context;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.ApiResponse;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.ExternalDocs;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Node;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Parameter;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.RequestBody;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.SecurityRequirement;
import org.apache.dubbo.rpc.protocol.tri.rest.openapi.model.Server;
import org.apache.dubbo.rpc.protocol.tri.rest.util.TypeUtils;

public final class Operation
extends Node<Operation> {
    private Set<String> tags;
    private String summary;
    private String description;
    private ExternalDocs externalDocs;
    private String operationId;
    private List<Parameter> parameters;
    private RequestBody requestBody;
    private Map<String, ApiResponse> responses;
    private Boolean deprecated;
    private List<SecurityRequirement> security;
    private List<Server> servers;
    private String group;
    private String version;
    private HttpMethods httpMethod;
    private transient MethodMeta meta;

    public Set<String> getTags() {
        return this.tags;
    }

    public Operation setTags(Set<String> tags) {
        this.tags = tags;
        return this;
    }

    public Operation addTag(String tag) {
        if (this.tags == null) {
            this.tags = new LinkedHashSet<String>();
        }
        this.tags.add(tag);
        return this;
    }

    public Operation removeTag(String tag) {
        if (this.tags != null) {
            this.tags.remove(tag);
        }
        return this;
    }

    public String getSummary() {
        return this.summary;
    }

    public Operation setSummary(String summary) {
        this.summary = summary;
        return this;
    }

    public String getDescription() {
        return this.description;
    }

    public Operation setDescription(String description) {
        this.description = description;
        return this;
    }

    public ExternalDocs getExternalDocs() {
        return this.externalDocs;
    }

    public Operation setExternalDocs(ExternalDocs externalDocs) {
        this.externalDocs = externalDocs;
        return this;
    }

    public String getOperationId() {
        return this.operationId;
    }

    public Operation setOperationId(String operationId) {
        this.operationId = operationId;
        return this;
    }

    public List<Parameter> getParameters() {
        return this.parameters;
    }

    public Parameter getParameter(String name, Parameter.In in) {
        if (this.parameters == null || name == null || in == null) {
            return null;
        }
        int size = this.parameters.size();
        for (int i = 0; i < size; ++i) {
            Parameter parameter = this.parameters.get(i);
            if (!name.equals(parameter.getName()) || in != parameter.getIn()) continue;
            return parameter;
        }
        return null;
    }

    public Operation setParameters(List<Parameter> parameters) {
        this.parameters = parameters;
        return this;
    }

    public Operation addParameter(Parameter parameter) {
        if (this.parameters == null) {
            this.parameters = new ArrayList<Parameter>();
        }
        this.parameters.add(parameter);
        return this;
    }

    public Operation removeParameter(Parameter parameter) {
        if (this.parameters != null) {
            this.parameters.remove(parameter);
        }
        return this;
    }

    public RequestBody getRequestBody() {
        return this.requestBody;
    }

    public Operation setRequestBody(RequestBody requestBody) {
        this.requestBody = requestBody;
        return this;
    }

    public Map<String, ApiResponse> getResponses() {
        return this.responses;
    }

    public ApiResponse getResponse(String httpStatusCode) {
        return this.responses == null ? null : this.responses.get(httpStatusCode);
    }

    public ApiResponse getOrAddResponse(String httpStatusCode) {
        if (this.responses == null) {
            this.responses = new LinkedHashMap<String, ApiResponse>();
        }
        return this.responses.computeIfAbsent(httpStatusCode, k -> new ApiResponse());
    }

    public Operation setResponses(Map<String, ApiResponse> responses) {
        this.responses = responses;
        return this;
    }

    public Operation addResponse(String name, ApiResponse response) {
        if (this.responses == null) {
            this.responses = new LinkedHashMap<String, ApiResponse>();
        }
        this.responses.put(name, response);
        return this;
    }

    public Operation removeResponse(String name) {
        if (this.responses != null) {
            this.responses.remove(name);
        }
        return this;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public Operation setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
        return this;
    }

    public List<SecurityRequirement> getSecurity() {
        return this.security;
    }

    public Operation setSecurity(List<SecurityRequirement> security) {
        this.security = security;
        return this;
    }

    public Operation addSecurity(SecurityRequirement security) {
        if (this.security == null) {
            this.security = new ArrayList<SecurityRequirement>();
        }
        this.security.add(security);
        return this;
    }

    public Operation removeSecurity(SecurityRequirement security) {
        if (this.security != null) {
            this.security.remove(security);
        }
        return this;
    }

    public List<Server> getServers() {
        return this.servers;
    }

    public Operation setServers(List<Server> servers) {
        this.servers = servers;
        return this;
    }

    public Operation addServer(Server server) {
        if (this.servers == null) {
            this.servers = new ArrayList<Server>();
        }
        this.servers.add(server);
        return this;
    }

    public Operation removeServer(Server server) {
        if (this.servers != null) {
            this.servers.remove(server);
        }
        return this;
    }

    public String getGroup() {
        return this.group;
    }

    public Operation setGroup(String group) {
        this.group = group;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public Operation setVersion(String version) {
        this.version = version;
        return this;
    }

    public HttpMethods getHttpMethod() {
        return this.httpMethod;
    }

    public Operation setHttpMethod(HttpMethods httpMethod) {
        this.httpMethod = httpMethod;
        return this;
    }

    public MethodMeta getMeta() {
        return this.meta;
    }

    public Operation setMeta(MethodMeta meta) {
        this.meta = meta;
        return this;
    }

    @Override
    public Operation clone() {
        Operation clone = (Operation)super.clone();
        if (this.tags != null) {
            clone.tags = new LinkedHashSet<String>(this.tags);
        }
        clone.externalDocs = Operation.clone(this.externalDocs);
        clone.parameters = Operation.clone(this.parameters);
        clone.requestBody = Operation.clone(this.requestBody);
        clone.responses = Operation.clone(this.responses);
        clone.security = Operation.clone(this.security);
        clone.servers = Operation.clone(this.servers);
        return clone;
    }

    @Override
    public Map<String, Object> writeTo(Map<String, Object> node, Context context) {
        Operation.write(node, "tags", this.tags);
        Operation.write(node, "summary", this.summary);
        Operation.write(node, "description", this.description);
        Operation.write(node, "externalDocs", this.externalDocs, context);
        Operation.write(node, "operationId", this.operationId);
        Operation.write(node, "parameters", this.parameters, context);
        Operation.write(node, "requestBody", this.requestBody, context);
        Operation.write(node, "responses", this.responses, context);
        Operation.write(node, "deprecated", this.deprecated);
        Operation.write(node, "security", this.security, context);
        Operation.write(node, "servers", this.servers, context);
        this.writeExtensions(node);
        Operation.write(node, "x-java-class", this.meta.getServiceMeta().getServiceInterface());
        Operation.write(node, "x-java-method", this.meta.getMethod().getName());
        Operation.write(node, "x-java-method-descriptor", TypeUtils.getMethodDescriptor((MethodMeta)this.meta));
        return node;
    }
}

