/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.api.pu;

import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.common.extension.ExtensionLoader;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.remoting.ChannelHandler;
import org.apache.dubbo.remoting.RemotingException;
import org.apache.dubbo.remoting.api.WireProtocol;
import org.apache.dubbo.remoting.transport.AbstractServer;

public abstract class AbstractPortUnificationServer
extends AbstractServer {
    private volatile Map<String, WireProtocol> protocols;
    private final Map<String, URL> supportedUrls = new ConcurrentHashMap<String, URL>();
    private final Map<String, ChannelHandler> supportedHandlers = new ConcurrentHashMap<String, ChannelHandler>();

    public AbstractPortUnificationServer(URL url, ChannelHandler handler) throws RemotingException {
        super(url, handler);
    }

    public Map<String, WireProtocol> getProtocols() {
        return this.protocols;
    }

    @Override
    protected final void doOpen() {
        ExtensionLoader loader = this.getUrl().getOrDefaultFrameworkModel().getExtensionLoader(WireProtocol.class);
        Map protocols = loader.getActivateExtension(this.getUrl(), new String[0]).stream().collect(Collectors.toConcurrentMap(arg_0 -> ((ExtensionLoader)loader).getExtensionName(arg_0), Function.identity()));
        String extraProtocols = this.getUrl().getParameter("ext.protocol");
        if (StringUtils.isNotEmpty((String)extraProtocols)) {
            Arrays.stream(extraProtocols.split(",")).forEach(p -> protocols.put(p, (WireProtocol)loader.getExtension(p)));
        }
        this.protocols = protocols;
        this.doOpen0();
    }

    protected abstract void doOpen0();

    public void addSupportedProtocol(URL url, ChannelHandler handler) {
        this.supportedUrls.put(url.getProtocol(), url);
        this.supportedHandlers.put(url.getProtocol(), handler);
    }

    protected Map<String, URL> getSupportedUrls() {
        return this.supportedUrls;
    }

    public Map<String, ChannelHandler> getSupportedHandlers() {
        return this.supportedHandlers;
    }
}

