/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support.header;

import java.util.Collection;
import java.util.concurrent.TimeUnit;
import org.apache.dubbo.common.timer.HashedWheelTimer;
import org.apache.dubbo.common.timer.Timeout;
import org.apache.dubbo.common.timer.TimerTask;
import org.apache.dubbo.remoting.Channel;

public abstract class AbstractTimerTask
implements TimerTask {
    private final ChannelProvider channelProvider;
    private final HashedWheelTimer hashedWheelTimer;
    private final Long tick;
    protected volatile boolean cancel = false;
    private volatile Timeout timeout;

    AbstractTimerTask(ChannelProvider channelProvider, HashedWheelTimer hashedWheelTimer, Long tick) {
        if (channelProvider == null || hashedWheelTimer == null || tick == null) {
            throw new IllegalArgumentException();
        }
        this.channelProvider = channelProvider;
        this.hashedWheelTimer = hashedWheelTimer;
        this.tick = tick;
        this.start();
    }

    static Long lastRead(Channel channel) {
        return (Long)channel.getAttribute("READ_TIMESTAMP");
    }

    static Long lastWrite(Channel channel) {
        return (Long)channel.getAttribute("WRITE_TIMESTAMP");
    }

    static Long now() {
        return System.currentTimeMillis();
    }

    private void start() {
        this.timeout = this.hashedWheelTimer.newTimeout((TimerTask)this, this.tick.longValue(), TimeUnit.MILLISECONDS);
    }

    public synchronized void cancel() {
        this.cancel = true;
        this.timeout.cancel();
    }

    private synchronized void reput(Timeout timeout) {
        if (timeout == null) {
            throw new IllegalArgumentException();
        }
        if (this.cancel) {
            return;
        }
        if (this.hashedWheelTimer.isStop() || timeout.isCancelled()) {
            return;
        }
        this.timeout = this.hashedWheelTimer.newTimeout(timeout.task(), this.tick.longValue(), TimeUnit.MILLISECONDS);
    }

    public synchronized void run(Timeout timeout) throws Exception {
        Collection<Channel> channels = this.channelProvider.getChannels();
        for (Channel channel : channels) {
            if (channel.isClosed()) continue;
            this.doTask(channel);
        }
        this.reput(timeout);
    }

    protected abstract void doTask(Channel var1);

    static interface ChannelProvider {
        public Collection<Channel> getChannels();
    }
}

