/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.remoting.exchange.support.header;

import org.apache.dubbo.common.Version;
import org.apache.dubbo.common.constants.CommonConstants;
import org.apache.dubbo.common.logger.Logger;
import org.apache.dubbo.common.logger.LoggerFactory;
import org.apache.dubbo.remoting.Channel;
import org.apache.dubbo.remoting.exchange.Request;
import org.apache.dubbo.remoting.exchange.support.header.AbstractTimerTask;

public class HeartbeatTimerTask
extends AbstractTimerTask {
    private static final Logger logger = LoggerFactory.getLogger(HeartbeatTimerTask.class);
    private final int heartbeat;

    HeartbeatTimerTask(AbstractTimerTask.ChannelProvider channelProvider, Long heartbeatTick, int heartbeat) {
        super(channelProvider, heartbeatTick);
        this.heartbeat = heartbeat;
    }

    @Override
    protected void doTask(Channel channel) {
        try {
            Long lastRead = HeartbeatTimerTask.lastRead(channel);
            Long lastWrite = HeartbeatTimerTask.lastWrite(channel);
            if (lastRead != null && HeartbeatTimerTask.now() - lastRead > (long)this.heartbeat || lastWrite != null && HeartbeatTimerTask.now() - lastWrite > (long)this.heartbeat) {
                Request req = new Request();
                req.setVersion(Version.getProtocolVersion());
                req.setTwoWay(true);
                req.setEvent(CommonConstants.HEARTBEAT_EVENT);
                channel.send(req);
                if (logger.isDebugEnabled()) {
                    logger.debug("Send heartbeat to remote channel " + channel.getRemoteAddress() + ", cause: The channel has no data-transmission exceeds a heartbeat period: " + this.heartbeat + "ms");
                }
            }
        }
        catch (Throwable t) {
            logger.warn("Exception when heartbeat to remote channel " + channel.getRemoteAddress(), t);
        }
    }
}

