/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.util;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.VariableElement;
import javax.lang.model.type.TypeMirror;
import org.apache.dubbo.metadata.annotation.processing.util.TypeUtils;

public interface MemberUtils {
    public static boolean matches(Element member, ElementKind kind) {
        return member == null || kind == null ? false : kind.equals((Object)member.getKind());
    }

    public static boolean isPublicNonStatic(Element member) {
        return MemberUtils.hasModifiers(member, Modifier.PUBLIC) && !MemberUtils.hasModifiers(member, Modifier.STATIC);
    }

    public static boolean hasModifiers(Element member, Modifier ... modifiers) {
        if (member == null || modifiers == null) {
            return false;
        }
        Set<Modifier> actualModifiers = member.getModifiers();
        for (Modifier modifier : modifiers) {
            if (actualModifiers.contains((Object)modifier)) continue;
            return false;
        }
        return true;
    }

    public static List<? extends Element> getDeclaredMembers(TypeMirror type) {
        TypeElement element = TypeUtils.ofTypeElement(type);
        return element == null ? Collections.emptyList() : element.getEnclosedElements();
    }

    public static List<? extends Element> getAllDeclaredMembers(TypeMirror type) {
        return TypeUtils.getHierarchicalTypes(type).stream().map(MemberUtils::getDeclaredMembers).flatMap(Collection::stream).collect(Collectors.toList());
    }

    public static boolean matchParameterTypes(List<? extends VariableElement> parameters, CharSequence ... parameterTypes) {
        int size = parameters.size();
        if (size != parameterTypes.length) {
            return false;
        }
        for (int i = 0; i < size; ++i) {
            VariableElement parameter = parameters.get(i);
            if (Objects.equals(parameter.asType().toString(), parameterTypes[i])) continue;
            return false;
        }
        return true;
    }
}

