/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing.util;

import java.io.IOException;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.processing.ProcessingEnvironment;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.TypeElement;
import javax.lang.model.element.TypeParameterElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeKind;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.Elements;
import javax.tools.FileObject;
import javax.tools.StandardLocation;
import org.apache.dubbo.common.function.Predicates;
import org.apache.dubbo.common.function.Streams;
import org.apache.dubbo.common.utils.ClassUtils;
import org.apache.dubbo.common.utils.MethodUtils;

public interface TypeUtils {
    public static final List<String> SIMPLE_TYPES = Arrays.asList((String[])ClassUtils.SIMPLE_TYPES.stream().map(Class::getName).toArray(String[]::new));

    public static boolean isSimpleType(Element element) {
        return element != null && TypeUtils.isSimpleType(element.asType());
    }

    public static boolean isSimpleType(TypeMirror type) {
        return type != null && SIMPLE_TYPES.contains(type.toString());
    }

    public static boolean isSameType(TypeMirror type, CharSequence typeName) {
        if (type == null || typeName == null) {
            return false;
        }
        return Objects.equals(String.valueOf(type), String.valueOf(typeName));
    }

    public static boolean isSameType(TypeMirror typeMirror, Type type) {
        return type != null && TypeUtils.isSameType(typeMirror, type.getTypeName());
    }

    public static boolean isArrayType(TypeMirror type) {
        return type != null && TypeKind.ARRAY.equals((Object)type.getKind());
    }

    public static boolean isArrayType(Element element) {
        return element != null && TypeUtils.isArrayType(element.asType());
    }

    public static boolean isEnumType(TypeMirror type) {
        DeclaredType declaredType = TypeUtils.ofDeclaredType(type);
        return declaredType != null && ElementKind.ENUM.equals((Object)declaredType.asElement().getKind());
    }

    public static boolean isEnumType(Element element) {
        return element != null && TypeUtils.isEnumType(element.asType());
    }

    public static boolean isClassType(TypeMirror type) {
        DeclaredType declaredType = TypeUtils.ofDeclaredType(type);
        return declaredType != null && TypeUtils.isClassType(declaredType.asElement());
    }

    public static boolean isClassType(Element element) {
        return element != null && ElementKind.CLASS.equals((Object)element.getKind());
    }

    public static boolean isPrimitiveType(TypeMirror type) {
        return type != null && type.getKind().isPrimitive();
    }

    public static boolean isPrimitiveType(Element element) {
        return element != null && TypeUtils.isPrimitiveType(element.asType());
    }

    public static boolean isInterfaceType(TypeMirror type) {
        DeclaredType declaredType = TypeUtils.ofDeclaredType(type);
        return declaredType != null && TypeUtils.isInterfaceType(declaredType.asElement());
    }

    public static boolean isInterfaceType(Element element) {
        return element != null && ElementKind.INTERFACE.equals((Object)element.getKind());
    }

    public static boolean isAnnotationType(TypeMirror type) {
        DeclaredType declaredType = TypeUtils.ofDeclaredType(type);
        return declaredType != null && TypeUtils.isAnnotationType(declaredType.asElement());
    }

    public static boolean isAnnotationType(Element element) {
        return element != null && ElementKind.ANNOTATION_TYPE.equals((Object)element.getKind());
    }

    public static Set<TypeElement> getHierarchicalTypes(TypeElement type) {
        return TypeUtils.getHierarchicalTypes(type, true, true, true, new Predicate[0]);
    }

    public static Set<DeclaredType> getHierarchicalTypes(TypeMirror type) {
        return TypeUtils.getHierarchicalTypes(type, Predicates.EMPTY_ARRAY);
    }

    public static Set<DeclaredType> getHierarchicalTypes(TypeMirror type, Predicate<DeclaredType> ... typeFilters) {
        return (Set)Streams.filterAll(TypeUtils.ofDeclaredTypes(TypeUtils.getHierarchicalTypes(TypeUtils.ofTypeElement(type))), (Predicate[])typeFilters);
    }

    public static Set<DeclaredType> getHierarchicalTypes(TypeMirror type, Type ... excludedTypes) {
        return TypeUtils.getHierarchicalTypes(type, (CharSequence[])Stream.of(excludedTypes).map(Type::getTypeName).toArray(String[]::new));
    }

    public static Set<DeclaredType> getHierarchicalTypes(TypeMirror type, CharSequence ... excludedTypeNames) {
        Set typeNames = Stream.of(excludedTypeNames).map(CharSequence::toString).collect(Collectors.toSet());
        return TypeUtils.getHierarchicalTypes(type, t -> !typeNames.contains(t.toString()));
    }

    public static Set<TypeElement> getHierarchicalTypes(TypeElement type, boolean includeSelf, boolean includeSuperTypes, boolean includeSuperInterfaces, Predicate<TypeElement> ... typeFilters) {
        if (type == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<TypeElement> hierarchicalTypes = new LinkedHashSet<TypeElement>();
        if (includeSelf) {
            hierarchicalTypes.add(type);
        }
        if (includeSuperTypes) {
            hierarchicalTypes.addAll(TypeUtils.getAllSuperTypes(type));
        }
        if (includeSuperInterfaces) {
            hierarchicalTypes.addAll(TypeUtils.getAllInterfaces(type, new Predicate[0]));
        }
        return (Set)Streams.filterAll(hierarchicalTypes, (Predicate[])typeFilters);
    }

    public static Set<DeclaredType> getHierarchicalTypes(TypeMirror type, boolean includeSelf, boolean includeSuperTypes, boolean includeSuperInterfaces) {
        return TypeUtils.ofDeclaredTypes(TypeUtils.getHierarchicalTypes(TypeUtils.ofTypeElement(type), includeSelf, includeSuperTypes, includeSuperInterfaces, new Predicate[0]));
    }

    public static List<TypeMirror> getInterfaces(TypeElement type, Predicate<TypeMirror> ... interfaceFilters) {
        return type == null ? Collections.emptyList() : (List)Streams.filterAll(TypeUtils.ofTypeElement(type).getInterfaces(), (Predicate[])interfaceFilters);
    }

    public static List<TypeMirror> getInterfaces(TypeMirror type, Predicate<TypeMirror> ... interfaceFilters) {
        return TypeUtils.getInterfaces(TypeUtils.ofTypeElement(type), interfaceFilters);
    }

    public static Set<TypeElement> getAllInterfaces(TypeElement type, Predicate<TypeElement> ... interfaceFilters) {
        return type == null ? Collections.emptySet() : (Set)Streams.filterAll(TypeUtils.ofTypeElements(TypeUtils.getAllInterfaces(type.asType(), new Predicate[0])), (Predicate[])interfaceFilters);
    }

    public static Set<? extends TypeMirror> getAllInterfaces(TypeMirror type, Predicate<TypeMirror> ... interfaceFilters) {
        if (type == null) {
            return Collections.emptySet();
        }
        LinkedHashSet allInterfaces = new LinkedHashSet();
        TypeUtils.getInterfaces(type, new Predicate[0]).forEach(i -> {
            allInterfaces.add(i);
            allInterfaces.addAll(TypeUtils.getAllInterfaces(i, new Predicate[0]));
        });
        TypeUtils.getAllSuperTypes(type).forEach(superType -> allInterfaces.addAll(TypeUtils.getAllInterfaces(superType, new Predicate[0])));
        return (Set)Streams.filterAll(allInterfaces, (Predicate[])interfaceFilters);
    }

    public static TypeMirror findInterface(TypeMirror type, CharSequence interfaceClassName) {
        return (TypeMirror)Streams.filterFirst(TypeUtils.getAllInterfaces(type, new Predicate[0]), (Predicate[])new Predicate[]{t -> TypeUtils.isSameType(t, interfaceClassName)});
    }

    public static TypeElement getType(ProcessingEnvironment processingEnv, Type type) {
        return type == null ? null : TypeUtils.getType(processingEnv, type.getTypeName());
    }

    public static TypeElement getType(ProcessingEnvironment processingEnv, TypeMirror type) {
        return type == null ? null : TypeUtils.getType(processingEnv, type.toString());
    }

    public static TypeElement getType(ProcessingEnvironment processingEnv, CharSequence typeName) {
        if (processingEnv == null || typeName == null) {
            return null;
        }
        Elements elements = processingEnv.getElementUtils();
        return elements.getTypeElement(typeName);
    }

    public static TypeElement getSuperType(TypeElement type) {
        return type == null ? null : TypeUtils.ofTypeElement(type.getSuperclass());
    }

    public static DeclaredType getSuperType(TypeMirror type) {
        TypeElement superType = TypeUtils.getSuperType(TypeUtils.ofTypeElement(type));
        return superType == null ? null : TypeUtils.ofDeclaredType(superType.asType());
    }

    public static Set<TypeElement> getAllSuperTypes(TypeElement type) {
        return TypeUtils.getAllSuperTypes(type, Predicates.EMPTY_ARRAY);
    }

    public static Set<TypeElement> getAllSuperTypes(TypeElement type, Predicate<TypeElement> ... typeFilters) {
        if (type == null) {
            return Collections.emptySet();
        }
        LinkedHashSet<TypeElement> allSuperTypes = new LinkedHashSet<TypeElement>();
        TypeElement superType = TypeUtils.getSuperType(type);
        if (superType != null) {
            allSuperTypes.add(superType);
            allSuperTypes.addAll(TypeUtils.getAllSuperTypes(superType));
        }
        return (Set)Streams.filterAll(allSuperTypes, (Predicate[])typeFilters);
    }

    public static Set<DeclaredType> getAllSuperTypes(TypeMirror type) {
        return TypeUtils.getAllSuperTypes(type, Predicates.EMPTY_ARRAY);
    }

    public static Set<DeclaredType> getAllSuperTypes(TypeMirror type, Predicate<DeclaredType> ... typeFilters) {
        return (Set)Streams.filterAll(TypeUtils.ofDeclaredTypes(TypeUtils.getAllSuperTypes(TypeUtils.ofTypeElement(type))), (Predicate[])typeFilters);
    }

    public static boolean isDeclaredType(Element element) {
        return element != null && TypeUtils.isDeclaredType(element.asType());
    }

    public static boolean isDeclaredType(TypeMirror type) {
        return type instanceof DeclaredType;
    }

    public static DeclaredType ofDeclaredType(Element element) {
        return element == null ? null : TypeUtils.ofDeclaredType(element.asType());
    }

    public static DeclaredType ofDeclaredType(TypeMirror type) {
        return TypeUtils.isDeclaredType(type) ? (DeclaredType)type : null;
    }

    public static boolean isTypeElement(Element element) {
        return element instanceof TypeElement;
    }

    public static boolean isTypeElement(TypeMirror type) {
        DeclaredType declaredType = TypeUtils.ofDeclaredType(type);
        return declaredType != null && TypeUtils.isTypeElement(declaredType.asElement());
    }

    public static TypeElement ofTypeElement(Element element) {
        return TypeUtils.isTypeElement(element) ? (TypeElement)element : null;
    }

    public static TypeElement ofTypeElement(TypeMirror type) {
        DeclaredType declaredType = TypeUtils.ofDeclaredType(type);
        if (declaredType != null) {
            return TypeUtils.ofTypeElement(declaredType.asElement());
        }
        return null;
    }

    public static Set<DeclaredType> ofDeclaredTypes(Iterable<? extends Element> elements) {
        return elements == null ? Collections.emptySet() : (Set)StreamSupport.stream(elements.spliterator(), false).map(TypeUtils::ofTypeElement).filter(Objects::nonNull).map(Element::asType).map(TypeUtils::ofDeclaredType).filter(Objects::nonNull).collect(LinkedHashSet::new, Set::add, Set::addAll);
    }

    public static Set<TypeElement> ofTypeElements(Iterable<? extends TypeMirror> types) {
        return types == null ? Collections.emptySet() : (Set)StreamSupport.stream(types.spliterator(), false).map(TypeUtils::ofTypeElement).filter(Objects::nonNull).collect(LinkedHashSet::new, Set::add, Set::addAll);
    }

    public static List<DeclaredType> listDeclaredTypes(Iterable<? extends Element> elements) {
        return new ArrayList<DeclaredType>(TypeUtils.ofDeclaredTypes(elements));
    }

    public static List<TypeElement> listTypeElements(Iterable<? extends TypeMirror> types) {
        return new ArrayList<TypeElement>(TypeUtils.ofTypeElements(types));
    }

    public static URL getResource(ProcessingEnvironment processingEnv, Element type) {
        return TypeUtils.getResource(processingEnv, TypeUtils.ofDeclaredType(type));
    }

    public static URL getResource(ProcessingEnvironment processingEnv, TypeMirror type) {
        return type == null ? null : TypeUtils.getResource(processingEnv, type.toString());
    }

    public static URL getResource(ProcessingEnvironment processingEnv, CharSequence type) {
        String relativeName = TypeUtils.getResourceName(type);
        URL resource = null;
        try {
            if (relativeName != null) {
                FileObject fileObject = processingEnv.getFiler().getResource(StandardLocation.CLASS_OUTPUT, "", relativeName);
                resource = fileObject.toUri().toURL();
                resource.getContent();
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resource;
    }

    public static String getResourceName(CharSequence type) {
        return type == null ? null : type.toString().replace('.', '/').concat(".class");
    }

    public static String toString(TypeMirror type) {
        List<? extends TypeParameterElement> typeParameterElements;
        TypeElement element = TypeUtils.ofTypeElement(type);
        if (element != null && !(typeParameterElements = element.getTypeParameters()).isEmpty()) {
            List typeMirrors = type instanceof DeclaredType ? ((DeclaredType)type).getTypeArguments() : (List)MethodUtils.invokeMethod((Object)type, (String)"getTypeArguments", (Object[])new Object[0]);
            StringBuilder typeBuilder = new StringBuilder(element.toString());
            typeBuilder.append('<');
            for (int i = 0; i < typeMirrors.size(); ++i) {
                if (i > 0) {
                    typeBuilder.append(", ");
                }
                typeBuilder.append(((TypeMirror)typeMirrors.get(i)).toString());
            }
            typeBuilder.append('>');
            return typeBuilder.toString();
        }
        return type.toString();
    }
}

