/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.annotation.processing;

import com.google.gson.Gson;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.ElementFilter;
import org.apache.dubbo.metadata.annotation.processing.AbstractServiceAnnotationProcessor;
import org.apache.dubbo.metadata.annotation.processing.ClassPathMetadataStorage;
import org.apache.dubbo.metadata.annotation.processing.builder.ServiceDefinitionBuilder;
import org.apache.dubbo.metadata.definition.model.ServiceDefinition;

public class ServiceDefinitionMetadataAnnotationProcessor
extends AbstractServiceAnnotationProcessor {
    private List<ServiceDefinition> serviceDefinitions = new LinkedList<ServiceDefinition>();

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        ElementFilter.typesIn(roundEnv.getRootElements()).forEach(serviceType -> this.process(this.processingEnv, (TypeElement)serviceType, annotations));
        if (roundEnv.processingOver()) {
            ClassPathMetadataStorage writer = new ClassPathMetadataStorage(this.processingEnv);
            writer.write(() -> new Gson().toJson(this.serviceDefinitions), "META-INF/dubbo/service-definitions.json");
        }
        return false;
    }

    private void process(ProcessingEnvironment processingEnv, TypeElement serviceType, Set<? extends TypeElement> annotations) {
        this.serviceDefinitions.add(ServiceDefinitionBuilder.build(processingEnv, serviceType));
    }
}

