/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata.aot;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.apache.dubbo.aot.api.MemberCategory;
import org.apache.dubbo.aot.api.ReflectionTypeDescriberRegistrar;
import org.apache.dubbo.aot.api.TypeDescriber;
import org.apache.dubbo.metadata.MetadataInfo;
import org.apache.dubbo.metadata.MetadataInfoV2;
import org.apache.dubbo.metadata.MetadataService;
import org.apache.dubbo.metadata.MetadataServiceV2;

public class MetadataReflectionTypeDescriberRegistrar
implements ReflectionTypeDescriberRegistrar {
    public List<TypeDescriber> getTypeDescribers() {
        ArrayList<TypeDescriber> typeDescribers = new ArrayList<TypeDescriber>();
        typeDescribers.add(this.buildTypeDescriberWithPublicMethod(MetadataService.class));
        typeDescribers.add(this.buildTypeDescriberWithPublicMethod(MetadataServiceV2.class));
        typeDescribers.add(this.buildTypeDescriberWithDeclaredConstructors(MetadataInfo.class));
        typeDescribers.add(this.buildTypeDescriberWithDeclaredConstructors(MetadataInfoV2.class));
        return typeDescribers;
    }

    private TypeDescriber buildTypeDescriberWithPublicMethod(Class<?> cl) {
        HashSet<MemberCategory> memberCategories = new HashSet<MemberCategory>();
        memberCategories.add(MemberCategory.INVOKE_PUBLIC_METHODS);
        return new TypeDescriber(cl.getName(), null, new HashSet(), new HashSet(), new HashSet(), memberCategories);
    }

    private TypeDescriber buildTypeDescriberWithDeclaredConstructors(Class<?> cl) {
        HashSet<MemberCategory> memberCategories = new HashSet<MemberCategory>();
        memberCategories.add(MemberCategory.INVOKE_DECLARED_CONSTRUCTORS);
        return new TypeDescriber(cl.getName(), null, new HashSet(), new HashSet(), new HashSet(), memberCategories);
    }
}

