/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.metadata;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.metadata.MetadataChangeListener;
import org.apache.dubbo.metadata.MetadataInfo;

public interface MetadataService {
    public static final String DEFAULT_EXTENSION = "default";
    public static final String ALL_SERVICE_NAMES = "*";
    public static final String ALL_SERVICE_INTERFACES = "*";
    public static final String SERVICE_INTERFACE_NAME = MetadataService.class.getName();
    public static final String VERSION = "1.0.0";

    public String serviceName();

    default public String version() {
        return VERSION;
    }

    default public SortedSet<String> getSubscribedURLs() {
        throw new UnsupportedOperationException("This operation is not supported for consumer.");
    }

    default public SortedSet<String> getExportedURLs() {
        return this.getExportedURLs("*");
    }

    default public SortedSet<String> getExportedURLs(String serviceInterface) {
        return this.getExportedURLs(serviceInterface, null);
    }

    default public SortedSet<String> getExportedURLs(String serviceInterface, String group) {
        return this.getExportedURLs(serviceInterface, group, null);
    }

    default public SortedSet<String> getExportedURLs(String serviceInterface, String group, String version) {
        return this.getExportedURLs(serviceInterface, group, version, null);
    }

    public SortedSet<String> getExportedURLs(String var1, String var2, String var3, String var4);

    default public String getServiceDefinition(String interfaceName, String version, String group) {
        return this.getServiceDefinition(URL.buildKey((String)interfaceName, (String)group, (String)version));
    }

    public String getServiceDefinition(String var1);

    public MetadataInfo getMetadataInfo(String var1);

    public Map<String, MetadataInfo> getMetadataInfos();

    public static boolean isMetadataServiceURL(URL url) {
        String serviceInterface = url.getServiceInterface();
        return SERVICE_INTERFACE_NAME.equals(serviceInterface);
    }

    public static List<URL> toURLs(Iterable<String> urls) {
        return StreamSupport.stream(urls.spliterator(), false).map(URL::valueOf).collect(Collectors.toList());
    }

    public static SortedSet<String> toSortedStrings(Iterable<URL> iterable) {
        return MetadataService.toSortedStrings(StreamSupport.stream(iterable.spliterator(), false));
    }

    public static SortedSet<String> toSortedStrings(Stream<URL> stream) {
        return Collections.unmodifiableSortedSet(stream.map(URL::toFullString).collect(TreeSet::new, Set::add, Set::addAll));
    }

    default public void exportServiceDiscoveryMetadata(String metadata) {
        throw new UnsupportedOperationException("This operation is not supported for consumer.");
    }

    default public Map<String, MetadataChangeListener> getMetadataChangeListenerMap() {
        throw new UnsupportedOperationException("This operation is not supported for consumer.");
    }

    default public String getAndListenServiceDiscoveryMetadata(String consumerId, MetadataChangeListener listener) {
        throw new UnsupportedOperationException("This operation is not supported for consumer.");
    }
}

