/*
 * Decompiled with CFR 0.152.
 */
package org.apache.dubbo.config;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.dubbo.common.utils.StringUtils;
import org.apache.dubbo.config.AbstractMethodConfig;
import org.apache.dubbo.config.ArgumentConfig;
import org.apache.dubbo.config.annotation.Method;
import org.apache.dubbo.config.support.Parameter;

public class MethodConfig
extends AbstractMethodConfig {
    private static final long serialVersionUID = 884908855422675941L;
    private String name;
    private Integer stat;
    private Boolean retry;
    private Boolean reliable;
    private Integer executes;
    private Boolean deprecated;
    private Boolean sticky;
    private Boolean isReturn;
    private Object oninvoke;
    private String oninvokeMethod;
    private Object onreturn;
    private String onreturnMethod;
    private Object onthrow;
    private String onthrowMethod;
    private List<ArgumentConfig> arguments;
    private String service;
    private String serviceId;

    @Parameter(excluded=true)
    public String getName() {
        return this.name;
    }

    public MethodConfig() {
    }

    public MethodConfig(Method method) {
        this.appendAnnotation(Method.class, method);
        this.setReturn(method.isReturn());
        if (!"".equals(method.oninvoke())) {
            this.setOninvoke(method.oninvoke());
        }
        if (!"".equals(method.onreturn())) {
            this.setOnreturn(method.onreturn());
        }
        if (!"".equals(method.onthrow())) {
            this.setOnthrow(method.onthrow());
        }
        if (method.arguments() != null && method.arguments().length != 0) {
            ArrayList<ArgumentConfig> argumentConfigs = new ArrayList<ArgumentConfig>(method.arguments().length);
            this.setArguments(argumentConfigs);
            for (int i = 0; i < method.arguments().length; ++i) {
                ArgumentConfig argumentConfig = new ArgumentConfig(method.arguments()[i]);
                argumentConfigs.add(argumentConfig);
            }
        }
    }

    public static List<MethodConfig> constructMethodConfig(Method[] methods) {
        if (methods != null && methods.length != 0) {
            ArrayList<MethodConfig> methodConfigs = new ArrayList<MethodConfig>(methods.length);
            for (int i = 0; i < methods.length; ++i) {
                MethodConfig methodConfig = new MethodConfig(methods[i]);
                methodConfigs.add(methodConfig);
            }
            return methodConfigs;
        }
        return Collections.emptyList();
    }

    public void setName(String name) {
        MethodConfig.checkMethodName("name", name);
        this.name = name;
        if (StringUtils.isEmpty((String)this.id)) {
            this.id = name;
        }
    }

    public Integer getStat() {
        return this.stat;
    }

    @Deprecated
    public void setStat(Integer stat) {
        this.stat = stat;
    }

    @Deprecated
    public Boolean isRetry() {
        return this.retry;
    }

    @Deprecated
    public void setRetry(Boolean retry) {
        this.retry = retry;
    }

    @Deprecated
    public Boolean isReliable() {
        return this.reliable;
    }

    @Deprecated
    public void setReliable(Boolean reliable) {
        this.reliable = reliable;
    }

    public Integer getExecutes() {
        return this.executes;
    }

    public void setExecutes(Integer executes) {
        this.executes = executes;
    }

    public Boolean getDeprecated() {
        return this.deprecated;
    }

    public void setDeprecated(Boolean deprecated) {
        this.deprecated = deprecated;
    }

    public List<ArgumentConfig> getArguments() {
        return this.arguments;
    }

    public void setArguments(List<? extends ArgumentConfig> arguments) {
        this.arguments = arguments;
    }

    public Boolean getSticky() {
        return this.sticky;
    }

    public void setSticky(Boolean sticky) {
        this.sticky = sticky;
    }

    @Parameter(key="onreturn.instance", excluded=true, attribute=true)
    public Object getOnreturn() {
        return this.onreturn;
    }

    public void setOnreturn(Object onreturn) {
        this.onreturn = onreturn;
    }

    @Parameter(key="onreturn.method", excluded=true, attribute=true)
    public String getOnreturnMethod() {
        return this.onreturnMethod;
    }

    public void setOnreturnMethod(String onreturnMethod) {
        this.onreturnMethod = onreturnMethod;
    }

    @Parameter(key="onthrow.instance", excluded=true, attribute=true)
    public Object getOnthrow() {
        return this.onthrow;
    }

    public void setOnthrow(Object onthrow) {
        this.onthrow = onthrow;
    }

    @Parameter(key="onthrow.method", excluded=true, attribute=true)
    public String getOnthrowMethod() {
        return this.onthrowMethod;
    }

    public void setOnthrowMethod(String onthrowMethod) {
        this.onthrowMethod = onthrowMethod;
    }

    @Parameter(key="oninvoke.instance", excluded=true, attribute=true)
    public Object getOninvoke() {
        return this.oninvoke;
    }

    public void setOninvoke(Object oninvoke) {
        this.oninvoke = oninvoke;
    }

    @Parameter(key="oninvoke.method", excluded=true, attribute=true)
    public String getOninvokeMethod() {
        return this.oninvokeMethod;
    }

    public void setOninvokeMethod(String oninvokeMethod) {
        this.oninvokeMethod = oninvokeMethod;
    }

    public Boolean isReturn() {
        return this.isReturn;
    }

    public void setReturn(Boolean isReturn) {
        this.isReturn = isReturn;
    }

    @Parameter(excluded=true)
    public String getService() {
        return this.service;
    }

    public void setService(String service) {
        this.service = service;
    }

    @Parameter(excluded=true)
    public String getServiceId() {
        return this.serviceId;
    }

    public void setServiceId(String serviceId) {
        this.serviceId = serviceId;
    }

    @Override
    @Parameter(excluded=true)
    public String getPrefix() {
        return "dubbo." + this.service + (StringUtils.isEmpty((String)this.serviceId) ? "" : "." + this.serviceId) + "." + this.getName();
    }
}

