/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.view;

import com.google.common.annotations.VisibleForTesting;
import com.google.inject.Inject;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.calcite.schema.TableMacro;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.sql.calcite.planner.PlannerFactory;
import org.apache.druid.sql.calcite.view.DruidViewMacro;
import org.apache.druid.sql.calcite.view.DruidViewMacroFactory;
import org.apache.druid.sql.calcite.view.ViewManager;

public class InProcessViewManager
implements ViewManager {
    private final ConcurrentMap<String, DruidViewMacro> views = new ConcurrentHashMap<String, DruidViewMacro>();
    private final DruidViewMacroFactory druidViewMacroFactory;

    @Inject
    @VisibleForTesting
    public InProcessViewManager(DruidViewMacroFactory druidViewMacroFactory) {
        this.druidViewMacroFactory = druidViewMacroFactory;
    }

    @Override
    public void createView(PlannerFactory plannerFactory, String viewName, String viewSql) {
        TableMacro oldValue = this.views.putIfAbsent(viewName, this.druidViewMacroFactory.create(plannerFactory, viewSql));
        if (oldValue != null) {
            throw new ISE("View[%s] already exists", new Object[]{viewName});
        }
    }

    @Override
    public void alterView(PlannerFactory plannerFactory, String viewName, String viewSql) {
        TableMacro oldValue = this.views.replace(viewName, this.druidViewMacroFactory.create(plannerFactory, viewSql));
        if (oldValue != null) {
            throw new ISE("View[%s] does not exist", new Object[]{viewName});
        }
    }

    @Override
    public void dropView(String viewName) {
        TableMacro oldValue = (TableMacro)this.views.remove(viewName);
        if (oldValue == null) {
            throw new ISE("View[%s] does not exist", new Object[]{viewName});
        }
    }

    @Override
    public Map<String, DruidViewMacro> getViews() {
        return this.views;
    }
}

