/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rule;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptRuleOperandChildren;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.rules.SubstitutionRule;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexShuttle;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.druid.sql.calcite.planner.Calcites;

public class FilterDecomposeCoalesceRule
extends RelOptRule
implements SubstitutionRule {
    public FilterDecomposeCoalesceRule() {
        super(FilterDecomposeCoalesceRule.operand(Filter.class, (RelOptRuleOperandChildren)FilterDecomposeCoalesceRule.any()));
    }

    public void onMatch(RelOptRuleCall call) {
        Filter oldFilter = (Filter)call.rel(0);
        DecomposeCoalesceShuttle shuttle = new DecomposeCoalesceShuttle(oldFilter.getCluster().getRexBuilder());
        RexNode newCondition = (RexNode)oldFilter.getCondition().accept((RexVisitor)shuttle);
        if (newCondition != oldFilter.getCondition()) {
            call.transformTo(call.builder().push(oldFilter.getInput()).filter(new RexNode[]{newCondition}).build());
            call.getPlanner().prune((RelNode)oldFilter);
        }
    }

    private static boolean isSimpleCoalesce(RexNode rexNode) {
        if (rexNode.getKind() == SqlKind.COALESCE) {
            List operands = ((RexCall)rexNode).getOperands();
            return operands.size() == 2 && FilterDecomposeCoalesceRule.isSimpleCoalesceArg((RexNode)operands.get(0)) && FilterDecomposeCoalesceRule.isSimpleCoalesceArg((RexNode)operands.get(1));
        }
        return false;
    }

    private static boolean isSimpleCoalesceArg(RexNode arg) {
        RexNode argNoCast = RexUtil.removeCast((RexNode)arg);
        return Calcites.isLiteral(argNoCast, false, true) || argNoCast.isA(SqlKind.INPUT_REF);
    }

    private static RexCall decomposePredicateOnCoalesce(RexCall call, RexBuilder rexBuilder) {
        if (call.getType().getSqlTypeName() != SqlTypeName.BOOLEAN) {
            return call;
        }
        switch (call.getKind()) {
            case AND: 
            case CASE: 
            case COALESCE: 
            case OR: {
                return call;
            }
        }
        int coalesceOrdinal = -1;
        List operands = call.getOperands();
        for (int i = 0; i < operands.size(); ++i) {
            if (!FilterDecomposeCoalesceRule.isSimpleCoalesce((RexNode)operands.get(i))) continue;
            coalesceOrdinal = i;
            break;
        }
        if (coalesceOrdinal < 0) {
            return call;
        }
        RexCall coalesceCall = (RexCall)operands.get(coalesceOrdinal);
        RexNode x = (RexNode)coalesceCall.getOperands().get(0);
        RexNode y = (RexNode)coalesceCall.getOperands().get(1);
        ArrayList<RexNode> fxArgs = new ArrayList<RexNode>(call.getOperands());
        fxArgs.set(coalesceOrdinal, x);
        ArrayList<RexNode> fyArgs = new ArrayList<RexNode>(call.getOperands());
        fyArgs.set(coalesceOrdinal, y);
        return (RexCall)RexUtil.composeDisjunction((RexBuilder)rexBuilder, (Iterable)ImmutableList.of((Object)RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)ImmutableList.of((Object)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, new RexNode[]{x}), (Object)call.clone(call.getType(), fxArgs))), (Object)RexUtil.composeConjunction((RexBuilder)rexBuilder, (Iterable)ImmutableList.of((Object)rexBuilder.makeCall((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{x}), (Object)call.clone(call.getType(), fyArgs)))));
    }

    private static class DecomposeCoalesceShuttle
    extends RexShuttle {
        private final RexBuilder rexBuilder;

        public DecomposeCoalesceShuttle(RexBuilder rexBuilder) {
            this.rexBuilder = rexBuilder;
        }

        public RexNode visitCall(RexCall call) {
            RexCall old;
            RexCall retVal = call;
            do {
                old = retVal = (RexCall)super.visitCall(retVal);
            } while ((retVal = FilterDecomposeCoalesceRule.decomposePredicateOnCoalesce(retVal, this.rexBuilder)) != old);
            return retVal;
        }
    }
}

