/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.sql.SqlDynamicParam;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlShuttle;
import org.apache.calcite.util.TimestampString;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.sql.calcite.planner.PlannerContext;

public class SqlParameterizerShuttle
extends SqlShuttle {
    private final PlannerContext plannerContext;

    public SqlParameterizerShuttle(PlannerContext plannerContext) {
        this.plannerContext = plannerContext;
    }

    public SqlNode visit(SqlDynamicParam param) {
        if (this.plannerContext.getParameters().size() <= param.getIndex()) {
            throw SqlParameterizerShuttle.unbound(param);
        }
        TypedValue paramBinding = this.plannerContext.getParameters().get(param.getIndex());
        if (paramBinding == null) {
            throw SqlParameterizerShuttle.unbound(param);
        }
        if (paramBinding.value == null) {
            return SqlLiteral.createNull((SqlParserPos)param.getParserPosition());
        }
        SqlTypeName typeName = SqlTypeName.getNameForJdbcType((int)paramBinding.type.typeId);
        if (SqlTypeName.APPROX_TYPES.contains(typeName)) {
            return SqlLiteral.createApproxNumeric((String)paramBinding.value.toString(), (SqlParserPos)param.getParserPosition());
        }
        if (SqlTypeName.TIMESTAMP.equals((Object)typeName) && paramBinding.value instanceof Long) {
            return SqlLiteral.createTimestamp((TimestampString)TimestampString.fromMillisSinceEpoch((long)((Long)paramBinding.value)), (int)3, (SqlParserPos)param.getParserPosition());
        }
        if (typeName == SqlTypeName.ARRAY) {
            return this.createArrayLiteral(paramBinding.value, param.getIndex());
        }
        try {
            return typeName.createLiteral(paramBinding.value, param.getParserPosition());
        }
        catch (ClassCastException ignored) {
            return param;
        }
    }

    private static DruidException unbound(SqlDynamicParam param) {
        return InvalidSqlInput.exception((String)"No value bound for parameter (position [%s])", (Object[])new Object[]{param.getIndex() + 1});
    }

    private SqlNode createArrayLiteral(Object value, int posn) {
        List<Object> list = value instanceof List ? (List<Object>)value : Arrays.asList((Object[])value);
        ArrayList<SqlLiteral> args = new ArrayList<SqlLiteral>(list.size());
        int listSize = list.size();
        for (int i = 0; i < listSize; ++i) {
            SqlLiteral node;
            Object element = list.get(i);
            if (element == null) {
                node = SqlLiteral.createNull((SqlParserPos)SqlParserPos.ZERO);
            } else if (element instanceof String) {
                node = SqlLiteral.createCharString((String)((String)element), (SqlParserPos)SqlParserPos.ZERO);
            } else if (element instanceof Integer || element instanceof Long) {
                node = SqlLiteral.createExactNumeric((String)element.toString(), (SqlParserPos)SqlParserPos.ZERO);
            } else if (element instanceof Double || element instanceof Float) {
                node = SqlLiteral.createApproxNumeric((String)element.toString(), (SqlParserPos)SqlParserPos.ZERO);
            } else if (element instanceof Boolean) {
                node = SqlLiteral.createBoolean((boolean)((Boolean)element), (SqlParserPos)SqlParserPos.ZERO);
            } else {
                throw InvalidSqlInput.exception((String)"parameter [%d] is an array, with an illegal value of type [%s] at index [%d]", (Object[])new Object[]{posn + 1, value.getClass(), i});
            }
            args.add(node);
        }
        return SqlStdOperatorTable.ARRAY_VALUE_CONSTRUCTOR.createCall(SqlParserPos.ZERO, args);
    }
}

