/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.parser;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlInsert;
import org.apache.calcite.sql.SqlLiteral;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.util.ImmutableNullableList;
import org.apache.druid.sql.calcite.parser.DruidSqlIngest;
import org.apache.druid.sql.calcite.parser.SqlGranularityLiteral;
import org.apache.druid.sql.calcite.planner.DruidSqlIngestOperator;

public class DruidSqlReplace
extends DruidSqlIngest {
    public static final String SQL_REPLACE_TIME_CHUNKS = "sqlReplaceTimeChunks";
    public static final SqlOperator OPERATOR = DruidSqlIngestOperator.REPLACE_OPERATOR;
    private final SqlNode replaceTimeQuery;

    public static DruidSqlReplace create(@Nonnull SqlInsert insertNode, @Nullable SqlGranularityLiteral partitionedBy, @Nullable SqlNodeList clusteredBy, @Nullable SqlIdentifier exportFileFormat, @Nullable SqlNode replaceTimeQuery) {
        return new DruidSqlReplace(insertNode.getParserPosition(), (SqlNodeList)insertNode.getOperandList().get(0), insertNode.getTargetTable(), insertNode.getSource(), insertNode.getTargetColumnList(), partitionedBy, clusteredBy, exportFileFormat, replaceTimeQuery);
    }

    public DruidSqlReplace(SqlParserPos pos, SqlNodeList keywords, SqlNode targetTable, SqlNode source, SqlNodeList columnList, @Nullable SqlGranularityLiteral partitionedBy, @Nullable SqlNodeList clusteredBy, @Nullable SqlIdentifier exportFileFormat, @Nullable SqlNode replaceTimeQuery) {
        super(pos, keywords, targetTable, source, columnList, partitionedBy, clusteredBy, exportFileFormat);
        this.replaceTimeQuery = replaceTimeQuery;
    }

    public SqlNode getReplaceTimeQuery() {
        return this.replaceTimeQuery;
    }

    @Nonnull
    public SqlOperator getOperator() {
        return OPERATOR;
    }

    @Override
    public List<SqlNode> getOperandList() {
        return ImmutableNullableList.builder().addAll(super.getOperandList()).add((Object)this.replaceTimeQuery).build();
    }

    public void unparse(SqlWriter writer, int leftPrec, int rightPrec) {
        writer.startList(SqlWriter.FrameTypeEnum.SELECT);
        writer.sep("REPLACE INTO");
        int opLeft = this.getOperator().getLeftPrec();
        int opRight = this.getOperator().getRightPrec();
        this.getTargetTable().unparse(writer, opLeft, opRight);
        if (this.getTargetColumnList() != null) {
            this.getTargetColumnList().unparse(writer, opLeft, opRight);
        }
        writer.newlineAndIndent();
        if (this.getExportFileFormat() != null) {
            writer.keyword("AS");
            writer.print(this.getExportFileFormat().toString());
            writer.newlineAndIndent();
        }
        writer.keyword("OVERWRITE");
        if (this.replaceTimeQuery instanceof SqlLiteral) {
            writer.keyword("ALL");
        } else {
            this.replaceTimeQuery.unparse(writer, leftPrec, rightPrec);
        }
        writer.newlineAndIndent();
        this.getSource().unparse(writer, 0, 0);
        writer.newlineAndIndent();
        if (this.getPartitionedBy() != null) {
            writer.keyword("PARTITIONED BY");
            this.getPartitionedBy().unparse(writer, 0, 0);
        }
        if (this.getClusteredBy() != null) {
            writer.keyword("CLUSTERED BY");
            SqlWriter.Frame frame = writer.startList("", "");
            for (SqlNode clusterByOpts : this.getClusteredBy().getList()) {
                clusterByOpts.unparse(writer, leftPrec, rightPrec);
            }
            writer.endList(frame);
        }
    }
}

