/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.filtration;

import com.google.common.base.Function;
import com.google.common.collect.BoundType;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import java.util.ArrayList;
import java.util.List;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.java.util.common.Pair;
import org.apache.druid.query.filter.AndDimFilter;
import org.apache.druid.query.filter.BoundDimFilter;
import org.apache.druid.query.filter.DimFilter;
import org.apache.druid.query.filter.NotDimFilter;
import org.apache.druid.query.filter.OrDimFilter;
import org.apache.druid.query.filter.RangeFilter;
import org.apache.druid.query.ordering.StringComparators;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.sql.calcite.filtration.BoundRefKey;
import org.apache.druid.sql.calcite.filtration.BoundValue;
import org.apache.druid.sql.calcite.filtration.Bounds;
import org.apache.druid.sql.calcite.filtration.Filtration;
import org.apache.druid.sql.calcite.filtration.RangeRefKey;
import org.apache.druid.sql.calcite.filtration.RangeSets;
import org.apache.druid.sql.calcite.filtration.RangeValue;
import org.apache.druid.sql.calcite.filtration.Ranges;
import org.joda.time.Interval;

public class MoveTimeFiltersToIntervals
implements Function<Filtration, Filtration> {
    private static final MoveTimeFiltersToIntervals INSTANCE = new MoveTimeFiltersToIntervals();
    private static final BoundRefKey TIME_BOUND_REF_KEY = new BoundRefKey("__time", null, StringComparators.NUMERIC);
    private static final RangeRefKey TIME_RANGE_REF_KEY = new RangeRefKey("__time", ColumnType.LONG);

    private MoveTimeFiltersToIntervals() {
    }

    public static MoveTimeFiltersToIntervals instance() {
        return INSTANCE;
    }

    public Filtration apply(Filtration filtration) {
        if (filtration.getDimFilter() == null) {
            return filtration;
        }
        RangeSet<Long> rangeSet = RangeSets.fromIntervals(filtration.getIntervals());
        rangeSet.removeAll(RangeSets.fromIntervals((Iterable<Interval>)ImmutableList.of((Object)Filtration.eternity())).complement());
        Pair<DimFilter, RangeSet<Long>> pair = MoveTimeFiltersToIntervals.extractConvertibleTimeBounds(filtration.getDimFilter());
        if (pair.rhs != null) {
            rangeSet.removeAll(((RangeSet)pair.rhs).complement());
        }
        return Filtration.create((DimFilter)pair.lhs, RangeSets.toIntervals(rangeSet));
    }

    private static Pair<DimFilter, RangeSet<Long>> extractConvertibleTimeBounds(DimFilter filter) {
        if (filter instanceof AndDimFilter) {
            List children = ((AndDimFilter)filter).getFields();
            ArrayList<DimFilter> newChildren = new ArrayList<DimFilter>();
            ArrayList rangeSets = new ArrayList();
            for (DimFilter child : children) {
                Pair<DimFilter, RangeSet<Long>> pair = MoveTimeFiltersToIntervals.extractConvertibleTimeBounds(child);
                if (pair.lhs != null) {
                    newChildren.add((DimFilter)pair.lhs);
                }
                if (pair.rhs == null) continue;
                rangeSets.add((RangeSet)pair.rhs);
            }
            Object newFilter = newChildren.size() == 0 ? null : (newChildren.size() == 1 ? (DimFilter)newChildren.get(0) : new AndDimFilter(newChildren));
            return Pair.of((Object)newFilter, rangeSets.isEmpty() ? null : RangeSets.intersectRangeSets(rangeSets));
        }
        if (filter instanceof OrDimFilter) {
            List children = ((OrDimFilter)filter).getFields();
            ArrayList rangeSets = new ArrayList();
            boolean allCompletelyConverted = true;
            boolean allHadIntervals = true;
            for (DimFilter child : children) {
                Pair<DimFilter, RangeSet<Long>> pair = MoveTimeFiltersToIntervals.extractConvertibleTimeBounds(child);
                if (pair.lhs != null) {
                    allCompletelyConverted = false;
                }
                if (pair.rhs != null) {
                    rangeSets.add((RangeSet)pair.rhs);
                    continue;
                }
                allHadIntervals = false;
            }
            if (allCompletelyConverted) {
                return Pair.of(null, RangeSets.unionRangeSets(rangeSets));
            }
            return Pair.of((Object)filter, allHadIntervals ? RangeSets.unionRangeSets(rangeSets) : null);
        }
        if (filter instanceof NotDimFilter) {
            DimFilter child = ((NotDimFilter)filter).getField();
            Pair<DimFilter, RangeSet<Long>> pair = MoveTimeFiltersToIntervals.extractConvertibleTimeBounds(child);
            if (pair.rhs != null && pair.lhs == null) {
                return Pair.of(null, (Object)((RangeSet)pair.rhs).complement());
            }
            return Pair.of((Object)filter, null);
        }
        if (filter instanceof BoundDimFilter) {
            BoundDimFilter bound = (BoundDimFilter)filter;
            if (BoundRefKey.from(bound).equals(TIME_BOUND_REF_KEY)) {
                return Pair.of(null, RangeSets.of(MoveTimeFiltersToIntervals.toLongRange(Bounds.toRange(bound))));
            }
            return Pair.of((Object)filter, null);
        }
        if (filter instanceof RangeFilter) {
            RangeFilter bound = (RangeFilter)filter;
            if (RangeRefKey.from(bound).equals(TIME_RANGE_REF_KEY)) {
                return Pair.of(null, RangeSets.of(MoveTimeFiltersToIntervals.toLongRangeFromRange(Ranges.toRange(bound))));
            }
            return Pair.of((Object)filter, null);
        }
        return Pair.of((Object)filter, null);
    }

    private static Range<Long> toLongRange(Range<BoundValue> range) {
        if (!range.hasUpperBound() && !range.hasLowerBound()) {
            return Range.all();
        }
        if (range.hasUpperBound() && !range.hasLowerBound()) {
            return Range.upTo((Comparable)Long.valueOf(Long.parseLong(((BoundValue)range.upperEndpoint()).getValue())), (BoundType)range.upperBoundType());
        }
        if (!range.hasUpperBound() && range.hasLowerBound()) {
            return Range.downTo((Comparable)Long.valueOf(Long.parseLong(((BoundValue)range.lowerEndpoint()).getValue())), (BoundType)range.lowerBoundType());
        }
        return Range.range((Comparable)Long.valueOf(Long.parseLong(((BoundValue)range.lowerEndpoint()).getValue())), (BoundType)range.lowerBoundType(), (Comparable)Long.valueOf(Long.parseLong(((BoundValue)range.upperEndpoint()).getValue())), (BoundType)range.upperBoundType());
    }

    private static Range<Long> toLongRangeFromRange(Range<RangeValue> range) {
        if (!range.hasUpperBound() && !range.hasLowerBound()) {
            return Range.all();
        }
        if (range.hasUpperBound() && !range.hasLowerBound()) {
            return Range.upTo((Comparable)Long.valueOf(Numbers.parseLong((Object)((RangeValue)range.upperEndpoint()).getValue())), (BoundType)range.upperBoundType());
        }
        if (!range.hasUpperBound() && range.hasLowerBound()) {
            return Range.downTo((Comparable)Long.valueOf(Numbers.parseLong((Object)((RangeValue)range.lowerEndpoint()).getValue())), (BoundType)range.lowerBoundType());
        }
        return Range.range((Comparable)Long.valueOf(Numbers.parseLong((Object)((RangeValue)range.lowerEndpoint()).getValue())), (BoundType)range.lowerBoundType(), (Comparable)Long.valueOf(Numbers.parseLong((Object)((RangeValue)range.upperEndpoint()).getValue())), (BoundType)range.upperBoundType());
    }
}

