/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.expression;

import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.io.BaseEncoding;
import com.google.common.primitives.Chars;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;
import org.apache.druid.math.expr.ExprEval;
import org.apache.druid.math.expr.ExprType;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.segment.VirtualColumn;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.virtual.ExpressionVirtualColumn;
import org.apache.druid.sql.calcite.expression.DruidLiteral;
import org.apache.druid.sql.calcite.expression.SimpleExtraction;
import org.apache.druid.sql.calcite.planner.ExpressionParser;

public class DruidExpression {
    private static final char[] SAFE_CHARS = " ,._-;:(){}[]<>!@#$%^&*`~?/".toCharArray();
    private static final VirtualColumnCreator DEFAULT_VIRTUAL_COLUMN_BUILDER = new ExpressionVirtualColumnCreator();
    private final NodeType nodeType;
    @Nullable
    private final ColumnType druidType;
    private final List<DruidExpression> arguments;
    @Nullable
    private final SimpleExtraction simpleExtraction;
    private final ExpressionGenerator expressionGenerator;
    private final VirtualColumnCreator virtualColumnCreator;
    private final Supplier<String> expression;

    private static String escape(String s) {
        StringBuilder escaped = new StringBuilder();
        for (int i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (Character.isLetterOrDigit(c) || Arrays.binarySearch(SAFE_CHARS, c) >= 0) {
                escaped.append(c);
                continue;
            }
            escaped.append("\\u").append(BaseEncoding.base16().encode(Chars.toByteArray((char)c)));
        }
        return escaped.toString();
    }

    public static String longLiteral(long n) {
        return String.valueOf(n);
    }

    public static String doubleLiteral(double n) {
        return String.valueOf(n);
    }

    public static String stringLiteral(String s) {
        return s == null ? DruidExpression.nullLiteral() : "'" + DruidExpression.escape(s) + "'";
    }

    public static String nullLiteral() {
        return "null";
    }

    public static ExpressionGenerator functionCall(String functionName) {
        Preconditions.checkNotNull((Object)functionName, (Object)"functionName");
        return args -> {
            Preconditions.checkNotNull((Object)args, (Object)"args");
            StringBuilder builder = new StringBuilder(functionName);
            builder.append("(");
            for (int i = 0; i < args.size(); ++i) {
                DruidExpression arg = (DruidExpression)Preconditions.checkNotNull((Object)((DruidExpression)args.get(i)), (String)"arg #%s", (int)i);
                builder.append(arg.getExpression());
                if (i >= args.size() - 1) continue;
                builder.append(",");
            }
            builder.append(")");
            return builder.toString();
        };
    }

    @Deprecated
    public static String functionCall(String functionName, List<DruidExpression> args) {
        return DruidExpression.functionCall(functionName).compile(args);
    }

    @Deprecated
    public static String functionCall(String functionName, DruidExpression ... args) {
        return DruidExpression.functionCall(functionName).compile(Arrays.asList(args));
    }

    public static DruidExpression ofLiteral(@Nullable ColumnType columnType, String literal) {
        return new DruidExpression(NodeType.LITERAL, columnType, null, new LiteralExpressionGenerator(literal), Collections.emptyList(), null);
    }

    public static DruidExpression ofLiteral(DruidLiteral literal) {
        if (literal.type() != null && literal.type().is((TypeDescriptor)ExprType.STRING)) {
            return DruidExpression.ofStringLiteral((String)literal.value());
        }
        ColumnType evalColumnType = literal.type() != null ? ExpressionType.toColumnType((ExpressionType)literal.type()) : null;
        return DruidExpression.ofLiteral(evalColumnType, ExprEval.ofType((ExpressionType)literal.type(), (Object)literal.value()).toExpr().stringify());
    }

    public static DruidExpression ofStringLiteral(String s) {
        return DruidExpression.ofLiteral(ColumnType.STRING, DruidExpression.stringLiteral(s));
    }

    public static DruidExpression ofColumn(@Nullable ColumnType columnType, String column, SimpleExtraction simpleExtraction) {
        return new DruidExpression(NodeType.IDENTIFIER, columnType, simpleExtraction, new IdentifierExpressionGenerator(column), Collections.emptyList(), null);
    }

    public static DruidExpression ofColumn(ColumnType columnType, String column) {
        return DruidExpression.ofColumn(columnType, column, SimpleExtraction.of(column, null));
    }

    public static DruidExpression ofFunctionCall(ColumnType columnType, String functionName, List<DruidExpression> args) {
        return new DruidExpression(NodeType.EXPRESSION, columnType, null, DruidExpression.functionCall(functionName), args, null);
    }

    public static DruidExpression ofVirtualColumn(ColumnType type, ExpressionGenerator expressionGenerator, List<DruidExpression> arguments, VirtualColumnCreator virtualColumnCreator) {
        return new DruidExpression(NodeType.SPECIALIZED, type, null, expressionGenerator, arguments, virtualColumnCreator);
    }

    public static DruidExpression ofExpression(@Nullable ColumnType columnType, ExpressionGenerator expressionGenerator, List<DruidExpression> arguments) {
        return new DruidExpression(NodeType.EXPRESSION, columnType, null, expressionGenerator, arguments, null);
    }

    public static DruidExpression ofExpression(@Nullable ColumnType columnType, SimpleExtraction simpleExtraction, ExpressionGenerator expressionGenerator, List<DruidExpression> arguments) {
        return new DruidExpression(NodeType.EXPRESSION, columnType, simpleExtraction, expressionGenerator, arguments, null);
    }

    @Deprecated
    public static DruidExpression of(SimpleExtraction simpleExtraction, String expression) {
        return new DruidExpression(NodeType.EXPRESSION, null, simpleExtraction, new LiteralExpressionGenerator(expression), Collections.emptyList(), null);
    }

    @Deprecated
    public static DruidExpression fromColumn(String column) {
        return new DruidExpression(NodeType.EXPRESSION, null, SimpleExtraction.of(column, null), new IdentifierExpressionGenerator(column), Collections.emptyList(), null);
    }

    @Deprecated
    public static DruidExpression fromExpression(String expression) {
        return new DruidExpression(NodeType.EXPRESSION, null, null, new LiteralExpressionGenerator(expression), Collections.emptyList(), null);
    }

    @Deprecated
    public static DruidExpression fromFunctionCall(String functionName, List<DruidExpression> args) {
        return new DruidExpression(NodeType.EXPRESSION, null, null, new LiteralExpressionGenerator(DruidExpression.functionCall(functionName, args)), Collections.emptyList(), null);
    }

    private DruidExpression(NodeType nodeType, @Nullable ColumnType druidType, @Nullable SimpleExtraction simpleExtraction, ExpressionGenerator expressionGenerator, List<DruidExpression> arguments, @Nullable VirtualColumnCreator virtualColumnCreator) {
        this.nodeType = nodeType;
        this.druidType = druidType;
        this.simpleExtraction = simpleExtraction;
        this.expressionGenerator = (ExpressionGenerator)Preconditions.checkNotNull((Object)expressionGenerator);
        this.arguments = arguments;
        this.virtualColumnCreator = virtualColumnCreator != null ? virtualColumnCreator : DEFAULT_VIRTUAL_COLUMN_BUILDER;
        this.expression = Suppliers.memoize(() -> this.expressionGenerator.compile(this.arguments));
    }

    public String getExpression() {
        return (String)this.expression.get();
    }

    public boolean isDirectColumnAccess() {
        return this.simpleExtraction != null && this.simpleExtraction.getExtractionFn() == null;
    }

    public String getDirectColumn() {
        return ((SimpleExtraction)Preconditions.checkNotNull((Object)this.simpleExtraction, (Object)"simpleExtraction")).getColumn();
    }

    public boolean isSimpleExtraction() {
        return this.simpleExtraction != null;
    }

    public SimpleExtraction getSimpleExtraction() {
        return (SimpleExtraction)Preconditions.checkNotNull((Object)this.simpleExtraction);
    }

    public boolean isArray() {
        return this.druidType != null && this.druidType.isArray();
    }

    public List<DruidExpression> getArguments() {
        return this.arguments;
    }

    public VirtualColumn toVirtualColumn(String name, ColumnType outputType, ExpressionParser parser) {
        return this.virtualColumnCreator.create(name, outputType, parser, this);
    }

    public VirtualColumn toExpressionVirtualColumn(String name, ColumnType outputType, ExpressionParser parser) {
        return DEFAULT_VIRTUAL_COLUMN_BUILDER.create(name, outputType, parser, this);
    }

    public NodeType getType() {
        return this.nodeType;
    }

    public boolean isIdentifierOrSpecialized() {
        return this.nodeType == NodeType.IDENTIFIER || this.nodeType == NodeType.SPECIALIZED;
    }

    @Nullable
    public ColumnType getDruidType() {
        return this.druidType;
    }

    public DruidExpression map(Function<SimpleExtraction, SimpleExtraction> extractionMap, Function<String, String> expressionMap) {
        return new DruidExpression(this.nodeType, this.druidType, this.simpleExtraction == null ? null : extractionMap.apply(this.simpleExtraction), args -> (String)expressionMap.apply(this.expressionGenerator.compile(args)), this.arguments, this.virtualColumnCreator);
    }

    public DruidExpression map(Function<SimpleExtraction, SimpleExtraction> extractionMap, Function<String, String> expressionMap, ColumnType newType) {
        return new DruidExpression(this.nodeType, newType, this.simpleExtraction == null ? null : extractionMap.apply(this.simpleExtraction), args -> (String)expressionMap.apply(this.expressionGenerator.compile(args)), this.arguments, this.virtualColumnCreator);
    }

    public DruidExpression withArguments(List<DruidExpression> newArgs) {
        return new DruidExpression(this.nodeType, this.druidType, this.simpleExtraction, this.expressionGenerator, newArgs, this.virtualColumnCreator);
    }

    public DruidExpression visit(DruidExpressionShuttle shuttle) {
        return new DruidExpression(this.nodeType, this.druidType, this.simpleExtraction, this.expressionGenerator, shuttle.visitAll(this.arguments), this.virtualColumnCreator);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        DruidExpression that = (DruidExpression)o;
        return Objects.equals(this.simpleExtraction, that.simpleExtraction) && Objects.equals((Object)this.nodeType, (Object)that.nodeType) && Objects.equals(this.druidType, that.druidType) && Objects.equals(this.arguments, that.arguments) && Objects.equals(this.expression.get(), that.expression.get());
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.nodeType, this.druidType, this.simpleExtraction, this.arguments, this.expression.get()});
    }

    public String toString() {
        return "DruidExpression{type=" + (this.druidType != null ? this.druidType.asTypeString() : DruidExpression.nullLiteral()) + ", simpleExtraction=" + String.valueOf(this.simpleExtraction) + ", expression='" + (String)this.expression.get() + "', arguments=" + String.valueOf(this.arguments) + "}";
    }

    static {
        Arrays.sort(SAFE_CHARS);
    }

    @FunctionalInterface
    public static interface ExpressionGenerator {
        public String compile(List<DruidExpression> var1);
    }

    public static enum NodeType {
        LITERAL,
        IDENTIFIER,
        EXPRESSION,
        SPECIALIZED;

    }

    public static class LiteralExpressionGenerator
    implements ExpressionGenerator {
        private final String literal;

        public LiteralExpressionGenerator(String literal) {
            this.literal = literal;
        }

        @Override
        public String compile(List<DruidExpression> arguments) {
            return this.literal;
        }
    }

    @FunctionalInterface
    public static interface VirtualColumnCreator {
        public VirtualColumn create(String var1, ColumnType var2, ExpressionParser var3, DruidExpression var4);
    }

    public static class IdentifierExpressionGenerator
    implements ExpressionGenerator {
        private final String identifier;

        public IdentifierExpressionGenerator(String identifier) {
            this.identifier = DruidExpression.escape(identifier);
        }

        @Override
        public String compile(List<DruidExpression> arguments) {
            return "\"" + this.identifier + "\"";
        }
    }

    @FunctionalInterface
    public static interface DruidExpressionShuttle {
        public DruidExpression visit(DruidExpression var1);

        default public List<DruidExpression> visitAll(List<DruidExpression> expressions) {
            ArrayList<DruidExpression> list = new ArrayList<DruidExpression>(expressions.size());
            for (DruidExpression expr : expressions) {
                list.add(this.visit(expr.visit(this)));
            }
            return list;
        }
    }

    public static class ExpressionVirtualColumnCreator
    implements VirtualColumnCreator {
        @Override
        public VirtualColumn create(String name, ColumnType outputType, ExpressionParser parser, DruidExpression self) {
            return new ExpressionVirtualColumn(name, self.getExpression(), parser.parse(self.getExpression()), outputType);
        }
    }

    @FunctionalInterface
    public static interface DruidExpressionCreator {
        public DruidExpression create(List<DruidExpression> var1);
    }
}

