/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.plan.RelOptPredicateList;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Window;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class InputAccessor {
    private final RelNode relNode;
    @Nullable
    private final Project flattenedProject;
    private final RowSignature inputRowSignature;
    @Nullable
    private final ImmutableList<RexLiteral> constants;
    private final RelNode inputRelNode;
    private final RelDataType inputRelRowType;
    private final RelOptPredicateList predicates;
    private final int inputFieldCount;
    private final RelDataType inputDruidRowType;

    public static InputAccessor buildFor(RelNode relNode, @Nullable Project flattenedProject, RowSignature rowSignature) {
        return new InputAccessor(relNode, flattenedProject, rowSignature);
    }

    private InputAccessor(RelNode relNode, Project flattenedProject, RowSignature rowSignature) {
        this.relNode = relNode;
        this.constants = this.getConstants(relNode);
        this.inputRelNode = relNode.getInput(0).stripped();
        this.flattenedProject = flattenedProject;
        this.inputRowSignature = rowSignature;
        this.inputRelRowType = this.inputRelNode.getRowType();
        this.predicates = relNode.getCluster().getMetadataQuery().getPulledUpPredicates(this.inputRelNode);
        this.inputFieldCount = this.inputRelRowType.getFieldCount();
        this.inputDruidRowType = RowSignatures.toRelDataType(this.inputRowSignature, this.getRexBuilder().getTypeFactory());
    }

    private ImmutableList<RexLiteral> getConstants(RelNode relNode) {
        if (relNode instanceof Window) {
            return ((Window)relNode).constants;
        }
        return null;
    }

    public RexNode getField(int argIndex) {
        if (argIndex < this.inputFieldCount) {
            RexInputRef inputRef = RexInputRef.of((int)argIndex, (RelDataType)this.inputRelRowType);
            RexNode constant = (RexNode)this.predicates.constantMap.get((Object)inputRef);
            if (constant != null && RexUtil.isLiteral((RexNode)constant, (boolean)false)) {
                return constant;
            }
            if (this.flattenedProject != null) {
                return (RexNode)this.flattenedProject.getProjects().get(argIndex);
            }
            return RexInputRef.of((int)argIndex, (RelDataType)this.inputDruidRowType);
        }
        return (RexNode)this.constants.get(argIndex - this.inputFieldCount);
    }

    public List<RexNode> getFields(List<Integer> argList) {
        return argList.stream().map(i -> this.getField((int)i)).collect(Collectors.toList());
    }

    @Nullable
    public Project getProject() {
        return this.flattenedProject;
    }

    public RexBuilder getRexBuilder() {
        return this.relNode.getCluster().getRexBuilder();
    }

    public RowSignature getInputRowSignature() {
        return this.inputRowSignature;
    }
}

