/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.avatica;

import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import javax.inject.Inject;
import org.apache.calcite.avatica.AvaticaUtils;
import org.apache.calcite.avatica.metrics.Timer;
import org.apache.calcite.avatica.remote.Handler;
import org.apache.calcite.avatica.remote.ProtobufHandler;
import org.apache.calcite.avatica.remote.ProtobufTranslation;
import org.apache.calcite.avatica.remote.ProtobufTranslationImpl;
import org.apache.calcite.avatica.remote.Service;
import org.apache.calcite.avatica.server.AvaticaProtobufHandler;
import org.apache.calcite.avatica.util.UnsynchronizedBuffer;
import org.apache.druid.guice.annotations.Self;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.DruidNode;
import org.apache.druid.sql.avatica.AvaticaMonitor;
import org.apache.druid.sql.avatica.DruidAvaticaHandler;
import org.apache.druid.sql.avatica.DruidMeta;
import org.eclipse.jetty.io.Content;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.server.Response;
import org.eclipse.jetty.util.Callback;

public class DruidAvaticaProtobufHandler
extends DruidAvaticaHandler {
    private static final Logger LOG = new Logger(DruidAvaticaProtobufHandler.class);
    public static final String AVATICA_PATH_NO_TRAILING_SLASH = "/druid/v2/sql/avatica-protobuf";
    public static final String AVATICA_PATH = "/druid/v2/sql/avatica-protobuf/";
    private final ProtobufHandler protobufHandler;

    @Inject
    public DruidAvaticaProtobufHandler(DruidMeta druidMeta, @Self DruidNode druidNode, AvaticaMonitor metrics) {
        super(druidMeta, metrics, AvaticaProtobufHandler.class);
        ProtobufTranslationImpl protobufTranslation = new ProtobufTranslationImpl();
        this.protobufHandler = new ProtobufHandler(this.service, (ProtobufTranslation)protobufTranslation, this.metrics);
        this.setServerRpcMetadata(new Service.RpcMetadataResponse(druidNode.getHostAndPortToUse()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean handle(Request request, Response response, Callback callback) throws Exception {
        String requestURI = request.getHttpURI().getPath();
        if (AVATICA_PATH_NO_TRAILING_SLASH.equals(StringUtils.maybeRemoveTrailingSlash((String)requestURI))) {
            try (Timer.Context ctx = this.requestTimer.start();){
                Handler.HandlerResponse handlerResponse;
                byte[] requestBytes;
                if (!"POST".equals(request.getMethod())) {
                    response.setStatus(405);
                    response.write(true, ByteBuffer.wrap("This server expects only POST calls.".getBytes(StandardCharsets.UTF_8)), callback);
                    boolean bl = true;
                    return bl;
                }
                UnsynchronizedBuffer buffer = (UnsynchronizedBuffer)this.threadLocalBuffer.get();
                try (InputStream inputStream = Content.Source.asInputStream((Content.Source)request);){
                    requestBytes = AvaticaUtils.readFullyToBytes((InputStream)inputStream, (UnsynchronizedBuffer)buffer);
                }
                finally {
                    buffer.reset();
                }
                response.getHeaders().put("Content-Type", "application/octet-stream;charset=utf-8");
                try {
                    handlerResponse = this.protobufHandler.apply(requestBytes);
                }
                catch (Exception e) {
                    LOG.debug((Throwable)e, "Error invoking request", new Object[0]);
                    handlerResponse = this.protobufHandler.convertToErrorResponse(e);
                }
                response.setStatus(handlerResponse.getStatusCode());
                response.write(true, ByteBuffer.wrap((byte[])handlerResponse.getResponse()), callback);
                boolean bl = true;
                return bl;
            }
        }
        return false;
    }

    @Override
    public void setServerRpcMetadata(Service.RpcMetadataResponse metadata) {
        super.setServerRpcMetadata(metadata);
        if (this.protobufHandler != null) {
            this.protobufHandler.setRpcMetadata(metadata);
        }
    }
}

