/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executor;
import org.apache.druid.client.InternalQueryConfig;
import org.apache.druid.client.ServerView;
import org.apache.druid.client.TimelineServerView;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.metadata.AbstractSegmentMetadataCache;
import org.apache.druid.segment.metadata.CentralizedDatasourceSchemaConfig;
import org.apache.druid.segment.metadata.SegmentMetadataCacheConfig;
import org.apache.druid.segment.realtime.appenderator.SegmentSchemas;
import org.apache.druid.server.QueryLifecycleFactory;
import org.apache.druid.server.coordination.DruidServerMetadata;
import org.apache.druid.server.security.Escalator;
import org.apache.druid.sql.calcite.schema.BrokerSegmentMetadataCacheConfig;
import org.apache.druid.sql.calcite.schema.PhysicalDatasourceMetadataFactory;
import org.apache.druid.sql.calcite.table.DatasourceTable;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;

@ManageLifecycle
public class BrokerSegmentMetadataCache
extends AbstractSegmentMetadataCache<DatasourceTable.PhysicalDatasourceMetadata> {
    private static final EmittingLogger log = new EmittingLogger(BrokerSegmentMetadataCache.class);
    private final PhysicalDatasourceMetadataFactory dataSourceMetadataFactory;
    private final CoordinatorClient coordinatorClient;
    private final BrokerSegmentMetadataCacheConfig config;
    private final CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig;

    @Inject
    public BrokerSegmentMetadataCache(QueryLifecycleFactory queryLifecycleFactory, TimelineServerView serverView, BrokerSegmentMetadataCacheConfig config, Escalator escalator, InternalQueryConfig internalQueryConfig, ServiceEmitter emitter, PhysicalDatasourceMetadataFactory dataSourceMetadataFactory, CoordinatorClient coordinatorClient, CentralizedDatasourceSchemaConfig centralizedDatasourceSchemaConfig) {
        super(queryLifecycleFactory, (SegmentMetadataCacheConfig)config, escalator, internalQueryConfig, emitter);
        this.dataSourceMetadataFactory = dataSourceMetadataFactory;
        this.coordinatorClient = coordinatorClient;
        this.config = config;
        this.centralizedDatasourceSchemaConfig = centralizedDatasourceSchemaConfig;
        this.initServerViewTimelineCallback(serverView);
    }

    private void initServerViewTimelineCallback(TimelineServerView serverView) {
        serverView.registerTimelineCallback((Executor)this.callbackExec, new TimelineServerView.TimelineCallback(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public ServerView.CallbackAction timelineInitialized() {
                Object object = BrokerSegmentMetadataCache.this.lock;
                synchronized (object) {
                    BrokerSegmentMetadataCache.this.isServerViewInitialized = true;
                    BrokerSegmentMetadataCache.this.lock.notifyAll();
                }
                return ServerView.CallbackAction.CONTINUE;
            }

            public ServerView.CallbackAction segmentAdded(DruidServerMetadata server, DataSegment segment) {
                BrokerSegmentMetadataCache.this.addSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            public ServerView.CallbackAction segmentRemoved(DataSegment segment) {
                BrokerSegmentMetadataCache.this.removeSegment(segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            public ServerView.CallbackAction serverSegmentRemoved(DruidServerMetadata server, DataSegment segment) {
                BrokerSegmentMetadataCache.this.removeServerSegment(server, segment);
                return ServerView.CallbackAction.CONTINUE;
            }

            public ServerView.CallbackAction segmentSchemasAnnounced(SegmentSchemas segmentSchemas) {
                return ServerView.CallbackAction.CONTINUE;
            }
        });
    }

    @LifecycleStart
    public void start() throws InterruptedException {
        log.info("Initializing cache.", new Object[0]);
        this.cacheExec.submit(() -> this.cacheExecLoop());
        if (this.config.isAwaitInitializationOnStart()) {
            this.awaitInitialization();
        }
    }

    @LifecycleStop
    public void stop() {
        this.cacheExec.shutdownNow();
        this.callbackExec.shutdownNow();
    }

    protected boolean shouldRefresh() {
        return this.centralizedDatasourceSchemaConfig.isEnabled() || super.shouldRefresh();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void refresh(Set<SegmentId> segmentsToRefresh, Set<String> dataSourcesToRebuild) throws IOException {
        HashSet<String> dataSourcesToQuery = new HashSet<String>(this.segmentMetadataInfo.keySet());
        Set<String> polledDatasources = this.queryDataSources();
        dataSourcesToQuery.addAll(polledDatasources);
        log.debug("Querying schema for [%s] datasources from Coordinator.", new Object[]{dataSourcesToQuery});
        Map<String, DatasourceTable.PhysicalDatasourceMetadata> polledDataSourceMetadata = this.queryDataSourceInformation(dataSourcesToQuery);
        log.debug("Fetched schema for [%s] datasources from Coordinator.", new Object[]{polledDataSourceMetadata.keySet()});
        polledDataSourceMetadata.forEach(this::updateDSMetadata);
        segmentsToRefresh.removeIf(segmentId -> polledDataSourceMetadata.containsKey(segmentId.getDataSource()));
        Set refreshed = new HashSet();
        if (!this.config.isDisableSegmentMetadataQueries()) {
            refreshed = this.refreshSegments(segmentsToRefresh);
        }
        Iterator<String> iterator = this.lock;
        synchronized (iterator) {
            this.segmentsNeedingRefresh.addAll(Sets.difference(segmentsToRefresh, refreshed));
            dataSourcesToRebuild.addAll(this.dataSourcesNeedingRebuild);
            refreshed.forEach(segment -> dataSourcesToRebuild.add(segment.getDataSource()));
            dataSourcesToRebuild.removeAll(polledDataSourceMetadata.keySet());
            this.dataSourcesNeedingRebuild.clear();
        }
        for (String dataSource : dataSourcesToRebuild) {
            RowSignature rowSignature = this.buildDataSourceRowSignature(dataSource);
            if (rowSignature == null) {
                log.info("datasource [%s] no longer exists, all metadata removed.", new Object[]{dataSource});
                this.tables.remove(dataSource);
                continue;
            }
            if (rowSignature.getColumnNames().isEmpty()) {
                log.info("datasource [%s] schema has not been initialized yet, check coordinator logs if this message is persistent.", new Object[]{dataSource});
                this.tables.remove(dataSource);
                continue;
            }
            DatasourceTable.PhysicalDatasourceMetadata physicalDatasourceMetadata = this.dataSourceMetadataFactory.build(dataSource, rowSignature);
            this.updateDSMetadata(dataSource, physicalDatasourceMetadata);
        }
    }

    protected void removeSegmentAction(SegmentId segmentId) {
    }

    private Set<String> queryDataSources() {
        HashSet<String> dataSources = new HashSet<String>();
        try {
            Set polled = (Set)FutureUtils.getUnchecked((ListenableFuture)this.coordinatorClient.fetchDataSourcesWithUsedSegments(), (boolean)true);
            if (polled != null) {
                dataSources.addAll(polled);
            }
        }
        catch (Exception e) {
            log.debug((Throwable)e, "Failed to query datasources from the Coordinator.", new Object[0]);
        }
        return dataSources;
    }

    private Map<String, DatasourceTable.PhysicalDatasourceMetadata> queryDataSourceInformation(Set<String> dataSourcesToQuery) {
        Stopwatch stopwatch = Stopwatch.createStarted();
        List dataSourceInformations = null;
        try {
            dataSourceInformations = (List)FutureUtils.getUnchecked((ListenableFuture)this.coordinatorClient.fetchDataSourceInformation(dataSourcesToQuery), (boolean)true);
        }
        catch (Exception e) {
            log.debug((Throwable)e, "Failed to query datasource information from the Coordinator.", new Object[0]);
            this.emitMetric("segment/schemaCache/poll/failed", 1L);
        }
        this.emitMetric("segment/schemaCache/poll/time", stopwatch.millisElapsed());
        HashMap<String, DatasourceTable.PhysicalDatasourceMetadata> polledDataSourceMetadata = new HashMap<String, DatasourceTable.PhysicalDatasourceMetadata>();
        if (dataSourceInformations != null) {
            dataSourceInformations.forEach(dataSourceInformation -> polledDataSourceMetadata.put(dataSourceInformation.getDataSource(), this.dataSourceMetadataFactory.build(dataSourceInformation.getDataSource(), dataSourceInformation.getRowSignature())));
        }
        return polledDataSourceMetadata;
    }

    private void updateDSMetadata(String dataSource, DatasourceTable.PhysicalDatasourceMetadata physicalDatasourceMetadata) {
        DatasourceTable.PhysicalDatasourceMetadata oldTable = this.tables.put(dataSource, physicalDatasourceMetadata);
        if (oldTable == null || !oldTable.getRowSignature().equals((Object)physicalDatasourceMetadata.getRowSignature())) {
            log.info("[%s] has new signature: %s.", new Object[]{dataSource, physicalDatasourceMetadata.getRowSignature()});
        } else {
            log.debug("[%s] signature is unchanged.", new Object[]{dataSource});
        }
    }
}

