/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.rel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.math.expr.ExpressionType;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.post.ExpressionPostAggregator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.segment.column.TypeDescriptor;
import org.apache.druid.segment.column.TypeSignature;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.expression.OperatorConversions;
import org.apache.druid.sql.calcite.expression.PostAggregatorVisitor;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.CannotBuildQueryException;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class Projection {
    @Nullable
    private final List<PostAggregator> postAggregators;
    @Nullable
    private final List<String> virtualColumns;
    private final RowSignature outputRowSignature;

    private Projection(@Nullable List<PostAggregator> postAggregators, @Nullable List<String> virtualColumns, RowSignature outputRowSignature) {
        if (postAggregators == null && virtualColumns == null) {
            throw new IAE("postAggregators and virtualColumns cannot both be null", new Object[0]);
        }
        if (postAggregators != null && virtualColumns != null) {
            throw new IAE("postAggregators and virtualColumns cannot both be nonnull", new Object[0]);
        }
        this.postAggregators = postAggregators;
        this.virtualColumns = virtualColumns;
        this.outputRowSignature = outputRowSignature;
    }

    private static void postAggregationHandleInputRefOrLiteral(Project project, PlannerContext plannerContext, RowSignature inputRowSignature, RexNode postAggregatorRexNode, List<String> rowOrder, PostAggregatorVisitor postAggregatorVisitor) {
        DruidExpression postAggregatorExpression = Expressions.toDruidExpression(plannerContext, inputRowSignature, postAggregatorRexNode);
        if (postAggregatorExpression == null) {
            throw new CannotBuildQueryException((RelNode)project, postAggregatorRexNode);
        }
        Projection.handlePostAggregatorExpression(plannerContext, inputRowSignature, postAggregatorRexNode, rowOrder, postAggregatorVisitor, postAggregatorExpression);
    }

    private static void postAggregationHandleOtherKinds(Project project, PlannerContext plannerContext, RowSignature inputRowSignature, RexNode postAggregatorRexNode, List<String> rowOrder, PostAggregatorVisitor postAggregatorVisitor) {
        PostAggregator pagg = OperatorConversions.toPostAggregator(plannerContext, inputRowSignature, postAggregatorRexNode, postAggregatorVisitor, false);
        if (pagg != null) {
            postAggregatorVisitor.addPostAgg(pagg);
            rowOrder.add(pagg.getName());
        } else {
            DruidExpression postAggregatorExpression = Expressions.toDruidExpressionWithPostAggOperands(plannerContext, inputRowSignature, postAggregatorRexNode, postAggregatorVisitor);
            if (postAggregatorExpression == null) {
                throw new CannotBuildQueryException((RelNode)project, postAggregatorRexNode);
            }
            Projection.handlePostAggregatorExpression(plannerContext, inputRowSignature, postAggregatorRexNode, rowOrder, postAggregatorVisitor, postAggregatorExpression);
        }
    }

    private static void handlePostAggregatorExpression(PlannerContext plannerContext, RowSignature inputRowSignature, RexNode postAggregatorRexNode, List<String> rowOrder, PostAggregatorVisitor postAggregatorVisitor, DruidExpression postAggregatorExpression) {
        if (Projection.postAggregatorDirectColumnIsOk(inputRowSignature, postAggregatorExpression, postAggregatorRexNode)) {
            rowOrder.add(postAggregatorExpression.getDirectColumn());
        } else {
            ExpressionPostAggregator postAggregator = new ExpressionPostAggregator(postAggregatorVisitor.getOutputNamePrefix() + postAggregatorVisitor.getAndIncrementCounter(), postAggregatorExpression.getExpression(), null, postAggregatorExpression.getDruidType(), plannerContext.parseExpression(postAggregatorExpression.getExpression()));
            postAggregatorVisitor.addPostAgg((PostAggregator)postAggregator);
            rowOrder.add(postAggregator.getName());
        }
    }

    public static Projection postAggregation(Project project, PlannerContext plannerContext, RowSignature inputRowSignature, String basePrefix) {
        ArrayList<String> rowOrder = new ArrayList<String>();
        String outputNamePrefix = Calcites.findUnusedPrefixForDigits(basePrefix, inputRowSignature.getColumnNames());
        PostAggregatorVisitor postAggVisitor = new PostAggregatorVisitor(outputNamePrefix);
        for (RexNode postAggregatorRexNode : project.getProjects()) {
            if (postAggregatorRexNode.getKind() == SqlKind.INPUT_REF || postAggregatorRexNode.getKind() == SqlKind.LITERAL) {
                Projection.postAggregationHandleInputRefOrLiteral(project, plannerContext, inputRowSignature, postAggregatorRexNode, rowOrder, postAggVisitor);
                continue;
            }
            Projection.postAggregationHandleOtherKinds(project, plannerContext, inputRowSignature, postAggregatorRexNode, rowOrder, postAggVisitor);
        }
        return new Projection(postAggVisitor.getPostAggs(), null, RowSignatures.fromRelDataType(rowOrder, project.getRowType()));
    }

    public static Projection preAggregation(Project project, PlannerContext plannerContext, RowSignature inputRowSignature, VirtualColumnRegistry virtualColumnRegistry) {
        ArrayList<DruidExpression> expressions = new ArrayList<DruidExpression>();
        for (RexNode rexNode : project.getProjects()) {
            DruidExpression expression = Expressions.toDruidExpression(plannerContext, inputRowSignature, rexNode);
            if (expression == null) {
                throw new CannotBuildQueryException((RelNode)project, rexNode);
            }
            expressions.add(expression);
        }
        HashSet<String> virtualColumns = new HashSet<String>();
        ArrayList<String> rowOrder = new ArrayList<String>();
        for (int i = 0; i < expressions.size(); ++i) {
            DruidExpression expression = (DruidExpression)expressions.get(i);
            RelDataType dataType = ((RelDataTypeField)project.getRowType().getFieldList().get(i)).getType();
            if (expression.isDirectColumnAccess() && Objects.equals(inputRowSignature.getColumnType(expression.getDirectColumn()).orElse(null), Calcites.getColumnTypeForRelDataType(dataType))) {
                rowOrder.add(expression.getDirectColumn());
                continue;
            }
            String virtualColumnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(expression, ((RexNode)project.getProjects().get(i)).getType());
            virtualColumns.add(virtualColumnName);
            rowOrder.add(virtualColumnName);
        }
        return new Projection(null, (List<String>)ImmutableList.copyOf(virtualColumns), RowSignatures.fromRelDataType(rowOrder, project.getRowType()));
    }

    private static boolean postAggregatorDirectColumnIsOk(RowSignature aggregateRowSignature, DruidExpression expression, RexNode rexNode) {
        if (!expression.isDirectColumnAccess()) {
            return false;
        }
        ColumnType columnValueType = (ColumnType)aggregateRowSignature.getColumnType(expression.getDirectColumn()).orElseThrow(() -> new ISE("Encountered null type for column[%s]", new Object[]{expression.getDirectColumn()}));
        if (columnValueType.is((TypeDescriptor)ValueType.COMPLEX)) {
            return true;
        }
        ExpressionType toExprType = ExpressionType.fromColumnTypeStrict((TypeSignature)columnValueType);
        ExpressionType fromExprType = ExpressionType.fromColumnTypeStrict((TypeSignature)Calcites.getColumnTypeForRelDataType(rexNode.getType()));
        return toExprType.equals((Object)fromExprType);
    }

    public List<PostAggregator> getPostAggregators() {
        return (List)Preconditions.checkNotNull(this.postAggregators, (Object)"postAggregators");
    }

    public List<String> getVirtualColumns() {
        return (List)Preconditions.checkNotNull(this.virtualColumns, (Object)"virtualColumns");
    }

    public RowSignature getOutputRowSignature() {
        return this.outputRowSignature;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Projection that = (Projection)o;
        return Objects.equals(this.postAggregators, that.postAggregators) && Objects.equals(this.virtualColumns, that.virtualColumns) && Objects.equals(this.outputRowSignature, that.outputRowSignature);
    }

    public int hashCode() {
        return Objects.hash(this.postAggregators, this.virtualColumns, this.outputRowSignature);
    }

    public String toString() {
        return "PostSortingExpressions{postAggregators=" + String.valueOf(this.postAggregators) + ", virtualColumns=" + String.valueOf(this.virtualColumns) + ", outputRowSignature=" + String.valueOf(this.outputRowSignature) + "}";
    }
}

