/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.base.Suppliers;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.interpreter.BindableConvention;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelRoot;
import org.apache.calcite.rel.RelShuttle;
import org.apache.calcite.rel.RelVisitor;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.logical.LogicalSort;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.ProjectableFilterableTable;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlExplainFormat;
import org.apache.calcite.sql.SqlExplainLevel;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.tools.ValidationException;
import org.apache.calcite.util.Pair;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.jackson.DefaultObjectMapper;
import org.apache.druid.java.util.common.guava.BaseSequence;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.query.Query;
import org.apache.druid.query.explain.ExplainAttributes;
import org.apache.druid.server.QueryResponse;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.planner.CalcitePlanner;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.OffsetLimit;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerResult;
import org.apache.druid.sql.calcite.planner.PrepareResult;
import org.apache.druid.sql.calcite.planner.QueryUtils;
import org.apache.druid.sql.calcite.planner.QueryValidations;
import org.apache.druid.sql.calcite.planner.RelParameterizerShuttle;
import org.apache.druid.sql.calcite.planner.SqlResourceCollectorShuttle;
import org.apache.druid.sql.calcite.planner.SqlStatementHandler;
import org.apache.druid.sql.calcite.planner.querygen.DruidQueryGenerator;
import org.apache.druid.sql.calcite.rel.DruidConvention;
import org.apache.druid.sql.calcite.rel.DruidQuery;
import org.apache.druid.sql.calcite.rel.DruidRel;
import org.apache.druid.sql.calcite.rel.DruidUnionRel;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalConvention;
import org.apache.druid.sql.calcite.rel.logical.DruidLogicalNode;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.table.DruidTable;
import org.apache.druid.sql.hook.DruidHook;
import org.apache.druid.utils.Throwables;

public abstract class QueryHandler
extends SqlStatementHandler.BaseStatementHandler {
    static final EmittingLogger log = new EmittingLogger(QueryHandler.class);
    protected SqlExplain explain;
    private boolean isPrepared;
    protected RelRoot rootQueryRel;
    private PrepareResult prepareResult;
    protected RexBuilder rexBuilder;

    public QueryHandler(SqlStatementHandler.HandlerContext handlerContext, SqlExplain explain) {
        super(handlerContext);
        this.explain = explain;
    }

    protected SqlNode validate(SqlNode root) {
        SqlNode validatedQueryNode;
        CalcitePlanner planner = this.handlerContext.planner();
        try {
            validatedQueryNode = planner.validate(root);
        }
        catch (ValidationException e) {
            throw DruidPlanner.translateException((Exception)((Object)e));
        }
        SqlValidator validator = planner.getValidator();
        SqlResourceCollectorShuttle resourceCollectorShuttle = new SqlResourceCollectorShuttle(validator, this.handlerContext.plannerContext());
        validatedQueryNode.accept((SqlVisitor)resourceCollectorShuttle);
        this.resourceActions = resourceCollectorShuttle.getResourceActions();
        return validatedQueryNode;
    }

    @Override
    public void prepare() {
        RelDataType returnedRowType;
        if (this.isPrepared) {
            return;
        }
        this.isPrepared = true;
        SqlNode validatedQueryNode = this.validatedQueryNode();
        this.rootQueryRel = this.handlerContext.planner().rel(validatedQueryNode);
        this.handlerContext.plannerContext().dispatchHook(DruidHook.CONVERTED_PLAN, this.rootQueryRel.rel);
        this.handlerContext.hook().captureQueryRel(this.rootQueryRel);
        RelDataTypeFactory typeFactory = this.rootQueryRel.rel.getCluster().getTypeFactory();
        SqlValidator validator = this.handlerContext.planner().getValidator();
        RelDataType parameterTypes = validator.getParameterRowType(validatedQueryNode);
        this.handlerContext.hook().captureParameterTypes(parameterTypes);
        if (this.explain != null) {
            this.handlerContext.plannerContext().setExplainAttributes(this.explainAttributes());
            returnedRowType = QueryHandler.getExplainStructType(typeFactory);
        } else {
            returnedRowType = this.returnedRowType();
        }
        this.prepareResult = new PrepareResult(this.rootQueryRel.validatedRowType, returnedRowType, parameterTypes);
    }

    @Override
    public PrepareResult prepareResult() {
        return this.prepareResult;
    }

    protected abstract SqlNode validatedQueryNode();

    protected abstract RelDataType returnedRowType();

    private static RelDataType getExplainStructType(RelDataTypeFactory typeFactory) {
        return typeFactory.createStructType((List)ImmutableList.of((Object)Calcites.createSqlType(typeFactory, SqlTypeName.VARCHAR), (Object)Calcites.createSqlType(typeFactory, SqlTypeName.VARCHAR), (Object)Calcites.createSqlType(typeFactory, SqlTypeName.VARCHAR)), (List)ImmutableList.of((Object)"PLAN", (Object)"RESOURCES", (Object)"ATTRIBUTES"));
    }

    @Override
    public PlannerResult plan() {
        this.prepare();
        Set<RelOptTable> bindableTables = QueryHandler.getBindableTables(this.rootQueryRel.rel);
        this.rexBuilder = new RexBuilder((RelDataTypeFactory)this.handlerContext.planner().getTypeFactory());
        try {
            if (!bindableTables.isEmpty()) {
                if (!this.handlerContext.plannerContext().featureAvailable(EngineFeature.ALLOW_BINDABLE_PLAN)) {
                    throw InvalidSqlInput.exception((String)"Cannot query table(s) [%s] with SQL engine [%s]", (Object[])new Object[]{bindableTables.stream().map(table -> Joiner.on((String)".").join((Iterable)table.getQualifiedName())).collect(Collectors.joining(", ")), this.handlerContext.engine().name()});
                }
                return this.planWithBindableConvention();
            }
            return this.planForDruid();
        }
        catch (RelOptPlanner.CannotPlanException e) {
            throw this.buildSQLPlanningError(e);
        }
        catch (RuntimeException e) {
            if (e instanceof DruidException) {
                throw e;
            }
            RelOptPlanner.CannotPlanException cpe = (RelOptPlanner.CannotPlanException)Throwables.getCauseOfType((Throwable)e, RelOptPlanner.CannotPlanException.class);
            if (cpe != null) {
                throw this.buildSQLPlanningError(cpe);
            }
            DruidException de = (DruidException)Throwables.getCauseOfType((Throwable)e, DruidException.class);
            if (de != null) {
                throw de;
            }
            if (e.getMessage() != null && e.getCause() != null && e.getCause().getMessage() != null && e.getMessage().startsWith("Error while applying rule")) {
                throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.ADMIN).ofCategory(DruidException.Category.UNCATEGORIZED).build((Throwable)e, "%s", new Object[]{e.getCause().getMessage()});
            }
            throw DruidPlanner.translateException(e);
        }
        catch (Exception e) {
            throw DruidPlanner.translateException(e);
        }
    }

    @Override
    public ExplainAttributes explainAttributes() {
        return new ExplainAttributes("SELECT", null, null, null, null);
    }

    private static Set<RelOptTable> getBindableTables(RelNode relNode) {
        class HasBindableVisitor
        extends RelVisitor {
            private final Set<RelOptTable> found = new HashSet<RelOptTable>();

            HasBindableVisitor() {
            }

            public void visit(RelNode node, int ordinal, RelNode parent) {
                RelOptTable table;
                if (node instanceof TableScan && ((table = node.getTable()).unwrap(ScannableTable.class) != null || table.unwrap(ProjectableFilterableTable.class) != null) && table.unwrap(DruidTable.class) == null) {
                    this.found.add(table);
                    return;
                }
                super.visit(node, ordinal, parent);
            }
        }
        HasBindableVisitor visitor = new HasBindableVisitor();
        visitor.go(relNode);
        return visitor.found;
    }

    private PlannerResult planWithBindableConvention() {
        CalcitePlanner planner = this.handlerContext.planner();
        BindableRel bindableRel = (BindableRel)planner.transform(1, planner.getEmptyTraitSet().replace((RelTrait)BindableConvention.INSTANCE).plus((RelTrait)this.rootQueryRel.collation), this.rootQueryRel.rel);
        if (!this.rootQueryRel.isRefTrivial()) {
            ArrayList<RexInputRef> projects = new ArrayList<RexInputRef>();
            RexBuilder rexBuilder = bindableRel.getCluster().getRexBuilder();
            Iterator iterator = Pair.left((List)this.rootQueryRel.fields).iterator();
            while (iterator.hasNext()) {
                int field = (Integer)iterator.next();
                projects.add(rexBuilder.makeInputRef((RelNode)bindableRel, field));
            }
            bindableRel = new Bindables.BindableProject(bindableRel.getCluster(), bindableRel.getTraitSet(), (RelNode)bindableRel, projects, this.rootQueryRel.validatedRowType);
        }
        this.handlerContext.hook().captureBindableRel(bindableRel);
        PlannerContext plannerContext = this.handlerContext.plannerContext();
        if (this.explain != null) {
            return this.planExplanation(this.rootQueryRel, (RelNode)bindableRel, false);
        }
        BindableRel theRel = bindableRel;
        DataContext dataContext = plannerContext.createDataContext(planner.getTypeFactory(), plannerContext.getParameters());
        Supplier resultsSupplier = () -> {
            Enumerable enumerable = theRel.bind(dataContext);
            final Enumerator enumerator = enumerable.enumerator();
            return QueryResponse.withEmptyContext((Sequence)Sequences.withBaggage((Sequence)new BaseSequence((BaseSequence.IteratorMaker)new BaseSequence.IteratorMaker<Object[], EnumeratorIterator<Object[]>>(){

                public EnumeratorIterator<Object[]> make() {
                    return new EnumeratorIterator<Object[]>(new Iterator<Object[]>(){

                        @Override
                        public boolean hasNext() {
                            return enumerator.moveNext();
                        }

                        @Override
                        public Object[] next() {
                            return (Object[])enumerator.current();
                        }
                    });
                }

                public void cleanup(EnumeratorIterator<Object[]> iterFromMake) {
                }
            }), () -> ((Enumerator)enumerator).close()));
        };
        return new PlannerResult((Supplier<QueryResponse<Object[]>>)resultsSupplier, this.rootQueryRel.validatedRowType);
    }

    protected PlannerResult planExplanation(RelRoot relRoot, RelNode rel, boolean isDruidConventionExplanation) {
        String explainAttributesString;
        String resourcesString;
        PlannerContext plannerContext = this.handlerContext.plannerContext();
        String explanation = RelOptUtil.dumpPlan((String)"", (RelNode)rel, (SqlExplainFormat)this.explain.getFormat(), (SqlExplainLevel)this.explain.getDetailLevel());
        try {
            if (isDruidConventionExplanation && rel instanceof DruidRel && plannerContext.getPlannerConfig().isUseNativeQueryExplain()) {
                DruidRel druidRel = (DruidRel)rel;
                try {
                    explanation = this.explainSqlPlanAsNativeQueries(plannerContext, relRoot, druidRel);
                }
                catch (Exception ex) {
                    log.warn((Throwable)ex, "Unable to translate to a native Druid query. Resorting to legacy Druid explain plan.", new Object[0]);
                }
            }
            List resources = plannerContext.getResourceActions().stream().map(ResourceAction::getResource).sorted(Comparator.comparing(Resource::getName)).collect(Collectors.toList());
            resourcesString = plannerContext.getJsonMapper().writeValueAsString(resources);
        }
        catch (JsonProcessingException jpe) {
            log.error((Throwable)jpe, "Encountered exception while serializing resources for explain output", new Object[0]);
            resourcesString = null;
        }
        try {
            explainAttributesString = plannerContext.getJsonMapper().writeValueAsString((Object)plannerContext.getExplainAttributes());
        }
        catch (JsonProcessingException jpe) {
            log.error((Throwable)jpe, "Encountered exception while serializing attributes for explain output", new Object[0]);
            explainAttributesString = null;
        }
        Supplier resultsSupplier = Suppliers.ofInstance((Object)QueryResponse.withEmptyContext((Sequence)Sequences.simple((Iterable)ImmutableList.of((Object)new Object[]{explanation, resourcesString, explainAttributesString}))));
        return new PlannerResult((Supplier<QueryResponse<Object[]>>)resultsSupplier, QueryHandler.getExplainStructType(rel.getCluster().getTypeFactory()));
    }

    private String explainSqlPlanAsNativeQueries(PlannerContext plannerContext, RelRoot relRoot, DruidRel<?> rel) throws JsonProcessingException {
        ObjectMapper jsonMapper = this.handlerContext.jsonMapper();
        List druidQueryList = this.flattenOutermostRel(rel).stream().map(druidRel -> druidRel.toDruidQuery(false)).collect(Collectors.toList());
        ArrayNode nativeQueriesArrayNode = jsonMapper.createArrayNode();
        for (DruidQuery druidQuery : druidQueryList) {
            Query<?> nativeQuery = druidQuery.getQuery();
            plannerContext.dispatchHook(DruidHook.NATIVE_PLAN, nativeQuery);
            ObjectNode objectNode = jsonMapper.createObjectNode();
            objectNode.set("query", (JsonNode)jsonMapper.convertValue(nativeQuery, ObjectNode.class));
            objectNode.set("signature", (JsonNode)jsonMapper.convertValue((Object)druidQuery.getOutputRowSignature(), ArrayNode.class));
            objectNode.set("columnMappings", (JsonNode)jsonMapper.convertValue(QueryUtils.buildColumnMappings((List<Map.Entry<Integer, String>>)relRoot.fields, druidQuery.getOutputRowSignature()).getMappings(), ArrayNode.class));
            nativeQueriesArrayNode.add((JsonNode)objectNode);
        }
        return jsonMapper.writeValueAsString((Object)nativeQueriesArrayNode);
    }

    private List<DruidRel<?>> flattenOutermostRel(DruidRel<?> outermostDruidRel) {
        ArrayList druidRels = new ArrayList();
        this.flattenOutermostRel(outermostDruidRel, druidRels);
        return druidRels;
    }

    private void flattenOutermostRel(DruidRel<?> druidRel, List<DruidRel<?>> flattendListAccumulator) {
        if (druidRel instanceof DruidUnionRel) {
            DruidUnionRel druidUnionRel = (DruidUnionRel)druidRel;
            druidUnionRel.getInputs().forEach(innerRelNode -> {
                DruidRel innerDruidRelNode = (DruidRel)((Object)innerRelNode);
                this.flattenOutermostRel(innerDruidRelNode, flattendListAccumulator);
            });
        } else {
            flattendListAccumulator.add(druidRel);
        }
    }

    protected abstract PlannerResult planForDruid() throws ValidationException;

    protected PlannerResult planWithDruidConvention() throws ValidationException {
        RelRoot possiblyLimitedRoot = this.possiblyWrapRootWithOuterLimitFromContext(this.rootQueryRel);
        this.handlerContext.hook().captureQueryRel(possiblyLimitedRoot);
        QueryMaker queryMaker = this.buildQueryMaker(possiblyLimitedRoot);
        PlannerContext plannerContext = this.handlerContext.plannerContext();
        plannerContext.setQueryMaker(queryMaker);
        RelNode parameterized = possiblyLimitedRoot.rel.accept((RelShuttle)new RelParameterizerShuttle(plannerContext));
        QueryValidations.validateLogicalQueryForDruid(this.handlerContext.plannerContext(), parameterized);
        CalcitePlanner planner = this.handlerContext.planner();
        RelDataType rowType = this.prepareResult.getReturnedRowType();
        if (plannerContext.getPlannerConfig().getNativeQuerySqlPlanningMode().equals("DECOUPLED")) {
            RelNode newRoot = parameterized;
            newRoot = planner.transform(2, planner.getEmptyTraitSet().plus((RelTrait)this.rootQueryRel.collation).plus((RelTrait)DruidLogicalConvention.instance()), newRoot);
            plannerContext.dispatchHook(DruidHook.DRUID_PLAN, newRoot);
            if (queryMaker instanceof QueryMaker.FromDruidLogical) {
                QueryMaker.FromDruidLogical logicalQueryMaker = (QueryMaker.FromDruidLogical)((Object)queryMaker);
                QueryResponse<Object[]> response = logicalQueryMaker.runQuery((DruidLogicalNode)newRoot);
                return new PlannerResult((Supplier<QueryResponse<Object[]>>)((Supplier)() -> response), rowType);
            }
            DruidQueryGenerator generator = new DruidQueryGenerator(plannerContext, (DruidLogicalNode)newRoot, this.rexBuilder);
            DruidQuery baseQuery = generator.buildQuery();
            try {
                log.info("final query : " + new DefaultObjectMapper().writerWithDefaultPrettyPrinter().writeValueAsString(baseQuery.getQuery()), new Object[0]);
            }
            catch (JsonProcessingException e) {
                throw new RuntimeException(e);
            }
            DruidQuery finalBaseQuery = baseQuery;
            Supplier resultsSupplier = () -> plannerContext.getQueryMaker().runQuery(finalBaseQuery);
            if (this.explain != null) {
                plannerContext.dispatchHook(DruidHook.NATIVE_PLAN, finalBaseQuery.getQuery());
                return this.planExplanation(possiblyLimitedRoot, newRoot, true);
            }
            return new PlannerResult((Supplier<QueryResponse<Object[]>>)resultsSupplier, rowType);
        }
        DruidRel druidRel = (DruidRel)planner.transform(0, planner.getEmptyTraitSet().replace((RelTrait)DruidConvention.instance()).plus((RelTrait)this.rootQueryRel.collation), parameterized);
        this.handlerContext.hook().captureDruidRel(druidRel);
        plannerContext.dispatchHook(DruidHook.DRUID_PLAN, druidRel);
        if (this.explain != null) {
            return this.planExplanation(possiblyLimitedRoot, (RelNode)druidRel, true);
        }
        Set readResourceActions = plannerContext.getResourceActions().stream().filter(action -> action.getAction() == Action.READ).collect(Collectors.toSet());
        Preconditions.checkState((readResourceActions.isEmpty() == druidRel.getDataSourceNames().isEmpty() || readResourceActions.size() >= druidRel.getDataSourceNames().size() ? 1 : 0) != 0, (Object)"Authorization sanity check failed");
        return new PlannerResult((Supplier<QueryResponse<Object[]>>)((Supplier)druidRel::runQuery), rowType);
    }

    @Nullable
    private RelRoot possiblyWrapRootWithOuterLimitFromContext(RelRoot root) {
        LogicalSort newRootRel;
        Long outerLimit = this.handlerContext.queryContext().getLong("sqlOuterLimit");
        if (outerLimit == null) {
            return root;
        }
        if (root.rel instanceof Sort) {
            Sort sort = (Sort)root.rel;
            OffsetLimit originalOffsetLimit = OffsetLimit.fromSort(sort);
            OffsetLimit newOffsetLimit = originalOffsetLimit.andThen(new OffsetLimit(0L, outerLimit));
            if (newOffsetLimit.equals(originalOffsetLimit)) {
                return root;
            }
            newRootRel = LogicalSort.create((RelNode)sort.getInput(), (RelCollation)sort.collation, (RexNode)newOffsetLimit.getOffsetAsRexNode(this.rexBuilder), (RexNode)newOffsetLimit.getLimitAsRexNode(this.rexBuilder));
        } else {
            newRootRel = LogicalSort.create((RelNode)root.rel, (RelCollation)root.collation, null, (RexNode)new OffsetLimit(0L, outerLimit).getLimitAsRexNode(this.rexBuilder));
        }
        return new RelRoot((RelNode)newRootRel, root.validatedRowType, root.kind, (Iterable)root.fields, root.collation, (List)root.hints);
    }

    protected abstract QueryMaker buildQueryMaker(RelRoot var1) throws ValidationException;

    private DruidException buildSQLPlanningError(RelOptPlanner.CannotPlanException exception) {
        String errorMessage = this.handlerContext.plannerContext().getPlanningError();
        if (errorMessage == null) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.UNSUPPORTED).build((Throwable)exception, "Unhandled Query Planning Failure, see broker logs for details", new Object[0]);
        }
        throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.INVALID_INPUT).build((Throwable)exception, "Query could not be planned. A possible reason is [%s]", new Object[]{errorMessage});
    }

    private static class EnumeratorIterator<T>
    implements Iterator<T> {
        private final Iterator<T> it;

        EnumeratorIterator(Iterator<T> it) {
            this.it = it;
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return this.it.next();
        }
    }

    public static class SelectHandler
    extends QueryHandler {
        private final SqlNode queryNode;
        private SqlNode validatedQueryNode;

        public SelectHandler(SqlStatementHandler.HandlerContext handlerContext, SqlNode sqlNode, SqlExplain explain) {
            super(handlerContext, explain);
            this.queryNode = sqlNode;
        }

        @Override
        public void validate() {
            if (!this.handlerContext.plannerContext().featureAvailable(EngineFeature.CAN_SELECT)) {
                throw InvalidSqlInput.exception((String)"Cannot execute SELECT with SQL engine [%s]", (Object[])new Object[]{this.handlerContext.engine().name()});
            }
            this.validatedQueryNode = this.validate(this.queryNode);
        }

        @Override
        protected SqlNode validatedQueryNode() {
            return this.validatedQueryNode;
        }

        @Override
        protected RelDataType returnedRowType() {
            RelDataTypeFactory typeFactory = this.rootQueryRel.rel.getCluster().getTypeFactory();
            return this.handlerContext.engine().resultTypeForSelect(typeFactory, this.rootQueryRel.validatedRowType, this.handlerContext.plannerContext().queryContextMap());
        }

        @Override
        protected PlannerResult planForDruid() throws ValidationException {
            return this.planWithDruidConvention();
        }

        @Override
        protected QueryMaker buildQueryMaker(RelRoot rootQueryRel) throws ValidationException {
            return this.handlerContext.engine().buildQueryMakerForSelect(rootQueryRel, this.handlerContext.plannerContext());
        }
    }
}

