/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.planner;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableMap;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.annotation.Nullable;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.avatica.remote.TypedValue;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.java.util.common.DateTimes;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Numbers;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.math.expr.Expr;
import org.apache.druid.math.expr.ExprMacroTable;
import org.apache.druid.query.JoinAlgorithm;
import org.apache.druid.query.QueryContext;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.query.explain.ExplainAttributes;
import org.apache.druid.query.lookup.LookupExtractor;
import org.apache.druid.query.lookup.LookupExtractorFactoryContainerProvider;
import org.apache.druid.segment.join.JoinableFactoryWrapper;
import org.apache.druid.server.lookup.cache.LookupLoadingSpec;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.calcite.expression.SqlOperatorConversion;
import org.apache.druid.sql.calcite.expression.builtin.QueryLookupOperatorConversion;
import org.apache.druid.sql.calcite.planner.ExpressionParser;
import org.apache.druid.sql.calcite.planner.ExpressionParserImpl;
import org.apache.druid.sql.calcite.planner.NoOpPlannerHook;
import org.apache.druid.sql.calcite.planner.PlannerConfig;
import org.apache.druid.sql.calcite.planner.PlannerHook;
import org.apache.druid.sql.calcite.planner.PlannerLookupCache;
import org.apache.druid.sql.calcite.planner.PlannerToolbox;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.run.EngineFeature;
import org.apache.druid.sql.calcite.run.QueryMaker;
import org.apache.druid.sql.calcite.run.SqlEngine;
import org.apache.druid.sql.hook.DruidHook;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;
import org.joda.time.Interval;
import org.joda.time.ReadableInstant;

public class PlannerContext {
    public static final String CTX_SQL_CURRENT_TIMESTAMP = "sqlCurrentTimestamp";
    public static final String CTX_SQL_TIME_ZONE = "sqlTimeZone";
    public static final String CTX_SQL_JOIN_ALGORITHM = "sqlJoinAlgorithm";
    private static final JoinAlgorithm DEFAULT_SQL_JOIN_ALGORITHM = JoinAlgorithm.BROADCAST;
    public static final String CTX_SQL_OUTER_LIMIT = "sqlOuterLimit";
    public static final String CTX_ENABLE_RAC_TRANSFER_OVER_WIRE = "enableRACOverWire";
    public static final String CTX_SQL_USE_BOUNDS_AND_SELECTORS = "sqlUseBoundAndSelectors";
    public static final boolean DEFAULT_SQL_USE_BOUNDS_AND_SELECTORS = false;
    public static final String CTX_SQL_PULL_UP_LOOKUP = "sqlPullUpLookup";
    public static final boolean DEFAULT_SQL_PULL_UP_LOOKUP = true;
    public static final String CTX_SQL_REVERSE_LOOKUP = "sqlReverseLookup";
    public static final boolean DEFAULT_SQL_REVERSE_LOOKUP = true;
    public static final String CTX_SQL_USE_GRANULARITY = "sqlUseGranularity";
    public static final boolean DEFAULT_SQL_USE_GRANULARITY = true;
    public static final String DATA_CTX_AUTHENTICATION_RESULT = "authenticationResult";
    private final PlannerToolbox plannerToolbox;
    private final ExpressionParser expressionParser;
    private final String sql;
    private final SqlNode sqlNode;
    private final SqlEngine engine;
    private final Map<String, Object> queryContext;
    private final CopyOnWriteArrayList<String> nativeQueryIds = new CopyOnWriteArrayList();
    private final PlannerHook hook;
    private final Set<String> lookupsToLoad = new HashSet<String>();
    private PlannerConfig plannerConfig;
    private String sqlQueryId;
    private boolean stringifyArrays;
    private boolean useBoundsAndSelectors;
    private boolean pullUpLookup;
    private boolean reverseLookup;
    private boolean useGranularity;
    private DateTime localNow;
    private List<TypedValue> parameters = Collections.emptyList();
    private AuthenticationResult authenticationResult;
    private Set<ResourceAction> resourceActions;
    private AuthorizationResult authorizationResult;
    @Nullable
    private String planningError;
    private QueryMaker queryMaker;
    private VirtualColumnRegistry joinExpressionVirtualColumnRegistry;
    private ExplainAttributes explainAttributes;
    private PlannerLookupCache lookupCache;

    private PlannerContext(PlannerToolbox plannerToolbox, String sql, SqlNode sqlNode, SqlEngine engine, Map<String, Object> queryContext, PlannerHook hook) {
        this.plannerToolbox = plannerToolbox;
        this.expressionParser = new ExpressionParserImpl(plannerToolbox.exprMacroTable());
        this.sql = sql;
        this.sqlNode = sqlNode;
        this.engine = engine;
        this.queryContext = new LinkedHashMap<String, Object>(queryContext);
        this.hook = hook == null ? NoOpPlannerHook.INSTANCE : hook;
        this.initializeContextFieldsAndPlannerConfig();
    }

    public static PlannerContext create(PlannerToolbox plannerToolbox, String sql, SqlNode sqlNode, SqlEngine engine, Map<String, Object> queryContext, PlannerHook hook) {
        return new PlannerContext(plannerToolbox, sql, sqlNode, engine, queryContext, hook);
    }

    public static JoinAlgorithm getJoinAlgorithm(QueryContext queryContext) {
        return PlannerContext.getJoinAlgorithmFromContextValue(queryContext.get(CTX_SQL_JOIN_ALGORITHM));
    }

    public static JoinAlgorithm getJoinAlgorithm(Map<String, Object> queryContext) {
        return PlannerContext.getJoinAlgorithmFromContextValue(queryContext.get(CTX_SQL_JOIN_ALGORITHM));
    }

    private static JoinAlgorithm getJoinAlgorithmFromContextValue(Object object) {
        String s = QueryContexts.getAsString((String)CTX_SQL_JOIN_ALGORITHM, (Object)object, (String)DEFAULT_SQL_JOIN_ALGORITHM.toString());
        try {
            return JoinAlgorithm.fromString((String)s);
        }
        catch (IllegalArgumentException e) {
            throw QueryContexts.badValueException((String)CTX_SQL_JOIN_ALGORITHM, (String)StringUtils.format((String)"one of %s", (Object[])new Object[]{Arrays.toString(JoinAlgorithm.values())}), (Object)object);
        }
    }

    public PlannerToolbox getPlannerToolbox() {
        return this.plannerToolbox;
    }

    public ExprMacroTable getExprMacroTable() {
        return this.plannerToolbox.exprMacroTable();
    }

    public ExpressionParser getExpressionParser() {
        return this.expressionParser;
    }

    public Expr parseExpression(String expr) {
        return this.expressionParser.parse(expr);
    }

    public ObjectMapper getJsonMapper() {
        return this.plannerToolbox.jsonMapper();
    }

    public PlannerConfig getPlannerConfig() {
        return this.plannerConfig;
    }

    public DateTime getLocalNow() {
        return this.localNow;
    }

    public DateTimeZone getTimeZone() {
        return this.localNow.getZone();
    }

    public JoinableFactoryWrapper getJoinableFactoryWrapper() {
        return this.plannerToolbox.joinableFactoryWrapper();
    }

    @Nullable
    public String getSchemaResourceType(String schema, String resourceName) {
        return this.plannerToolbox.rootSchema().getResourceType(schema, resourceName);
    }

    public void addLookupToLoad(String lookupName) {
        this.lookupsToLoad.add(lookupName);
    }

    public LookupLoadingSpec getLookupLoadingSpec() {
        return this.lookupsToLoad.isEmpty() ? LookupLoadingSpec.NONE : LookupLoadingSpec.loadOnly(this.lookupsToLoad);
    }

    public Map<String, Object> queryContextMap() {
        return this.queryContext;
    }

    public QueryContext queryContext() {
        return QueryContext.of(this.queryContext);
    }

    public boolean isStringifyArrays() {
        return this.stringifyArrays;
    }

    public boolean isUseBoundsAndSelectors() {
        return this.useBoundsAndSelectors;
    }

    public boolean isUseLegacyInFilter() {
        return this.useBoundsAndSelectors;
    }

    public boolean isPullUpLookup() {
        return this.pullUpLookup;
    }

    public boolean isReverseLookup() {
        return this.reverseLookup;
    }

    public boolean isUseGranularity() {
        return this.useGranularity;
    }

    public List<TypedValue> getParameters() {
        return this.parameters;
    }

    public AuthenticationResult getAuthenticationResult() {
        return (AuthenticationResult)Preconditions.checkNotNull((Object)this.authenticationResult, (Object)"Authentication result not available");
    }

    public JoinAlgorithm getJoinAlgorithm() {
        return PlannerContext.getJoinAlgorithm(this.queryContext);
    }

    public String getSql() {
        return this.sql;
    }

    public SqlNode getSqlNode() {
        return this.sqlNode;
    }

    public PlannerHook getPlannerHook() {
        return this.hook;
    }

    public String getSqlQueryId() {
        return this.sqlQueryId;
    }

    public CopyOnWriteArrayList<String> getNativeQueryIds() {
        return this.nativeQueryIds;
    }

    public void addNativeQueryId(String queryId) {
        this.nativeQueryIds.add(queryId);
    }

    @Nullable
    public String getPlanningError() {
        return this.planningError;
    }

    public void setPlanningError(String formatText, Object ... arguments) {
        if (this.queryContext().isDecoupledMode()) {
            throw InvalidSqlInput.exception((String)formatText, (Object[])arguments);
        }
        this.planningError = StringUtils.nonStrictFormat((String)formatText, (Object[])arguments);
    }

    public DataContext createDataContext(final JavaTypeFactory typeFactory, final List<TypedValue> parameters) {
        class DruidDataContext
        implements DataContext {
            private final Map<String, Object> base_context;
            private final Map<String, Object> context;

            DruidDataContext() {
                this.base_context = ImmutableMap.of((Object)DataContext.Variable.UTC_TIMESTAMP.camelName, (Object)PlannerContext.this.localNow.getMillis(), (Object)DataContext.Variable.CURRENT_TIMESTAMP.camelName, (Object)PlannerContext.this.localNow.getMillis(), (Object)DataContext.Variable.LOCAL_TIMESTAMP.camelName, (Object)new Interval((ReadableInstant)new DateTime((Object)"1970-01-01T00:00:00.000", PlannerContext.this.localNow.getZone()), (ReadableInstant)PlannerContext.this.localNow).toDurationMillis(), (Object)DataContext.Variable.TIME_ZONE.camelName, (Object)PlannerContext.this.localNow.getZone().toTimeZone().clone());
                ImmutableMap.Builder builder = ImmutableMap.builder();
                builder.putAll(this.base_context);
                int i = 0;
                for (TypedValue parameter : parameters) {
                    builder.put((Object)("?" + i), parameter.value);
                    ++i;
                }
                if (PlannerContext.this.authenticationResult != null) {
                    builder.put((Object)PlannerContext.DATA_CTX_AUTHENTICATION_RESULT, (Object)PlannerContext.this.authenticationResult);
                }
                this.context = builder.build();
            }

            public SchemaPlus getRootSchema() {
                throw new UnsupportedOperationException();
            }

            public JavaTypeFactory getTypeFactory() {
                return typeFactory;
            }

            public QueryProvider getQueryProvider() {
                throw new UnsupportedOperationException();
            }

            public Object get(String name) {
                return this.context.get(name);
            }
        }
        return new DruidDataContext();
    }

    public AuthorizationResult getAuthorizationResult() {
        return (AuthorizationResult)Preconditions.checkNotNull((Object)this.authorizationResult, (Object)"Authorization result not available");
    }

    public void setParameters(List<TypedValue> parameters) {
        this.parameters = (List)Preconditions.checkNotNull(parameters, (Object)"parameters");
    }

    public void setAuthenticationResult(AuthenticationResult authenticationResult) {
        if (this.authenticationResult != null) {
            throw new ISE("Authentication result has already been set", new Object[0]);
        }
        this.authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)authenticationResult, (Object)DATA_CTX_AUTHENTICATION_RESULT);
    }

    public void setAuthorizationResult(AuthorizationResult access) {
        if (this.authorizationResult != null) {
            throw new ISE("Authorization result has already been set", new Object[0]);
        }
        this.authorizationResult = (AuthorizationResult)Preconditions.checkNotNull((Object)access, (Object)"authorizationResult");
    }

    public Set<ResourceAction> getResourceActions() {
        return (Set)Preconditions.checkNotNull(this.resourceActions, (Object)"Resources not available");
    }

    public void setResourceActions(Set<ResourceAction> resourceActions) {
        if (this.resourceActions != null) {
            throw new ISE("Resources have already been set", new Object[0]);
        }
        this.resourceActions = (Set)Preconditions.checkNotNull(resourceActions, (Object)"resourceActions");
    }

    public void setQueryMaker(QueryMaker queryMaker) {
        if (this.queryMaker != null) {
            throw new ISE("QueryMaker has already been set", new Object[0]);
        }
        this.queryMaker = (QueryMaker)Preconditions.checkNotNull((Object)queryMaker, (Object)"queryMaker");
    }

    public void addAllToQueryContext(Map<String, Object> toAdd) {
        this.queryContext.putAll(toAdd);
        this.initializeContextFieldsAndPlannerConfig();
    }

    public SqlEngine getEngine() {
        return this.engine;
    }

    public boolean featureAvailable(EngineFeature feature) {
        if (feature == EngineFeature.TIME_BOUNDARY_QUERY && !this.queryContext().isTimeBoundaryPlanningEnabled()) {
            return false;
        }
        return this.engine.featureAvailable(feature);
    }

    public QueryMaker getQueryMaker() {
        return (QueryMaker)Preconditions.checkNotNull((Object)this.queryMaker, (Object)"QueryMaker not available");
    }

    public VirtualColumnRegistry getJoinExpressionVirtualColumnRegistry() {
        return this.joinExpressionVirtualColumnRegistry;
    }

    public void setJoinExpressionVirtualColumnRegistry(VirtualColumnRegistry joinExpressionVirtualColumnRegistry) {
        this.joinExpressionVirtualColumnRegistry = joinExpressionVirtualColumnRegistry;
    }

    public ExplainAttributes getExplainAttributes() {
        return this.explainAttributes;
    }

    public void setExplainAttributes(ExplainAttributes explainAttributes) {
        if (this.explainAttributes != null) {
            throw new ISE("ExplainAttributes has already been set", new Object[0]);
        }
        this.explainAttributes = explainAttributes;
    }

    public LookupExtractor getLookup(String lookupName) {
        if (this.lookupCache == null) {
            SqlOperatorConversion lookupOperatorConversion = this.plannerToolbox.operatorTable().lookupOperatorConversion((SqlOperator)QueryLookupOperatorConversion.SQL_FUNCTION);
            if (lookupOperatorConversion != null) {
                LookupExtractorFactoryContainerProvider lookupProvider = ((QueryLookupOperatorConversion)lookupOperatorConversion).getLookupExtractorFactoryContainerProvider();
                this.lookupCache = new PlannerLookupCache(lookupProvider);
            } else {
                this.lookupCache = new PlannerLookupCache(null);
            }
        }
        return this.lookupCache.getLookup(lookupName);
    }

    public <T> void dispatchHook(DruidHook.HookKey<T> key, T object) {
        this.plannerToolbox.getHookDispatcher().dispatch(key, object);
    }

    private void initializeContextFieldsAndPlannerConfig() {
        Object tsParam = this.queryContext.get(CTX_SQL_CURRENT_TIMESTAMP);
        DateTime utcNow = tsParam != null ? new DateTime(tsParam, DateTimeZone.UTC) : new DateTime(DateTimeZone.UTC);
        Object tzParam = this.queryContext.get(CTX_SQL_TIME_ZONE);
        DateTimeZone timeZone = tzParam != null ? DateTimes.inferTzFromString((String)String.valueOf(tzParam)) : this.plannerToolbox.plannerConfig().getSqlTimeZone();
        this.localNow = utcNow.withZone(timeZone);
        Object stringifyParam = this.queryContext.get("sqlStringifyArrays");
        this.stringifyArrays = stringifyParam != null ? Numbers.parseBoolean((Object)stringifyParam) : true;
        Object useBoundsAndSelectorsParam = this.queryContext.get(CTX_SQL_USE_BOUNDS_AND_SELECTORS);
        this.useBoundsAndSelectors = useBoundsAndSelectorsParam != null ? Numbers.parseBoolean((Object)useBoundsAndSelectorsParam) : false;
        Object pullUpLookupParam = this.queryContext.get(CTX_SQL_PULL_UP_LOOKUP);
        this.pullUpLookup = pullUpLookupParam != null ? Numbers.parseBoolean((Object)pullUpLookupParam) : true;
        Object reverseLookupParam = this.queryContext.get(CTX_SQL_REVERSE_LOOKUP);
        this.reverseLookup = reverseLookupParam != null ? Numbers.parseBoolean((Object)reverseLookupParam) : true;
        Object useGranularityParam = this.queryContext.get(CTX_SQL_USE_GRANULARITY);
        this.useGranularity = useGranularityParam != null ? Numbers.parseBoolean((Object)useGranularityParam) : true;
        this.sqlQueryId = (String)this.queryContext.get("sqlQueryId");
        if (Strings.isNullOrEmpty((String)this.sqlQueryId)) {
            this.sqlQueryId = UUID.randomUUID().toString();
            this.queryContext.put("sqlQueryId", UUID.randomUUID().toString());
        }
        this.plannerConfig = this.plannerConfig != null ? this.plannerConfig.withOverrides(this.queryContext) : this.getPlannerToolbox().plannerConfig.withOverrides(this.queryContext);
    }
}

