/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.aggregation.builtin;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlOperatorBinding;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.type.InferTypes;
import org.apache.calcite.sql.type.SqlOperandTypeChecker;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.sql.util.SqlVisitor;
import org.apache.calcite.sql.validate.SqlValidator;
import org.apache.calcite.sql.validate.SqlValidatorException;
import org.apache.calcite.util.Optionality;
import org.apache.druid.error.DruidException;
import org.apache.druid.error.InvalidSqlInput;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.query.aggregation.PostAggregator;
import org.apache.druid.query.aggregation.any.DoubleAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.FloatAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.LongAnyAggregatorFactory;
import org.apache.druid.query.aggregation.any.StringAnyAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.DoubleFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.FloatFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.LongFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.first.StringFirstAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.DoubleLastAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.FloatLastAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.LongLastAggregatorFactory;
import org.apache.druid.query.aggregation.firstlast.last.StringLastAggregatorFactory;
import org.apache.druid.query.aggregation.post.FinalizingFieldAccessPostAggregator;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.ValueType;
import org.apache.druid.sql.calcite.aggregation.Aggregation;
import org.apache.druid.sql.calcite.aggregation.SqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.EarliestLatestBySqlAggregator;
import org.apache.druid.sql.calcite.aggregation.builtin.SimpleSqlAggregator;
import org.apache.druid.sql.calcite.expression.DefaultOperandTypeChecker;
import org.apache.druid.sql.calcite.expression.DruidExpression;
import org.apache.druid.sql.calcite.expression.Expressions;
import org.apache.druid.sql.calcite.planner.Calcites;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.rel.InputAccessor;
import org.apache.druid.sql.calcite.rel.VirtualColumnRegistry;
import org.apache.druid.sql.calcite.table.RowSignatures;

public class EarliestLatestAnySqlAggregator
implements SqlAggregator {
    public static final SqlAggregator EARLIEST = new EarliestLatestAnySqlAggregator(AggregatorType.EARLIEST, EarliestLatestBySqlAggregator.EARLIEST_BY.calciteFunction());
    public static final SqlAggregator LATEST = new EarliestLatestAnySqlAggregator(AggregatorType.LATEST, EarliestLatestBySqlAggregator.LATEST_BY.calciteFunction());
    public static final SqlAggregator ANY_VALUE = new EarliestLatestAnySqlAggregator(AggregatorType.ANY_VALUE, null);
    private final AggregatorType aggregatorType;
    private final SqlAggFunction function;

    private EarliestLatestAnySqlAggregator(AggregatorType aggregatorType, SqlAggFunction replacementAggFunc) {
        this.aggregatorType = aggregatorType;
        this.function = new EarliestLatestSqlAggFunction(aggregatorType, replacementAggFunc);
    }

    @Override
    public SqlAggFunction calciteFunction() {
        return this.function;
    }

    @Override
    @Nullable
    public Aggregation toDruidAggregation(PlannerContext plannerContext, VirtualColumnRegistry virtualColumnRegistry, String name, AggregateCall aggregateCall, InputAccessor inputAccessor, List<Aggregation> existingAggregations, boolean finalizeAggregations) {
        AggregatorFactory theAggFactory;
        List<RexNode> rexNodes = inputAccessor.getFields(aggregateCall.getArgList());
        List<DruidExpression> args = Expressions.toDruidExpressions(plannerContext, inputAccessor.getInputRowSignature(), rexNodes);
        if (args == null) {
            return null;
        }
        String aggregatorName = finalizeAggregations ? Calcites.makePrefixedName(name, "a") : name;
        ColumnType outputType = Calcites.getColumnTypeForRelDataType(aggregateCall.getType());
        if (outputType == null) {
            throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.ADMIN).ofCategory(DruidException.Category.DEFENSIVE).build("Cannot convert output SQL type[%s] to a Druid type for function [%s]", new Object[]{aggregateCall.getName(), aggregateCall.getType().getSqlTypeName()});
        }
        String fieldName = EarliestLatestAnySqlAggregator.getColumnName(virtualColumnRegistry, args.get(0), rexNodes.get(0));
        if (!(inputAccessor.getInputRowSignature().contains("__time") || this.aggregatorType != AggregatorType.LATEST && this.aggregatorType != AggregatorType.EARLIEST)) {
            plannerContext.setPlanningError("LATEST and EARLIEST aggregators implicitly depend on the __time column, but the table queried doesn't contain a __time column.  Please use LATEST_BY or EARLIEST_BY and specify the column explicitly.", new Object[0]);
            return null;
        }
        switch (args.size()) {
            case 1: {
                theAggFactory = this.aggregatorType.createAggregatorFactory(aggregatorName, fieldName, null, outputType, null, true);
                break;
            }
            case 2: {
                Integer maxStringBytes = RexLiteral.intValue((RexNode)rexNodes.get(1));
                theAggFactory = this.aggregatorType.createAggregatorFactory(aggregatorName, fieldName, null, outputType, (int)maxStringBytes, true);
                break;
            }
            case 3: {
                Integer maxStringBytes = RexLiteral.intValue((RexNode)rexNodes.get(1));
                boolean aggregateMultipleValues = RexLiteral.booleanValue((RexNode)rexNodes.get(2));
                theAggFactory = this.aggregatorType.createAggregatorFactory(aggregatorName, fieldName, null, outputType, maxStringBytes, aggregateMultipleValues);
                break;
            }
            default: {
                throw InvalidSqlInput.exception((String)"Function [%s] expects 1 or 2 or 3 arguments but found [%s]", (Object[])new Object[]{aggregateCall.getName(), args.size()});
            }
        }
        return Aggregation.create(Collections.singletonList(theAggFactory), (PostAggregator)(finalizeAggregations ? new FinalizingFieldAccessPostAggregator(name, aggregatorName) : null));
    }

    static String getColumnName(VirtualColumnRegistry virtualColumnRegistry, DruidExpression arg, RexNode rexNode) {
        String columnName;
        if (arg.isDirectColumnAccess()) {
            columnName = arg.getDirectColumn();
        } else {
            RelDataType dataType = rexNode.getType();
            columnName = virtualColumnRegistry.getOrCreateVirtualColumnForExpression(arg, dataType);
        }
        return columnName;
    }

    static enum AggregatorType {
        EARLIEST{

            @Override
            AggregatorFactory createAggregatorFactory(String name, String fieldName, String timeColumn, ColumnType type, Integer maxStringBytes, Boolean aggregateMultipleValues) {
                switch ((ValueType)type.getType()) {
                    case LONG: {
                        return new LongFirstAggregatorFactory(name, fieldName, timeColumn);
                    }
                    case FLOAT: {
                        return new FloatFirstAggregatorFactory(name, fieldName, timeColumn);
                    }
                    case DOUBLE: {
                        return new DoubleFirstAggregatorFactory(name, fieldName, timeColumn);
                    }
                    case STRING: 
                    case COMPLEX: {
                        return new StringFirstAggregatorFactory(name, fieldName, timeColumn, maxStringBytes);
                    }
                }
                throw SimpleSqlAggregator.badTypeException(fieldName, "EARLIEST", type);
            }
        }
        ,
        LATEST{

            @Override
            AggregatorFactory createAggregatorFactory(String name, String fieldName, String timeColumn, ColumnType type, Integer maxStringBytes, Boolean aggregateMultipleValues) {
                switch ((ValueType)type.getType()) {
                    case LONG: {
                        return new LongLastAggregatorFactory(name, fieldName, timeColumn);
                    }
                    case FLOAT: {
                        return new FloatLastAggregatorFactory(name, fieldName, timeColumn);
                    }
                    case DOUBLE: {
                        return new DoubleLastAggregatorFactory(name, fieldName, timeColumn);
                    }
                    case STRING: 
                    case COMPLEX: {
                        return new StringLastAggregatorFactory(name, fieldName, timeColumn, maxStringBytes);
                    }
                }
                throw SimpleSqlAggregator.badTypeException(fieldName, "LATEST", type);
            }
        }
        ,
        ANY_VALUE{

            @Override
            AggregatorFactory createAggregatorFactory(String name, String fieldName, String timeColumn, ColumnType type, Integer maxStringBytes, Boolean aggregateMultipleValues) {
                switch ((ValueType)type.getType()) {
                    case LONG: {
                        return new LongAnyAggregatorFactory(name, fieldName);
                    }
                    case FLOAT: {
                        return new FloatAnyAggregatorFactory(name, fieldName);
                    }
                    case DOUBLE: {
                        return new DoubleAnyAggregatorFactory(name, fieldName);
                    }
                    case STRING: {
                        return new StringAnyAggregatorFactory(name, fieldName, maxStringBytes, aggregateMultipleValues);
                    }
                }
                throw SimpleSqlAggregator.badTypeException(fieldName, "ANY", type);
            }
        };


        abstract AggregatorFactory createAggregatorFactory(String var1, String var2, String var3, ColumnType var4, Integer var5, Boolean var6);
    }

    private static class EarliestLatestSqlAggFunction
    extends SqlAggFunction {
        private static final EarliestLatestReturnTypeInference EARLIEST_LATEST_ARG0_RETURN_TYPE_INFERENCE = new EarliestLatestReturnTypeInference(0);
        private final SqlAggFunction replacementAggFunc;

        EarliestLatestSqlAggFunction(AggregatorType aggregatorType, SqlAggFunction replacementAggFunc) {
            super(aggregatorType.name(), null, SqlKind.OTHER_FUNCTION, (SqlReturnTypeInference)EARLIEST_LATEST_ARG0_RETURN_TYPE_INFERENCE, InferTypes.RETURN_TYPE, (SqlOperandTypeChecker)DefaultOperandTypeChecker.builder().operandNames("expr", "maxBytesPerStringInt", "aggregateMultipleValuesBoolean").operandTypes(SqlTypeFamily.ANY, SqlTypeFamily.NUMERIC, SqlTypeFamily.BOOLEAN).requiredOperandCount(1).literalOperands(1, 2).notNullOperands(1, 2).build(), SqlFunctionCategory.USER_DEFINED_FUNCTION, false, false, Optionality.FORBIDDEN);
            this.replacementAggFunc = replacementAggFunc;
        }

        public SqlNode rewriteCall(SqlValidator validator, SqlCall call) {
            if (this.replacementAggFunc == null) {
                return call;
            }
            List operands = call.getOperandList();
            SqlParserPos pos = call.getParserPosition();
            if (operands.isEmpty() || operands.size() > 3) {
                throw InvalidSqlInput.exception((String)"Function [%s] expects 1 or 2 or 3 arguments but found [%s]", (Object[])new Object[]{this.getName(), operands.size()});
            }
            ArrayList<Object> newOperands = new ArrayList<Object>();
            newOperands.add((SqlNode)operands.get(0));
            newOperands.add((Object)new TimeColIdentifer());
            if (operands.size() == 2) {
                newOperands.add((SqlNode)operands.get(1));
            }
            if (operands.size() == 3) {
                newOperands.add((SqlNode)operands.get(2));
            }
            return this.replacementAggFunc.createCall(pos, newOperands);
        }
    }

    private static class TimeColIdentifer
    extends SqlIdentifier {
        public TimeColIdentifer() {
            super("__time", SqlParserPos.ZERO);
        }

        public <R> R accept(SqlVisitor<R> visitor) {
            try {
                return (R)super.accept(visitor);
            }
            catch (CalciteContextException e) {
                if (e.getCause() instanceof SqlValidatorException) {
                    throw DruidException.forPersona((DruidException.Persona)DruidException.Persona.ADMIN).ofCategory(DruidException.Category.INVALID_INPUT).build((Throwable)e, "Query could not be planned. A possible reason is [%s]", new Object[]{"LATEST and EARLIEST aggregators implicitly depend on the __time column, but the table queried doesn't contain a __time column.  Please use LATEST_BY or EARLIEST_BY and specify the column explicitly."});
                }
                throw e;
            }
        }
    }

    static class EarliestLatestReturnTypeInference
    implements SqlReturnTypeInference {
        private final int ordinal;

        public EarliestLatestReturnTypeInference(int ordinal) {
            this.ordinal = ordinal;
        }

        public RelDataType inferReturnType(SqlOperatorBinding sqlOperatorBinding) {
            ColumnType complexColumnType;
            String complexTypeName;
            RelDataType type = sqlOperatorBinding.getOperandType(this.ordinal);
            if (type instanceof RowSignatures.ComplexSqlType && (complexTypeName = (complexColumnType = ((RowSignatures.ComplexSqlType)type).getColumnType()).getComplexTypeName()) != null) {
                switch (complexTypeName) {
                    case "serializablePairLongLong": {
                        return sqlOperatorBinding.getTypeFactory().createSqlType(SqlTypeName.BIGINT);
                    }
                    case "serializablePairLongFloat": {
                        return sqlOperatorBinding.getTypeFactory().createSqlType(SqlTypeName.FLOAT);
                    }
                    case "serializablePairLongDouble": {
                        return sqlOperatorBinding.getTypeFactory().createSqlType(SqlTypeName.DOUBLE);
                    }
                }
                return sqlOperatorBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
            }
            if (!SqlTypeUtil.isNumeric((RelDataType)type) && !SqlTypeUtil.isString((RelDataType)type)) {
                return sqlOperatorBinding.getTypeFactory().createSqlType(SqlTypeName.VARCHAR);
            }
            return type;
        }
    }
}

