/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.hook;

import com.google.inject.Inject;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.druid.guice.LazySingleton;
import org.apache.druid.sql.hook.DruidHook;

@LazySingleton
public class DruidHookDispatcher {
    Map<DruidHook.HookKey<?>, List<DruidHook<?>>> hooks = new HashMap();

    @Inject
    public DruidHookDispatcher() {
    }

    public void register(DruidHook.HookKey<?> label, DruidHook<?> hook) {
        this.hooks.computeIfAbsent(label, k -> new ArrayList()).add(hook);
    }

    public void unregister(DruidHook.HookKey<?> key, DruidHook<?> hook) {
        this.hooks.get(key).remove(hook);
    }

    public <T> Closeable withHook(final DruidHook.HookKey<T> key, final DruidHook<T> hook) {
        this.register(key, hook);
        return new Closeable(){

            @Override
            public void close() {
                DruidHookDispatcher.this.unregister(key, hook);
            }
        };
    }

    public <T> void dispatch(DruidHook.HookKey<T> key, T object) {
        List<DruidHook<?>> currentHooks = this.hooks.get(key);
        if (currentHooks != null) {
            for (DruidHook<?> hook : currentHooks) {
                hook.invoke(key, object);
            }
        }
    }
}

