/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql;

import java.io.Closeable;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.QueryContexts;
import org.apache.druid.server.security.Action;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizationResult;
import org.apache.druid.server.security.AuthorizationUtils;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.server.security.ForbiddenException;
import org.apache.druid.server.security.Resource;
import org.apache.druid.server.security.ResourceAction;
import org.apache.druid.sql.SqlExecutionReporter;
import org.apache.druid.sql.SqlQueryPlus;
import org.apache.druid.sql.SqlToolbox;
import org.apache.druid.sql.calcite.planner.DruidPlanner;
import org.apache.druid.sql.calcite.planner.PlannerContext;
import org.apache.druid.sql.calcite.planner.PlannerHook;

public abstract class AbstractStatement
implements Closeable {
    private static final Logger log = new Logger(AbstractStatement.class);
    protected final SqlToolbox sqlToolbox;
    protected final SqlQueryPlus queryPlus;
    protected final SqlExecutionReporter reporter;
    protected final Map<String, Object> queryContext;
    protected PlannerContext plannerContext;
    protected DruidPlanner.AuthResult authResult;
    protected PlannerHook hook;

    public AbstractStatement(SqlToolbox sqlToolbox, SqlQueryPlus queryPlus, String remoteAddress) {
        this.sqlToolbox = sqlToolbox;
        this.reporter = new SqlExecutionReporter(this, remoteAddress);
        this.queryPlus = queryPlus;
        this.queryContext = new HashMap<String, Object>(queryPlus.context());
        if (this.queryContext.remove("bySegment") != null) {
            log.warn("'bySegment' results are not supported for SQL queries, ignoring query context parameter", new Object[0]);
        }
        this.queryContext.putIfAbsent("sqlQueryId", UUID.randomUUID().toString());
        for (Map.Entry entry : sqlToolbox.defaultQueryConfig.getContext().entrySet()) {
            this.queryContext.putIfAbsent((String)entry.getKey(), entry.getValue());
        }
    }

    public String sqlQueryId() {
        return QueryContexts.parseString(this.queryContext, (String)"sqlQueryId");
    }

    public Map<String, Object> context() {
        return this.queryContext;
    }

    public void setHook(PlannerHook hook) {
        this.hook = hook;
    }

    protected void validate(DruidPlanner planner) {
        this.plannerContext = planner.getPlannerContext();
        this.plannerContext.setAuthenticationResult(this.queryPlus.authResult());
        this.plannerContext.setParameters(this.queryPlus.parameters());
        planner.validate();
    }

    protected void authorize(DruidPlanner planner, Function<Set<ResourceAction>, AuthorizationResult> authorizer) {
        Set securedKeys = this.sqlToolbox.plannerFactory.getAuthConfig().contextKeysToAuthorize(this.queryPlus.context().keySet());
        HashSet<ResourceAction> contextResources = new HashSet<ResourceAction>();
        securedKeys.forEach(key -> contextResources.add(new ResourceAction(new Resource(key, "QUERY_CONTEXT"), Action.WRITE)));
        this.authResult = planner.authorize(authorizer, contextResources);
        if (!this.authResult.authorizationResult.allowBasicAccess()) {
            log.info("Query[%s] forbidden due to reason[%s]", new Object[]{this.sqlQueryId(), this.authResult.authorizationResult.getErrorMessage()});
            throw new ForbiddenException(this.authResult.authorizationResult.getErrorMessage());
        }
    }

    protected Function<Set<ResourceAction>, AuthorizationResult> authorizer() {
        return resourceActions -> AuthorizationUtils.authorizeAllResourceActions((AuthenticationResult)this.queryPlus.authResult(), (Iterable)resourceActions, (AuthorizerMapper)this.sqlToolbox.plannerFactory.getAuthorizerMapper());
    }

    public Set<ResourceAction> resources() {
        return Objects.requireNonNull(this.authResult.sqlResourceActions);
    }

    public Set<ResourceAction> allResources() {
        return Objects.requireNonNull(this.authResult.allResourceActions);
    }

    public SqlQueryPlus query() {
        return this.queryPlus;
    }

    public SqlExecutionReporter reporter() {
        return this.reporter;
    }

    @Override
    public void close() {
        try {
            this.closeQuietly();
        }
        catch (Exception e) {
            this.reporter.failed(e);
        }
        this.reporter.emit();
    }

    public void closeQuietly() {
    }

    public void closeWithError(Throwable e) {
        this.reporter.failed(e);
        this.close();
    }
}

