/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.rules;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.server.coordinator.rules.LoadRule;
import org.apache.druid.server.coordinator.rules.Rules;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.DateTime;
import org.joda.time.Interval;
import org.joda.time.Period;

public class PeriodLoadRule
extends LoadRule {
    private static final Logger log = new Logger(PeriodLoadRule.class);
    static final boolean DEFAULT_INCLUDE_FUTURE = true;
    private final Period period;
    private final boolean includeFuture;

    @JsonCreator
    public PeriodLoadRule(@JsonProperty(value="period") Period period, @JsonProperty(value="includeFuture") Boolean includeFuture, @JsonProperty(value="tieredReplicants") Map<String, Integer> tieredReplicants, @JsonProperty(value="useDefaultTierForNull") @Nullable Boolean useDefaultTierForNull) {
        super(tieredReplicants, useDefaultTierForNull);
        this.period = period;
        this.includeFuture = includeFuture == null ? true : includeFuture;
    }

    @Override
    @JsonProperty
    public String getType() {
        return "loadByPeriod";
    }

    @JsonProperty
    public Period getPeriod() {
        return this.period;
    }

    @JsonProperty
    public boolean isIncludeFuture() {
        return this.includeFuture;
    }

    @Override
    public boolean appliesTo(DataSegment segment, DateTime referenceTimestamp) {
        return this.appliesTo(segment.getInterval(), referenceTimestamp);
    }

    @Override
    public boolean appliesTo(Interval interval, DateTime referenceTimestamp) {
        return Rules.eligibleForLoad(this.period, interval, referenceTimestamp, this.includeFuture);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PeriodLoadRule that = (PeriodLoadRule)o;
        return this.includeFuture == that.includeFuture && Objects.equals(this.period, that.period);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.period, this.includeFuture);
    }
}

