/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.loading;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import org.apache.druid.server.coordinator.ServerHolder;
import org.apache.druid.server.coordinator.loading.SegmentAction;
import org.apache.druid.timeline.DataSegment;

public class SegmentStatusInTier {
    private final DataSegment segment;
    private final List<ServerHolder> eligibleLoadServers = new ArrayList<ServerHolder>();
    private final List<ServerHolder> eligibleDropServers = new ArrayList<ServerHolder>();
    private final Map<SegmentAction, List<ServerHolder>> serversWithQueuedActions = new HashMap<SegmentAction, List<ServerHolder>>();

    public SegmentStatusInTier(DataSegment segment, NavigableSet<ServerHolder> historicals) {
        this.segment = segment;
        historicals.forEach(this::handleServer);
    }

    public List<ServerHolder> getServersEligibleToLoad() {
        return this.eligibleLoadServers;
    }

    public List<ServerHolder> getServersEligibleToDrop() {
        return this.eligibleDropServers;
    }

    public List<ServerHolder> getServersPerforming(SegmentAction action) {
        return this.serversWithQueuedActions.getOrDefault((Object)action, Collections.emptyList());
    }

    private void handleServer(ServerHolder server) {
        SegmentAction action = server.getActionOnSegment(this.segment);
        if (server.isServingSegment(this.segment)) {
            this.eligibleDropServers.add(server);
        } else if (server.canLoadSegment(this.segment)) {
            this.eligibleLoadServers.add(server);
        } else if (action != null) {
            this.serversWithQueuedActions.computeIfAbsent(action, a -> new ArrayList()).add(server);
        }
    }
}

