/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordination;

import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.SettableFuture;
import com.google.inject.Inject;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nullable;
import org.apache.druid.client.BootstrapSegmentsResponse;
import org.apache.druid.client.coordinator.CoordinatorClient;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.guice.ManageLifecycle;
import org.apache.druid.guice.ServerTypeConfig;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.Stopwatch;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.common.lifecycle.LifecycleStart;
import org.apache.druid.java.util.common.lifecycle.LifecycleStop;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.segment.loading.SegmentLoaderConfig;
import org.apache.druid.segment.loading.SegmentLoadingException;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.coordination.BroadcastDatasourceLoadingSpec;
import org.apache.druid.server.coordination.DataSegmentAnnouncer;
import org.apache.druid.server.coordination.DataSegmentChangeCallback;
import org.apache.druid.server.coordination.DataSegmentServerAnnouncer;
import org.apache.druid.server.coordination.SegmentLoadDropHandler;
import org.apache.druid.server.metrics.LoadSpecHolder;
import org.apache.druid.timeline.DataSegment;

@ManageLifecycle
public class SegmentCacheBootstrapper {
    private final SegmentLoadDropHandler loadDropHandler;
    private final SegmentLoaderConfig config;
    private final DataSegmentAnnouncer segmentAnnouncer;
    private final DataSegmentServerAnnouncer serverAnnouncer;
    private final SegmentManager segmentManager;
    private final ServerTypeConfig serverTypeConfig;
    private final CoordinatorClient coordinatorClient;
    private final ServiceEmitter emitter;
    private final LoadSpecHolder loadSpecHolder;
    private volatile boolean isComplete = false;
    private final Object startStopLock = new Object();
    private static final EmittingLogger log = new EmittingLogger(SegmentCacheBootstrapper.class);

    @Inject
    public SegmentCacheBootstrapper(SegmentLoadDropHandler loadDropHandler, SegmentLoaderConfig config, DataSegmentAnnouncer segmentAnnouncer, DataSegmentServerAnnouncer serverAnnouncer, SegmentManager segmentManager, ServerTypeConfig serverTypeConfig, CoordinatorClient coordinatorClient, ServiceEmitter emitter, LoadSpecHolder loadSpecHolder) {
        this.loadDropHandler = loadDropHandler;
        this.config = config;
        this.segmentAnnouncer = segmentAnnouncer;
        this.serverAnnouncer = serverAnnouncer;
        this.segmentManager = segmentManager;
        this.serverTypeConfig = serverTypeConfig;
        this.coordinatorClient = coordinatorClient;
        this.emitter = emitter;
        this.loadSpecHolder = loadSpecHolder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStart
    public void start() throws IOException {
        Object object = this.startStopLock;
        synchronized (object) {
            if (this.isComplete) {
                return;
            }
            log.info("Starting...", new Object[0]);
            try {
                if (this.segmentManager.canHandleSegments()) {
                    this.loadSegmentsOnStartup();
                }
                if (this.shouldAnnounce()) {
                    this.serverAnnouncer.announce();
                }
            }
            catch (Exception e) {
                Throwables.propagateIfPossible((Throwable)e, IOException.class);
                throw new RuntimeException(e);
            }
            this.isComplete = true;
            log.info("Started.", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @LifecycleStop
    public void stop() {
        Object object = this.startStopLock;
        synchronized (object) {
            if (!this.isComplete) {
                return;
            }
            log.info("Stopping...", new Object[0]);
            try {
                if (this.shouldAnnounce()) {
                    this.serverAnnouncer.unannounce();
                }
                this.segmentManager.shutdown();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            finally {
                this.isComplete = false;
            }
            log.info("Stopped.", new Object[0]);
        }
    }

    public boolean isBootstrappingComplete() {
        return this.isComplete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSegmentsOnStartup() throws IOException {
        ArrayList<DataSegment> segmentsOnStartup = new ArrayList<DataSegment>();
        segmentsOnStartup.addAll(this.segmentManager.getCachedSegments());
        segmentsOnStartup.addAll(this.getBootstrapSegments());
        Stopwatch stopwatch = Stopwatch.createStarted();
        ExecutorService bootstrapExecutor = Execs.multiThreaded((int)this.config.getNumBootstrapThreads(), (String)"Segment-Bootstrap-%s");
        ScheduledExecutorService backgroundAnnouncerExecutor = Executors.newScheduledThreadPool(this.config.getNumLoadingThreads(), Execs.makeThreadFactory((String)"Background-Segment-Announcer-%s"));
        try {
            try (BackgroundSegmentAnnouncer backgroundSegmentAnnouncer = new BackgroundSegmentAnnouncer(this.segmentAnnouncer, backgroundAnnouncerExecutor, this.config.getAnnounceIntervalMillis());){
                backgroundSegmentAnnouncer.startAnnouncing();
                int numSegments = segmentsOnStartup.size();
                CountDownLatch latch = new CountDownLatch(numSegments);
                AtomicInteger counter = new AtomicInteger(0);
                ConcurrentLinkedQueue failedSegments = new ConcurrentLinkedQueue();
                for (DataSegment segment : segmentsOnStartup) {
                    bootstrapExecutor.submit(() -> {
                        try {
                            log.info("Loading segment[%d/%d][%s]", new Object[]{counter.incrementAndGet(), numSegments, segment.getId()});
                            try {
                                this.segmentManager.loadSegmentOnBootstrap(segment, () -> this.loadDropHandler.removeSegment(segment, DataSegmentChangeCallback.NOOP, false));
                            }
                            catch (Exception e) {
                                this.loadDropHandler.removeSegment(segment, DataSegmentChangeCallback.NOOP, false);
                                throw new SegmentLoadingException((Throwable)e, "Exception loading segment[%s]", new Object[]{segment.getId()});
                            }
                            try {
                                backgroundSegmentAnnouncer.announceSegment(segment);
                            }
                            catch (InterruptedException e) {
                                Thread.currentThread().interrupt();
                                throw new SegmentLoadingException((Throwable)e, "Loading Interrupted", new Object[0]);
                            }
                        }
                        catch (SegmentLoadingException e) {
                            log.error((Throwable)e, "[%s] failed to load", new Object[]{segment.getId()});
                            failedSegments.add(segment);
                        }
                        finally {
                            latch.countDown();
                        }
                    });
                }
                try {
                    latch.await();
                    if (!failedSegments.isEmpty()) {
                        log.makeAlert("[%,d] errors seen while loading segments on startup", new Object[]{failedSegments.size()}).addData("failedSegments", failedSegments).emit();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    log.makeAlert((Throwable)e, "LoadingInterrupted", new Object[0]).emit();
                }
                backgroundSegmentAnnouncer.finishAnnouncing();
            }
            bootstrapExecutor.shutdownNow();
        }
        catch (SegmentLoadingException e) {
            try {
                log.makeAlert((Throwable)e, "Failed to load segments on startup -- likely problem with announcing.", new Object[0]).addData("numSegments", (Object)segmentsOnStartup.size()).emit();
                bootstrapExecutor.shutdownNow();
            }
            catch (Throwable throwable) {
                bootstrapExecutor.shutdownNow();
                backgroundAnnouncerExecutor.shutdownNow();
                stopwatch.stop();
                this.segmentManager.shutdownBootstrap();
                log.info("Loaded [%d] segments on startup in [%,d]ms.", new Object[]{segmentsOnStartup.size(), stopwatch.millisElapsed()});
                throw throwable;
            }
            backgroundAnnouncerExecutor.shutdownNow();
            stopwatch.stop();
            this.segmentManager.shutdownBootstrap();
            log.info("Loaded [%d] segments on startup in [%,d]ms.", new Object[]{segmentsOnStartup.size(), stopwatch.millisElapsed()});
        }
        backgroundAnnouncerExecutor.shutdownNow();
        stopwatch.stop();
        this.segmentManager.shutdownBootstrap();
        log.info("Loaded [%d] segments on startup in [%,d]ms.", new Object[]{segmentsOnStartup.size(), stopwatch.millisElapsed()});
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<DataSegment> getBootstrapSegments() {
        Object bootstrapSegments;
        Stopwatch stopwatch;
        block6: {
            BroadcastDatasourceLoadingSpec.Mode mode = this.loadSpecHolder.getBroadcastDatasourceLoadingSpec().getMode();
            if (mode == BroadcastDatasourceLoadingSpec.Mode.NONE) {
                log.info("Skipping fetch of bootstrap segments.", new Object[0]);
                return ImmutableList.of();
            }
            log.info("Fetching bootstrap segments from the coordinator with BroadcastDatasourceLoadingSpec mode[%s].", new Object[]{mode});
            stopwatch = Stopwatch.createStarted();
            bootstrapSegments = new ArrayList();
            try {
                BootstrapSegmentsResponse response = (BootstrapSegmentsResponse)FutureUtils.getUnchecked(this.coordinatorClient.fetchBootstrapSegments(), (boolean)true);
                if (mode == BroadcastDatasourceLoadingSpec.Mode.ONLY_REQUIRED) {
                    ImmutableSet<String> broadcastDatasourcesToLoad = this.loadSpecHolder.getBroadcastDatasourceLoadingSpec().getBroadcastDatasourcesToLoad();
                    ArrayList filteredBroadcast = new ArrayList();
                    response.getIterator().forEachRemaining(segment -> {
                        if (broadcastDatasourcesToLoad.contains(segment.getDataSource())) {
                            filteredBroadcast.add(segment);
                        }
                    });
                    bootstrapSegments = filteredBroadcast;
                    break block6;
                }
                bootstrapSegments = ImmutableList.copyOf(response.getIterator());
            }
            catch (Exception e) {
                try {
                    log.warn("Error fetching bootstrap segments from the coordinator: [%s]. ", new Object[]{e.getMessage()});
                }
                catch (Throwable throwable) {
                    stopwatch.stop();
                    long fetchRunMillis = stopwatch.millisElapsed();
                    this.emitter.emit((ServiceEventBuilder)new ServiceMetricEvent.Builder().setMetric("segment/bootstrap/time", (Number)fetchRunMillis));
                    this.emitter.emit((ServiceEventBuilder)new ServiceMetricEvent.Builder().setMetric("segment/bootstrap/count", (Number)bootstrapSegments.size()));
                    log.info("Fetched [%d] bootstrap segments in [%d]ms.", new Object[]{bootstrapSegments.size(), fetchRunMillis});
                    throw throwable;
                }
                stopwatch.stop();
                long fetchRunMillis = stopwatch.millisElapsed();
                this.emitter.emit((ServiceEventBuilder)new ServiceMetricEvent.Builder().setMetric("segment/bootstrap/time", (Number)fetchRunMillis));
                this.emitter.emit((ServiceEventBuilder)new ServiceMetricEvent.Builder().setMetric("segment/bootstrap/count", (Number)bootstrapSegments.size()));
                log.info("Fetched [%d] bootstrap segments in [%d]ms.", new Object[]{bootstrapSegments.size(), fetchRunMillis});
            }
        }
        stopwatch.stop();
        long fetchRunMillis = stopwatch.millisElapsed();
        this.emitter.emit((ServiceEventBuilder)new ServiceMetricEvent.Builder().setMetric("segment/bootstrap/time", (Number)fetchRunMillis));
        this.emitter.emit((ServiceEventBuilder)new ServiceMetricEvent.Builder().setMetric("segment/bootstrap/count", (Number)bootstrapSegments.size()));
        log.info("Fetched [%d] bootstrap segments in [%d]ms.", new Object[]{bootstrapSegments.size(), fetchRunMillis});
        return bootstrapSegments;
    }

    private boolean shouldAnnounce() {
        return this.serverTypeConfig.getServerType().isSegmentServer() || this.segmentManager.canHandleSegments();
    }

    private static class BackgroundSegmentAnnouncer
    implements AutoCloseable {
        private static final EmittingLogger log = new EmittingLogger(BackgroundSegmentAnnouncer.class);
        private final int announceIntervalMillis;
        private final DataSegmentAnnouncer segmentAnnouncer;
        private final ScheduledExecutorService exec;
        private final LinkedBlockingQueue<DataSegment> queue;
        private final SettableFuture<Boolean> doneAnnouncing;
        private final Object lock = new Object();
        private volatile boolean finished = false;
        @Nullable
        private volatile ScheduledFuture startedAnnouncing = null;
        @Nullable
        private volatile ScheduledFuture nextAnnoucement = null;

        BackgroundSegmentAnnouncer(DataSegmentAnnouncer segmentAnnouncer, ScheduledExecutorService exec, int announceIntervalMillis) {
            this.segmentAnnouncer = segmentAnnouncer;
            this.exec = exec;
            this.announceIntervalMillis = announceIntervalMillis;
            this.queue = new LinkedBlockingQueue();
            this.doneAnnouncing = SettableFuture.create();
        }

        public void announceSegment(DataSegment segment) throws InterruptedException {
            if (this.finished) {
                throw new ISE("Announce segment called after finishAnnouncing", new Object[0]);
            }
            this.queue.put(segment);
        }

        public void startAnnouncing() {
            if (this.announceIntervalMillis <= 0) {
                log.info("Skipping background segment announcing as announceIntervalMillis is [%d].", new Object[]{this.announceIntervalMillis});
                return;
            }
            log.info("Starting background segment announcing task", new Object[0]);
            this.nextAnnoucement = this.startedAnnouncing = this.exec.schedule(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Object object = lock;
                    synchronized (object) {
                        try {
                            if (!finished || !queue.isEmpty()) {
                                ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
                                queue.drainTo(segments);
                                try {
                                    segmentAnnouncer.announceSegments(segments);
                                    nextAnnoucement = exec.schedule(this, (long)announceIntervalMillis, TimeUnit.MILLISECONDS);
                                }
                                catch (IOException e) {
                                    doneAnnouncing.setException((Throwable)new SegmentLoadingException((Throwable)e, "Failed to announce segments[%s]", new Object[]{segments}));
                                }
                            } else {
                                doneAnnouncing.set((Object)true);
                            }
                        }
                        catch (Exception e) {
                            doneAnnouncing.setException((Throwable)e);
                        }
                    }
                }
            }, (long)this.announceIntervalMillis, TimeUnit.MILLISECONDS);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void finishAnnouncing() throws SegmentLoadingException {
            Object object = this.lock;
            synchronized (object) {
                this.finished = true;
                try {
                    ArrayList<DataSegment> segments = new ArrayList<DataSegment>();
                    this.queue.drainTo(segments);
                    this.segmentAnnouncer.announceSegments(segments);
                }
                catch (Exception e) {
                    throw new SegmentLoadingException((Throwable)e, "Failed to announce segments[%s]", new Object[]{this.queue});
                }
                try {
                    if (this.startedAnnouncing != null) {
                        this.startedAnnouncing.cancel(false);
                    }
                    if (this.doneAnnouncing.isDone()) {
                        this.doneAnnouncing.get();
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new SegmentLoadingException((Throwable)e, "Loading Interrupted", new Object[0]);
                }
                catch (ExecutionException e) {
                    throw new SegmentLoadingException(e.getCause(), "Background Announcing Task Failed", new Object[0]);
                }
            }
            log.info("Completed background segment announcing", new Object[0]);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void close() {
            Object object = this.lock;
            synchronized (object) {
                this.finished = true;
                if (this.nextAnnoucement != null) {
                    this.nextAnnoucement.cancel(false);
                }
            }
        }
    }
}

