/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Comparator;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.annotations.SubclassesMustOverrideEqualsAndHashCode;
import org.apache.druid.java.util.common.guava.Comparators;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.CompactionTaskStatus;

@SubclassesMustOverrideEqualsAndHashCode
public abstract class BaseCandidateSearchPolicy
implements CompactionCandidateSearchPolicy {
    private final String priorityDatasource;
    private final Comparator<CompactionCandidate> comparator;

    protected BaseCandidateSearchPolicy(@Nullable String priorityDatasource) {
        this.priorityDatasource = priorityDatasource;
        this.comparator = priorityDatasource == null || priorityDatasource.isEmpty() ? this.getSegmentComparator() : Comparators.alwaysFirst((Object)priorityDatasource).onResultOf(CompactionCandidate::getDataSource).thenComparing(this.getSegmentComparator());
    }

    @Nullable
    @JsonProperty
    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public final String getPriorityDatasource() {
        return this.priorityDatasource;
    }

    @Override
    public final int compareCandidates(CompactionCandidate o1, CompactionCandidate o2) {
        return this.comparator.compare(o1, o2);
    }

    @Override
    public CompactionCandidateSearchPolicy.Eligibility checkEligibilityForCompaction(CompactionCandidate candidate, CompactionTaskStatus latestTaskStatus) {
        return CompactionCandidateSearchPolicy.Eligibility.OK;
    }

    protected abstract Comparator<CompactionCandidate> getSegmentComparator();

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        BaseCandidateSearchPolicy that = (BaseCandidateSearchPolicy)o;
        return Objects.equals(this.priorityDatasource, that.priorityDatasource);
    }

    public int hashCode() {
        return Objects.hashCode(this.priorityDatasource);
    }
}

